/*
 * Decompiled with CFR 0.152.
 */
package com.github.bhlangonijr.chesslib.game;

import com.github.bhlangonijr.chesslib.game.MovePerTime;
import com.github.bhlangonijr.chesslib.game.TimeControlType;
import java.util.ArrayList;
import java.util.List;

public class TimeControl {
    private final List<MovePerTime> movePerTime = new ArrayList<MovePerTime>();
    private TimeControlType timeControlType;
    private int halfMoves = 0;
    private long milliseconds = 0L;
    private long increment = 0L;
    private int depth = 0;
    private long nodes;

    public static TimeControl parseFromString(String s) {
        TimeControl tc = new TimeControl();
        if ((s = s.replace("|", "+")).equals("?") || s.equals("-")) {
            tc.setTimeControlType(TimeControlType.UNKNOW);
            return tc;
        }
        if (s.indexOf(":") >= 0) {
            for (String field : s.split(":")) {
                TimeControl.parseTC(field, tc);
            }
        } else {
            TimeControl.parseTC(s, tc);
        }
        return tc;
    }

    private static void parseTC(String s, TimeControl tc) {
        if (s.indexOf("/") >= 0) {
            tc.setTimeControlType(TimeControlType.MOVES_PER_TIME);
            TimeControl.parseMT(s, tc);
        } else if (s.indexOf("+") >= 0) {
            tc.setTimeControlType(TimeControlType.TIME_BONUS);
            TimeControl.parseTM(s, tc);
        } else {
            tc.setTimeControlType(TimeControlType.TIME_BONUS);
            tc.milliseconds = Integer.parseInt(s) * 1000;
        }
    }

    private static void parseTM(String s, TimeControl tc) {
        String[] tm = s.split("\\+");
        tc.setIncrement(Integer.parseInt(tm[1]) * 1000);
        if (tm[0].indexOf("/") >= 0) {
            TimeControl.parseMT(tm[0], tc);
        } else {
            tc.setMilliseconds(Integer.parseInt(tm[0]) * 1000);
        }
    }

    private static void parseMT(String s, TimeControl tc) {
        String[] tm = s.split("/");
        int moves = Integer.parseInt(tm[0]);
        int milliseconds = Integer.parseInt(tm[1]) * 1000;
        if (tc.getHalfMoves() == 0) {
            tc.setHalfMoves(moves);
            if (tm[1].indexOf("+") >= 0) {
                TimeControl.parseTM(tm[1], tc);
            } else {
                tc.setMilliseconds(milliseconds);
            }
        } else {
            tc.getMovePerTime().add(new MovePerTime(moves, milliseconds));
        }
    }

    public TimeControlType getTimeControlType() {
        return this.timeControlType;
    }

    public void setTimeControlType(TimeControlType timeControlType) {
        this.timeControlType = timeControlType;
    }

    public int getHalfMoves() {
        return this.halfMoves;
    }

    public void setHalfMoves(int halfMoves) {
        this.halfMoves = halfMoves;
    }

    public long getMilliseconds() {
        return this.milliseconds;
    }

    public void setMilliseconds(long milliseconds) {
        this.milliseconds = milliseconds;
    }

    public long getIncrement() {
        return this.increment;
    }

    public void setIncrement(long increment) {
        this.increment = increment;
    }

    public long getNodes() {
        return this.nodes;
    }

    public void setNodes(long nodes) {
        this.nodes = nodes;
    }

    public List<MovePerTime> getMovePerTime() {
        return this.movePerTime;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public String toPGNString() {
        if (this.getTimeControlType().equals((Object)TimeControlType.UNKNOW)) {
            return "?";
        }
        StringBuilder s = new StringBuilder();
        if (this.getHalfMoves() > 0) {
            s.append(this.getHalfMoves());
            s.append("/");
            s.append(this.getMilliseconds() / 1000L);
        } else if (this.getMilliseconds() >= 0L) {
            s.append(this.getMilliseconds() / 1000L);
        }
        if (this.getIncrement() > 0L) {
            s.append("+");
            s.append(this.getIncrement() / 1000L);
        }
        if (this.getMovePerTime().size() > 0) {
            for (MovePerTime mt : this.getMovePerTime()) {
                s.append(":");
                s.append(mt.toPGNString());
            }
        }
        return s.toString();
    }

    public String toString() {
        if (this.getTimeControlType().equals((Object)TimeControlType.UNKNOW)) {
            return "Custom...";
        }
        StringBuilder s = new StringBuilder();
        if (this.getHalfMoves() > 0) {
            s.append(this.getHalfMoves());
            s.append(" Moves / ");
            s.append(this.getMilliseconds() / 1000L);
            s.append(" Sec");
        } else if (this.getMilliseconds() >= 0L) {
            s.append(this.getMilliseconds() / 1000L / 60L);
            s.append(" Min");
        }
        if (this.getIncrement() > 0L) {
            s.append(" + ");
            s.append(this.getIncrement() / 1000L);
            s.append(" Sec");
        }
        if (this.getMovePerTime().size() > 0) {
            for (MovePerTime mt : this.getMovePerTime()) {
                s.append(" : ");
                s.append(mt.toString());
            }
        }
        return s.toString();
    }
}

