/*
 * Decompiled with CFR 0.152.
 */
package com.github.bhlangonijr.chesslib;

import com.github.bhlangonijr.chesslib.DiagonalA1H8;
import com.github.bhlangonijr.chesslib.DiagonalH1A8;
import com.github.bhlangonijr.chesslib.File;
import com.github.bhlangonijr.chesslib.Rank;
import com.github.bhlangonijr.chesslib.Side;
import com.github.bhlangonijr.chesslib.Square;
import java.util.LinkedList;
import java.util.List;

public class Bitboard {
    public static final long lightSquares = 0x55AA55AA55AA55AAL;
    public static final long darkSquares = -6172840429334713771L;
    static final long[] rankBB = new long[]{255L, 65280L, 0xFF0000L, 0xFF000000L, 0xFF00000000L, 0xFF0000000000L, 0xFF000000000000L, -72057594037927936L};
    static final long[] fileBB = new long[]{0x101010101010101L, 0x202020202020202L, 0x404040404040404L, 0x808080808080808L, 0x1010101010101010L, 0x2020202020202020L, 0x4040404040404040L, -9187201950435737472L};
    static final long[][] bbTable = new long[64][64];
    static final DiagonalA1H8[] squareToDiagonalA1H8 = new DiagonalA1H8[]{DiagonalA1H8.H8_A1, DiagonalA1H8.B1_H7, DiagonalA1H8.C1_H6, DiagonalA1H8.D1_H5, DiagonalA1H8.E1_H4, DiagonalA1H8.F1_H3, DiagonalA1H8.G1_H2, DiagonalA1H8.H1_H1, DiagonalA1H8.G8_A2, DiagonalA1H8.H8_A1, DiagonalA1H8.B1_H7, DiagonalA1H8.C1_H6, DiagonalA1H8.D1_H5, DiagonalA1H8.E1_H4, DiagonalA1H8.F1_H3, DiagonalA1H8.G1_H2, DiagonalA1H8.F8_A3, DiagonalA1H8.G8_A2, DiagonalA1H8.H8_A1, DiagonalA1H8.B1_H7, DiagonalA1H8.C1_H6, DiagonalA1H8.D1_H5, DiagonalA1H8.E1_H4, DiagonalA1H8.F1_H3, DiagonalA1H8.E8_A4, DiagonalA1H8.F8_A3, DiagonalA1H8.G8_A2, DiagonalA1H8.H8_A1, DiagonalA1H8.B1_H7, DiagonalA1H8.C1_H6, DiagonalA1H8.D1_H5, DiagonalA1H8.E1_H4, DiagonalA1H8.D8_A5, DiagonalA1H8.E8_A4, DiagonalA1H8.F8_A3, DiagonalA1H8.G8_A2, DiagonalA1H8.H8_A1, DiagonalA1H8.B1_H7, DiagonalA1H8.C1_H6, DiagonalA1H8.D1_H5, DiagonalA1H8.C8_A6, DiagonalA1H8.D8_A5, DiagonalA1H8.E8_A4, DiagonalA1H8.F8_A3, DiagonalA1H8.G8_A2, DiagonalA1H8.H8_A1, DiagonalA1H8.B1_H7, DiagonalA1H8.C1_H6, DiagonalA1H8.B8_A7, DiagonalA1H8.C8_A6, DiagonalA1H8.D8_A5, DiagonalA1H8.E8_A4, DiagonalA1H8.F8_A3, DiagonalA1H8.G8_A2, DiagonalA1H8.H8_A1, DiagonalA1H8.B1_H7, DiagonalA1H8.A8_A8, DiagonalA1H8.B8_A7, DiagonalA1H8.C8_A6, DiagonalA1H8.D8_A5, DiagonalA1H8.E8_A4, DiagonalA1H8.F8_A3, DiagonalA1H8.G8_A2, DiagonalA1H8.H8_A1};
    static final DiagonalH1A8[] squareToDiagonalH1A8 = new DiagonalH1A8[]{DiagonalH1A8.A1_A1, DiagonalH1A8.B1_A2, DiagonalH1A8.C1_A3, DiagonalH1A8.D1_A4, DiagonalH1A8.E1_A5, DiagonalH1A8.F1_A6, DiagonalH1A8.G1_A7, DiagonalH1A8.H1_A8, DiagonalH1A8.B1_A2, DiagonalH1A8.C1_A3, DiagonalH1A8.D1_A4, DiagonalH1A8.E1_A5, DiagonalH1A8.F1_A6, DiagonalH1A8.G1_A7, DiagonalH1A8.H1_A8, DiagonalH1A8.B8_H2, DiagonalH1A8.C1_A3, DiagonalH1A8.D1_A4, DiagonalH1A8.E1_A5, DiagonalH1A8.F1_A6, DiagonalH1A8.G1_A7, DiagonalH1A8.H1_A8, DiagonalH1A8.B8_H2, DiagonalH1A8.C8_H3, DiagonalH1A8.D1_A4, DiagonalH1A8.E1_A5, DiagonalH1A8.F1_A6, DiagonalH1A8.G1_A7, DiagonalH1A8.H1_A8, DiagonalH1A8.B8_H2, DiagonalH1A8.C8_H3, DiagonalH1A8.D8_H4, DiagonalH1A8.E1_A5, DiagonalH1A8.F1_A6, DiagonalH1A8.G1_A7, DiagonalH1A8.H1_A8, DiagonalH1A8.B8_H2, DiagonalH1A8.C8_H3, DiagonalH1A8.D8_H4, DiagonalH1A8.E8_H5, DiagonalH1A8.F1_A6, DiagonalH1A8.G1_A7, DiagonalH1A8.H1_A8, DiagonalH1A8.B8_H2, DiagonalH1A8.C8_H3, DiagonalH1A8.D8_H4, DiagonalH1A8.E8_H5, DiagonalH1A8.F8_H6, DiagonalH1A8.G1_A7, DiagonalH1A8.H1_A8, DiagonalH1A8.B8_H2, DiagonalH1A8.C8_H3, DiagonalH1A8.D8_H4, DiagonalH1A8.E8_H5, DiagonalH1A8.F8_H6, DiagonalH1A8.G8_H7, DiagonalH1A8.H1_A8, DiagonalH1A8.B8_H2, DiagonalH1A8.C8_H3, DiagonalH1A8.D8_H4, DiagonalH1A8.E8_H5, DiagonalH1A8.F8_H6, DiagonalH1A8.G8_H7, DiagonalH1A8.H8_H8};
    static final long[] diagonalH1A8BB = new long[]{Bitboard.sq2Bb(Square.A1), Bitboard.sq2Bb(Square.B1) | Bitboard.sq2Bb(Square.A2), Bitboard.sq2Bb(Square.C1) | Bitboard.sq2Bb(Square.B2) | Bitboard.sq2Bb(Square.A3), Bitboard.sq2Bb(Square.D1) | Bitboard.sq2Bb(Square.C2) | Bitboard.sq2Bb(Square.B3) | Bitboard.sq2Bb(Square.A4), Bitboard.sq2Bb(Square.E1) | Bitboard.sq2Bb(Square.D2) | Bitboard.sq2Bb(Square.C3) | Bitboard.sq2Bb(Square.B4) | Bitboard.sq2Bb(Square.A5), Bitboard.sq2Bb(Square.F1) | Bitboard.sq2Bb(Square.E2) | Bitboard.sq2Bb(Square.D3) | Bitboard.sq2Bb(Square.C4) | Bitboard.sq2Bb(Square.B5) | Bitboard.sq2Bb(Square.A6), Bitboard.sq2Bb(Square.G1) | Bitboard.sq2Bb(Square.F2) | Bitboard.sq2Bb(Square.E3) | Bitboard.sq2Bb(Square.D4) | Bitboard.sq2Bb(Square.C5) | Bitboard.sq2Bb(Square.B6) | Bitboard.sq2Bb(Square.A7), Bitboard.sq2Bb(Square.H1) | Bitboard.sq2Bb(Square.G2) | Bitboard.sq2Bb(Square.F3) | Bitboard.sq2Bb(Square.E4) | Bitboard.sq2Bb(Square.D5) | Bitboard.sq2Bb(Square.C6) | Bitboard.sq2Bb(Square.B7) | Bitboard.sq2Bb(Square.A8), Bitboard.sq2Bb(Square.B8) | Bitboard.sq2Bb(Square.C7) | Bitboard.sq2Bb(Square.D6) | Bitboard.sq2Bb(Square.E5) | Bitboard.sq2Bb(Square.F4) | Bitboard.sq2Bb(Square.G3) | Bitboard.sq2Bb(Square.H2), Bitboard.sq2Bb(Square.C8) | Bitboard.sq2Bb(Square.D7) | Bitboard.sq2Bb(Square.E6) | Bitboard.sq2Bb(Square.F5) | Bitboard.sq2Bb(Square.G4) | Bitboard.sq2Bb(Square.H3), Bitboard.sq2Bb(Square.D8) | Bitboard.sq2Bb(Square.E7) | Bitboard.sq2Bb(Square.F6) | Bitboard.sq2Bb(Square.G5) | Bitboard.sq2Bb(Square.H4), Bitboard.sq2Bb(Square.E8) | Bitboard.sq2Bb(Square.F7) | Bitboard.sq2Bb(Square.G6) | Bitboard.sq2Bb(Square.H5), Bitboard.sq2Bb(Square.F8) | Bitboard.sq2Bb(Square.G7) | Bitboard.sq2Bb(Square.H6), Bitboard.sq2Bb(Square.G8) | Bitboard.sq2Bb(Square.H7), Bitboard.sq2Bb(Square.H8)};
    static final long[] diagonalA1H8BB = new long[]{Bitboard.sq2Bb(Square.A8), Bitboard.sq2Bb(Square.B8) | Bitboard.sq2Bb(Square.A7), Bitboard.sq2Bb(Square.C8) | Bitboard.sq2Bb(Square.B7) | Bitboard.sq2Bb(Square.A6), Bitboard.sq2Bb(Square.D8) | Bitboard.sq2Bb(Square.C7) | Bitboard.sq2Bb(Square.B6) | Bitboard.sq2Bb(Square.A5), Bitboard.sq2Bb(Square.E8) | Bitboard.sq2Bb(Square.D7) | Bitboard.sq2Bb(Square.C6) | Bitboard.sq2Bb(Square.B5) | Bitboard.sq2Bb(Square.A4), Bitboard.sq2Bb(Square.F8) | Bitboard.sq2Bb(Square.E7) | Bitboard.sq2Bb(Square.D6) | Bitboard.sq2Bb(Square.C5) | Bitboard.sq2Bb(Square.B4) | Bitboard.sq2Bb(Square.A3), Bitboard.sq2Bb(Square.G8) | Bitboard.sq2Bb(Square.F7) | Bitboard.sq2Bb(Square.E6) | Bitboard.sq2Bb(Square.D5) | Bitboard.sq2Bb(Square.C4) | Bitboard.sq2Bb(Square.B3) | Bitboard.sq2Bb(Square.A2), Bitboard.sq2Bb(Square.H8) | Bitboard.sq2Bb(Square.G7) | Bitboard.sq2Bb(Square.F6) | Bitboard.sq2Bb(Square.E5) | Bitboard.sq2Bb(Square.D4) | Bitboard.sq2Bb(Square.C3) | Bitboard.sq2Bb(Square.B2) | Bitboard.sq2Bb(Square.A1), Bitboard.sq2Bb(Square.B1) | Bitboard.sq2Bb(Square.C2) | Bitboard.sq2Bb(Square.D3) | Bitboard.sq2Bb(Square.E4) | Bitboard.sq2Bb(Square.F5) | Bitboard.sq2Bb(Square.G6) | Bitboard.sq2Bb(Square.H7), Bitboard.sq2Bb(Square.C1) | Bitboard.sq2Bb(Square.D2) | Bitboard.sq2Bb(Square.E3) | Bitboard.sq2Bb(Square.F4) | Bitboard.sq2Bb(Square.G5) | Bitboard.sq2Bb(Square.H6), Bitboard.sq2Bb(Square.D1) | Bitboard.sq2Bb(Square.E2) | Bitboard.sq2Bb(Square.F3) | Bitboard.sq2Bb(Square.G4) | Bitboard.sq2Bb(Square.H5), Bitboard.sq2Bb(Square.E1) | Bitboard.sq2Bb(Square.F2) | Bitboard.sq2Bb(Square.G3) | Bitboard.sq2Bb(Square.H4), Bitboard.sq2Bb(Square.F1) | Bitboard.sq2Bb(Square.G2) | Bitboard.sq2Bb(Square.H3), Bitboard.sq2Bb(Square.G1) | Bitboard.sq2Bb(Square.H2), Bitboard.sq2Bb(Square.H1)};
    static final long[] knightAttacks = new long[]{132096L, 329728L, 659712L, 1319424L, 2638848L, 0x508800L, 0xA01000L, 0x402000L, 0x2040004L, 0x5080008L, 0xA110011L, 337772578L, 675545156L, 0x50880088L, 0xA0100010L, 0x40200020L, 0x204000402L, 0x508000805L, 0xA1100110AL, 86469779988L, 172939559976L, 0x5088008850L, 0xA0100010A0L, 0x4020002040L, 0x20400040200L, 0x50800080500L, 0xA1100110A00L, 22136263676928L, 44272527353856L, 0x508800885000L, 0xA0100010A000L, 0x402000204000L, 0x2040004020000L, 0x5080008050000L, 0xA1100110A0000L, 5666883501293568L, 11333767002587136L, 0x50880088500000L, 0xA0100010A00000L, 0x40200020400000L, 0x204000402000000L, 0x508000805000000L, 0xA1100110A000000L, 1450722176331153408L, 2901444352662306816L, 0x5088008850000000L, -6913025356609880064L, 0x4020002040000000L, 0x400040200000000L, 0x800080500000000L, 0x1100110A00000000L, 2449995666584240128L, 4899991333168480256L, -8646761407372591104L, 0x100010A000000000L, 0x2000204000000000L, 0x4020000000000L, 0x8050000000000L, 0x110A0000000000L, 9592139440717824L, 19184278881435648L, 0x88500000000000L, 0x10A00000000000L, 0x20400000000000L};
    static final long[] whitePawnAttacks = new long[]{512L, 1280L, 2560L, 5120L, 10240L, 20480L, 40960L, 16384L, 131072L, 327680L, 655360L, 0x140000L, 0x280000L, 0x500000L, 0xA00000L, 0x400000L, 0x2000000L, 0x5000000L, 0xA000000L, 0x14000000L, 0x28000000L, 0x50000000L, 0xA0000000L, 0x40000000L, 0x200000000L, 0x500000000L, 0xA00000000L, 0x1400000000L, 0x2800000000L, 0x5000000000L, 0xA000000000L, 0x4000000000L, 0x20000000000L, 0x50000000000L, 0xA0000000000L, 0x140000000000L, 0x280000000000L, 0x500000000000L, 0xA00000000000L, 0x400000000000L, 0x2000000000000L, 0x5000000000000L, 0xA000000000000L, 0x14000000000000L, 0x28000000000000L, 0x50000000000000L, 0xA0000000000000L, 0x40000000000000L, 0x200000000000000L, 0x500000000000000L, 0xA00000000000000L, 0x1400000000000000L, 0x2800000000000000L, 0x5000000000000000L, -6917529027641081856L, 0x4000000000000000L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
    static final long[] blackPawnAttacks = new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 2L, 5L, 10L, 20L, 40L, 80L, 160L, 64L, 512L, 1280L, 2560L, 5120L, 10240L, 20480L, 40960L, 16384L, 131072L, 327680L, 655360L, 0x140000L, 0x280000L, 0x500000L, 0xA00000L, 0x400000L, 0x2000000L, 0x5000000L, 0xA000000L, 0x14000000L, 0x28000000L, 0x50000000L, 0xA0000000L, 0x40000000L, 0x200000000L, 0x500000000L, 0xA00000000L, 0x1400000000L, 0x2800000000L, 0x5000000000L, 0xA000000000L, 0x4000000000L, 0x20000000000L, 0x50000000000L, 0xA0000000000L, 0x140000000000L, 0x280000000000L, 0x500000000000L, 0xA00000000000L, 0x400000000000L, 0x2000000000000L, 0x5000000000000L, 0xA000000000000L, 0x14000000000000L, 0x28000000000000L, 0x50000000000000L, 0xA0000000000000L, 0x40000000000000L};
    static final long[] whitePawnMoves = new long[]{256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 0x1010000L, 0x2020000L, 0x4040000L, 0x8080000L, 0x10100000L, 0x20200000L, 0x40400000L, 0x80800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L, 0x80000000L, 0x100000000L, 0x200000000L, 0x400000000L, 0x800000000L, 0x1000000000L, 0x2000000000L, 0x4000000000L, 0x8000000000L, 0x10000000000L, 0x20000000000L, 0x40000000000L, 0x80000000000L, 0x100000000000L, 0x200000000000L, 0x400000000000L, 0x800000000000L, 0x1000000000000L, 0x2000000000000L, 0x4000000000000L, 0x8000000000000L, 0x10000000000000L, 0x20000000000000L, 0x40000000000000L, 0x80000000000000L, 0x100000000000000L, 0x200000000000000L, 0x400000000000000L, 0x800000000000000L, 0x1000000000000000L, 0x2000000000000000L, 0x4000000000000000L, Long.MIN_VALUE, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L};
    static final long[] blackPawnMoves = new long[]{0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L, 1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L, 0x800000L, 0x1000000L, 0x2000000L, 0x4000000L, 0x8000000L, 0x10000000L, 0x20000000L, 0x40000000L, 0x80000000L, 0x100000000L, 0x200000000L, 0x400000000L, 0x800000000L, 0x1000000000L, 0x2000000000L, 0x4000000000L, 0x8000000000L, 0x10100000000L, 0x20200000000L, 0x40400000000L, 0x80800000000L, 0x101000000000L, 0x202000000000L, 0x404000000000L, 0x808000000000L, 0x1000000000000L, 0x2000000000000L, 0x4000000000000L, 0x8000000000000L, 0x10000000000000L, 0x20000000000000L, 0x40000000000000L, 0x80000000000000L};
    static final long[] adjacentSquares = new long[]{770L, 1797L, 3594L, 7188L, 14376L, 28752L, 57504L, 49216L, 197123L, 460039L, 920078L, 0x1C141CL, 0x382838L, 0x705070L, 0xE0A0E0L, 0xC040C0L, 0x3020300L, 0x7050700L, 0xE0A0E00L, 471079936L, 942159872L, 0x70507000L, 0xE0A0E000L, 0xC040C000L, 0x302030000L, 0x705070000L, 0xE0A0E0000L, 120596463616L, 241192927232L, 0x7050700000L, 0xE0A0E00000L, 0xC040C00000L, 0x30203000000L, 0x70507000000L, 0xE0A0E000000L, 30872694685696L, 61745389371392L, 0x705070000000L, 0xE0A0E0000000L, 0xC040C0000000L, 0x3020300000000L, 0x7050700000000L, 0xE0A0E00000000L, 7903409839538176L, 15806819679076352L, 0x70507000000000L, 0xE0A0E000000000L, 0xC040C000000000L, 0x302030000000000L, 0x705070000000000L, 0xE0A0E0000000000L, 2023272918921773056L, 4046545837843546112L, 0x7050700000000000L, -2260560722335367168L, -4593460513685372928L, 0x203000000000000L, 0x507000000000000L, 0xA0E000000000000L, 1449033180106457088L, 2898066360212914176L, 0x5070000000000000L, -6854478632857894912L, 0x40C0000000000000L};
    static final long[] rankAttacks = new long[]{Bitboard.sq2RA(Square.A1), Bitboard.sq2RA(Square.B1), Bitboard.sq2RA(Square.C1), Bitboard.sq2RA(Square.D1), Bitboard.sq2RA(Square.E1), Bitboard.sq2RA(Square.F1), Bitboard.sq2RA(Square.G1), Bitboard.sq2RA(Square.H1), Bitboard.sq2RA(Square.A2), Bitboard.sq2RA(Square.B2), Bitboard.sq2RA(Square.C2), Bitboard.sq2RA(Square.D2), Bitboard.sq2RA(Square.E2), Bitboard.sq2RA(Square.F2), Bitboard.sq2RA(Square.G2), Bitboard.sq2RA(Square.H2), Bitboard.sq2RA(Square.A3), Bitboard.sq2RA(Square.B3), Bitboard.sq2RA(Square.C3), Bitboard.sq2RA(Square.D3), Bitboard.sq2RA(Square.E3), Bitboard.sq2RA(Square.F3), Bitboard.sq2RA(Square.G3), Bitboard.sq2RA(Square.H3), Bitboard.sq2RA(Square.A4), Bitboard.sq2RA(Square.B4), Bitboard.sq2RA(Square.C4), Bitboard.sq2RA(Square.D4), Bitboard.sq2RA(Square.E4), Bitboard.sq2RA(Square.F4), Bitboard.sq2RA(Square.G4), Bitboard.sq2RA(Square.H4), Bitboard.sq2RA(Square.A5), Bitboard.sq2RA(Square.B5), Bitboard.sq2RA(Square.C5), Bitboard.sq2RA(Square.D5), Bitboard.sq2RA(Square.E5), Bitboard.sq2RA(Square.F5), Bitboard.sq2RA(Square.G5), Bitboard.sq2RA(Square.H5), Bitboard.sq2RA(Square.A6), Bitboard.sq2RA(Square.B6), Bitboard.sq2RA(Square.C6), Bitboard.sq2RA(Square.D6), Bitboard.sq2RA(Square.E6), Bitboard.sq2RA(Square.F6), Bitboard.sq2RA(Square.G6), Bitboard.sq2RA(Square.H6), Bitboard.sq2RA(Square.A7), Bitboard.sq2RA(Square.B7), Bitboard.sq2RA(Square.C7), Bitboard.sq2RA(Square.D7), Bitboard.sq2RA(Square.E7), Bitboard.sq2RA(Square.F7), Bitboard.sq2RA(Square.G7), Bitboard.sq2RA(Square.H7), Bitboard.sq2RA(Square.A8), Bitboard.sq2RA(Square.B8), Bitboard.sq2RA(Square.C8), Bitboard.sq2RA(Square.D8), Bitboard.sq2RA(Square.E8), Bitboard.sq2RA(Square.F8), Bitboard.sq2RA(Square.G8), Bitboard.sq2RA(Square.H8)};
    static final long[] fileAttacks = new long[]{Bitboard.sq2FA(Square.A1), Bitboard.sq2FA(Square.B1), Bitboard.sq2FA(Square.C1), Bitboard.sq2FA(Square.D1), Bitboard.sq2FA(Square.E1), Bitboard.sq2FA(Square.F1), Bitboard.sq2FA(Square.G1), Bitboard.sq2FA(Square.H1), Bitboard.sq2FA(Square.A2), Bitboard.sq2FA(Square.B2), Bitboard.sq2FA(Square.C2), Bitboard.sq2FA(Square.D2), Bitboard.sq2FA(Square.E2), Bitboard.sq2FA(Square.F2), Bitboard.sq2FA(Square.G2), Bitboard.sq2FA(Square.H2), Bitboard.sq2FA(Square.A3), Bitboard.sq2FA(Square.B3), Bitboard.sq2FA(Square.C3), Bitboard.sq2FA(Square.D3), Bitboard.sq2FA(Square.E3), Bitboard.sq2FA(Square.F3), Bitboard.sq2FA(Square.G3), Bitboard.sq2FA(Square.H3), Bitboard.sq2FA(Square.A4), Bitboard.sq2FA(Square.B4), Bitboard.sq2FA(Square.C4), Bitboard.sq2FA(Square.D4), Bitboard.sq2FA(Square.E4), Bitboard.sq2FA(Square.F4), Bitboard.sq2FA(Square.G4), Bitboard.sq2FA(Square.H4), Bitboard.sq2FA(Square.A5), Bitboard.sq2FA(Square.B5), Bitboard.sq2FA(Square.C5), Bitboard.sq2FA(Square.D5), Bitboard.sq2FA(Square.E5), Bitboard.sq2FA(Square.F5), Bitboard.sq2FA(Square.G5), Bitboard.sq2FA(Square.H5), Bitboard.sq2FA(Square.A6), Bitboard.sq2FA(Square.B6), Bitboard.sq2FA(Square.C6), Bitboard.sq2FA(Square.D6), Bitboard.sq2FA(Square.E6), Bitboard.sq2FA(Square.F6), Bitboard.sq2FA(Square.G6), Bitboard.sq2FA(Square.H6), Bitboard.sq2FA(Square.A7), Bitboard.sq2FA(Square.B7), Bitboard.sq2FA(Square.C7), Bitboard.sq2FA(Square.D7), Bitboard.sq2FA(Square.E7), Bitboard.sq2FA(Square.F7), Bitboard.sq2FA(Square.G7), Bitboard.sq2FA(Square.H7), Bitboard.sq2FA(Square.A8), Bitboard.sq2FA(Square.B8), Bitboard.sq2FA(Square.C8), Bitboard.sq2FA(Square.D8), Bitboard.sq2FA(Square.E8), Bitboard.sq2FA(Square.F8), Bitboard.sq2FA(Square.G8), Bitboard.sq2FA(Square.H8)};
    static final long[] diagA1H8Attacks = new long[]{Bitboard.sq2A1(Square.A1), Bitboard.sq2A1(Square.B1), Bitboard.sq2A1(Square.C1), Bitboard.sq2A1(Square.D1), Bitboard.sq2A1(Square.E1), Bitboard.sq2A1(Square.F1), Bitboard.sq2A1(Square.G1), Bitboard.sq2A1(Square.H1), Bitboard.sq2A1(Square.A2), Bitboard.sq2A1(Square.B2), Bitboard.sq2A1(Square.C2), Bitboard.sq2A1(Square.D2), Bitboard.sq2A1(Square.E2), Bitboard.sq2A1(Square.F2), Bitboard.sq2A1(Square.G2), Bitboard.sq2A1(Square.H2), Bitboard.sq2A1(Square.A3), Bitboard.sq2A1(Square.B3), Bitboard.sq2A1(Square.C3), Bitboard.sq2A1(Square.D3), Bitboard.sq2A1(Square.E3), Bitboard.sq2A1(Square.F3), Bitboard.sq2A1(Square.G3), Bitboard.sq2A1(Square.H3), Bitboard.sq2A1(Square.A4), Bitboard.sq2A1(Square.B4), Bitboard.sq2A1(Square.C4), Bitboard.sq2A1(Square.D4), Bitboard.sq2A1(Square.E4), Bitboard.sq2A1(Square.F4), Bitboard.sq2A1(Square.G4), Bitboard.sq2A1(Square.H4), Bitboard.sq2A1(Square.A5), Bitboard.sq2A1(Square.B5), Bitboard.sq2A1(Square.C5), Bitboard.sq2A1(Square.D5), Bitboard.sq2A1(Square.E5), Bitboard.sq2A1(Square.F5), Bitboard.sq2A1(Square.G5), Bitboard.sq2A1(Square.H5), Bitboard.sq2A1(Square.A6), Bitboard.sq2A1(Square.B6), Bitboard.sq2A1(Square.C6), Bitboard.sq2A1(Square.D6), Bitboard.sq2A1(Square.E6), Bitboard.sq2A1(Square.F6), Bitboard.sq2A1(Square.G6), Bitboard.sq2A1(Square.H6), Bitboard.sq2A1(Square.A7), Bitboard.sq2A1(Square.B7), Bitboard.sq2A1(Square.C7), Bitboard.sq2A1(Square.D7), Bitboard.sq2A1(Square.E7), Bitboard.sq2A1(Square.F7), Bitboard.sq2A1(Square.G7), Bitboard.sq2A1(Square.H7), Bitboard.sq2A1(Square.A8), Bitboard.sq2A1(Square.B8), Bitboard.sq2A1(Square.C8), Bitboard.sq2A1(Square.D8), Bitboard.sq2A1(Square.E8), Bitboard.sq2A1(Square.F8), Bitboard.sq2A1(Square.G8), Bitboard.sq2A1(Square.H8)};
    static final long[] diagH1A8Attacks = new long[]{Bitboard.sq2H1(Square.A1), Bitboard.sq2H1(Square.B1), Bitboard.sq2H1(Square.C1), Bitboard.sq2H1(Square.D1), Bitboard.sq2H1(Square.E1), Bitboard.sq2H1(Square.F1), Bitboard.sq2H1(Square.G1), Bitboard.sq2H1(Square.H1), Bitboard.sq2H1(Square.A2), Bitboard.sq2H1(Square.B2), Bitboard.sq2H1(Square.C2), Bitboard.sq2H1(Square.D2), Bitboard.sq2H1(Square.E2), Bitboard.sq2H1(Square.F2), Bitboard.sq2H1(Square.G2), Bitboard.sq2H1(Square.H2), Bitboard.sq2H1(Square.A3), Bitboard.sq2H1(Square.B3), Bitboard.sq2H1(Square.C3), Bitboard.sq2H1(Square.D3), Bitboard.sq2H1(Square.E3), Bitboard.sq2H1(Square.F3), Bitboard.sq2H1(Square.G3), Bitboard.sq2H1(Square.H3), Bitboard.sq2H1(Square.A4), Bitboard.sq2H1(Square.B4), Bitboard.sq2H1(Square.C4), Bitboard.sq2H1(Square.D4), Bitboard.sq2H1(Square.E4), Bitboard.sq2H1(Square.F4), Bitboard.sq2H1(Square.G4), Bitboard.sq2H1(Square.H4), Bitboard.sq2H1(Square.A5), Bitboard.sq2H1(Square.B5), Bitboard.sq2H1(Square.C5), Bitboard.sq2H1(Square.D5), Bitboard.sq2H1(Square.E5), Bitboard.sq2H1(Square.F5), Bitboard.sq2H1(Square.G5), Bitboard.sq2H1(Square.H5), Bitboard.sq2H1(Square.A6), Bitboard.sq2H1(Square.B6), Bitboard.sq2H1(Square.C6), Bitboard.sq2H1(Square.D6), Bitboard.sq2H1(Square.E6), Bitboard.sq2H1(Square.F6), Bitboard.sq2H1(Square.G6), Bitboard.sq2H1(Square.H6), Bitboard.sq2H1(Square.A7), Bitboard.sq2H1(Square.B7), Bitboard.sq2H1(Square.C7), Bitboard.sq2H1(Square.D7), Bitboard.sq2H1(Square.E7), Bitboard.sq2H1(Square.F7), Bitboard.sq2H1(Square.G7), Bitboard.sq2H1(Square.H7), Bitboard.sq2H1(Square.A8), Bitboard.sq2H1(Square.B8), Bitboard.sq2H1(Square.C8), Bitboard.sq2H1(Square.D8), Bitboard.sq2H1(Square.E8), Bitboard.sq2H1(Square.F8), Bitboard.sq2H1(Square.G8), Bitboard.sq2H1(Square.H8)};

    static final long sq2Bb(Square sq) {
        return sq.getBitboard();
    }

    static final long sq2RA(Square x) {
        return rankBB[x.getRank().ordinal()] ^ Bitboard.sq2Bb(x);
    }

    static final long sq2FA(Square x) {
        return fileBB[x.getFile().ordinal()] ^ x.getBitboard();
    }

    static final long sq2A1(Square x) {
        return diagonalA1H8BB[squareToDiagonalA1H8[x.ordinal()].ordinal()] ^ Bitboard.sq2Bb(x);
    }

    static final long sq2H1(Square x) {
        return diagonalH1A8BB[squareToDiagonalH1A8[x.ordinal()].ordinal()] ^ Bitboard.sq2Bb(x);
    }

    public static int bitScanForward(long bb) {
        return Long.numberOfTrailingZeros(bb);
    }

    public static int bitScanReverse(long bb) {
        return 63 - Long.numberOfLeadingZeros(bb);
    }

    public static long bitsBetween(long bb, int sq1, int sq2) {
        return bbTable[sq1][sq2] & bb;
    }

    public static long extractLsb(Long bb) {
        return bb & bb - 1L;
    }

    public static boolean hasOnly1Bit(Long bb) {
        return bb > 0L && Bitboard.extractLsb(bb) == 0L;
    }

    public static long getBbtable(Square sq) {
        return 1L << sq.ordinal();
    }

    private static long getSliderAttacks(long attacks, long mask, int index) {
        long occ = mask & attacks;
        if (occ == 0L) {
            return attacks;
        }
        long m = (1L << index) - 1L;
        long lowerMask = occ & m;
        long upperMask = occ & (m ^ 0xFFFFFFFFFFFFFFFFL);
        int minor = lowerMask == 0L ? 0 : Bitboard.bitScanReverse(lowerMask);
        int major = upperMask == 0L ? 63 : Bitboard.bitScanForward(upperMask);
        return Bitboard.bitsBetween(attacks, minor, major);
    }

    public static long getBishopAttacks(long mask, Square square) {
        return Bitboard.getSliderAttacks(diagA1H8Attacks[square.ordinal()], mask, square.ordinal()) | Bitboard.getSliderAttacks(diagH1A8Attacks[square.ordinal()], mask, square.ordinal());
    }

    public static long getRookAttacks(long mask, Square square) {
        return Bitboard.getSliderAttacks(fileAttacks[square.ordinal()], mask, square.ordinal()) | Bitboard.getSliderAttacks(rankAttacks[square.ordinal()], mask, square.ordinal());
    }

    public static long getQueenAttacks(long mask, Square square) {
        return Bitboard.getRookAttacks(mask, square) | Bitboard.getBishopAttacks(mask, square);
    }

    public static long getKnightAttacks(Square square, long occupied) {
        return knightAttacks[square.ordinal()] & occupied;
    }

    public static long getPawnAttacks(Side side, Square square) {
        return side.equals((Object)Side.WHITE) ? whitePawnAttacks[square.ordinal()] : blackPawnAttacks[square.ordinal()];
    }

    public static long getPawnCaptures(Side side, Square square, long occupied, Square enPassant) {
        long pawnAttacks;
        long l = pawnAttacks = side.equals((Object)Side.WHITE) ? whitePawnAttacks[square.ordinal()] : blackPawnAttacks[square.ordinal()];
        if (!enPassant.equals((Object)Square.NONE)) {
            long ep = enPassant.getBitboard();
            occupied |= side.equals((Object)Side.WHITE) ? ep << 8 : ep >> 8;
        }
        return pawnAttacks & occupied;
    }

    public static long getPawnMoves(Side side, Square square, long occupied) {
        long pawnMoves = side.equals((Object)Side.WHITE) ? whitePawnMoves[square.ordinal()] : blackPawnMoves[square.ordinal()];
        long occ = occupied;
        if (square.getRank().equals((Object)Rank.RANK_2) && side.equals((Object)Side.WHITE)) {
            if ((square.getBitboard() << 8 & occ) != 0L) {
                occ |= square.getBitboard() << 16;
            }
        } else if (square.getRank().equals((Object)Rank.RANK_7) && side.equals((Object)Side.BLACK) && (square.getBitboard() >> 8 & occ) != 0L) {
            occ |= square.getBitboard() >> 16;
        }
        return pawnMoves & (occ ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static long getKingAttacks(Square square, long occupied) {
        return adjacentSquares[square.ordinal()] & occupied;
    }

    public static List<Square> bbToSquareList(long pieces) {
        LinkedList<Square> squares = new LinkedList<Square>();
        while (pieces != 0L) {
            int sq = Bitboard.bitScanForward(pieces);
            pieces = Bitboard.extractLsb(pieces);
            squares.add(Square.squareAt(sq));
        }
        return squares;
    }

    public static Square[] bbToSquareArray(long pieces) {
        Square[] squares = new Square[Long.bitCount(pieces)];
        int index = 0;
        while (pieces != 0L) {
            int sq = Bitboard.bitScanForward(pieces);
            pieces = Bitboard.extractLsb(pieces);
            squares[index++] = Square.squareAt(sq);
        }
        return squares;
    }

    public static long[] getRankbb() {
        return rankBB;
    }

    public static long[] getFilebb() {
        return fileBB;
    }

    public static long getRankbb(Square sq) {
        return rankBB[sq.getRank().ordinal()];
    }

    public static long getFilebb(Square sq) {
        return fileBB[sq.getFile().ordinal()];
    }

    public static long getRankbb(Rank rank) {
        return rankBB[rank.ordinal()];
    }

    public static long getFilebb(File file) {
        return fileBB[file.ordinal()];
    }

    public static String bitboardToString(long bb) {
        StringBuilder b = new StringBuilder();
        for (int x = 0; x < 64; ++x) {
            if ((1L << x & bb) != 0L) {
                b.append("1");
            } else {
                b.append("0");
            }
            if ((x + 1) % 8 != 0) continue;
            b.append("\n");
        }
        return b.toString();
    }

    static {
        for (int x = 0; x < 64; ++x) {
            for (int y = 0; y < 64; ++y) {
                Bitboard.bbTable[x][y] = 1L << y | (1L << y) - (1L << x);
            }
        }
    }
}

