/*
 * Copyright 2017 Ben-Hur Carlos Vieira Langoni Junior
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.github.bhlangonijr.chesslib;

/**
 * The enum Diagonal a 1 h 8.
 */
public enum DiagonalA1H8 {
    /**
     * A 8 a 8 diagonal a 1 h 8.
     */
    A8_A8,
    /**
     * B 8 a 7 diagonal a 1 h 8.
     */
    B8_A7,
    /**
     * C 8 a 6 diagonal a 1 h 8.
     */
    C8_A6,
    /**
     * D 8 a 5 diagonal a 1 h 8.
     */
    D8_A5,
    /**
     * E 8 a 4 diagonal a 1 h 8.
     */
    E8_A4,
    /**
     * F 8 a 3 diagonal a 1 h 8.
     */
    F8_A3,
    /**
     * G 8 a 2 diagonal a 1 h 8.
     */
    G8_A2,
    /**
     * H 8 a 1 diagonal a 1 h 8.
     */
    H8_A1,
    /**
     * B 1 h 7 diagonal a 1 h 8.
     */
    B1_H7,
    /**
     * C 1 h 6 diagonal a 1 h 8.
     */
    C1_H6,
    /**
     * D 1 h 5 diagonal a 1 h 8.
     */
    D1_H5,
    /**
     * E 1 h 4 diagonal a 1 h 8.
     */
    E1_H4,
    /**
     * F 1 h 3 diagonal a 1 h 8.
     */
    F1_H3,
    /**
     * G 1 h 2 diagonal a 1 h 8.
     */
    G1_H2,
    /**
     * H 1 h 1 diagonal a 1 h 8.
     */
    H1_H1
}
