/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.gradle.versions.updates;

import com.github.benmanes.gradle.versions.reporter.Reporter;
import com.github.benmanes.gradle.versions.reporter.result.Result;
import com.github.benmanes.gradle.versions.updates.DependencyUpdates;
import com.github.benmanes.gradle.versions.updates.DependencyUpdatesReporter;
import com.github.benmanes.gradle.versions.updates.OutputFormatterArgument;
import com.github.benmanes.gradle.versions.updates.gradle.GradleReleaseChannel;
import com.github.benmanes.gradle.versions.updates.resolutionstrategy.ComponentFilter;
import com.github.benmanes.gradle.versions.updates.resolutionstrategy.ComponentSelectionRulesWithCurrent;
import com.github.benmanes.gradle.versions.updates.resolutionstrategy.ComponentSelectionWithCurrent;
import com.github.benmanes.gradle.versions.updates.resolutionstrategy.ResolutionStrategyWithCurrent;
import groovy.lang.Closure;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KCallable;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000e\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u001c\u001a\u0004\u0018\u00010\u0005H\u0007J\b\u0010>\u001a\u00020?H\u0007J\b\u0010@\u001a\u00020?H\u0002J\u000e\u0010A\u001a\u00020?2\u0006\u0010B\u001a\u00020CJ\u001a\u00103\u001a\u00020?2\u0012\b\u0002\u00103\u001a\f\u0012\u0006\b\u0000\u0012\u00020<\u0018\u00010;J\b\u0010\u0015\u001a\u00020\u001bH\u0002J\u0014\u0010\u0015\u001a\u00020?2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020E0;J\b\u0010F\u001a\u00020?H\u0002R\u001e\u0010\u0004\u001a\u00020\u00058F@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u00020\u00058F@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001e\u0010\r\u001a\u00020\u00058F@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001e\u0010\u0010\u001a\u00020\u00058F@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR(\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u00148G@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001d\u001a\u00020\u001e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001e\u0010#\u001a\u00020\u00058\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0007\"\u0004\b%\u0010\tR\u001e\u0010&\u001a\u00020\u001e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010 \"\u0004\b(\u0010\"R$\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001e\u00100\u001a\u00020\u001e8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010 \"\u0004\b2\u0010\"R,\u00103\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u0001048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b5\u0010\u0003\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\"\u0010:\u001a\f\u0012\u0006\b\u0000\u0012\u00020<\u0018\u00010;8\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b=\u0010\u0003\u00a8\u0006G"}, d2={"Lcom/github/benmanes/gradle/versions/updates/DependencyUpdatesTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "revision", "", "getRevision", "()Ljava/lang/String;", "setRevision", "(Ljava/lang/String;)V", "gradleReleaseChannel", "getGradleReleaseChannel", "setGradleReleaseChannel", "outputDir", "getOutputDir", "setOutputDir", "reportfileName", "getReportfileName", "setReportfileName", "value", "", "outputFormatter", "getOutputFormatter", "()Ljava/lang/Object;", "setOutputFormatter", "(Ljava/lang/Object;)V", "outputFormatterArgument", "Lcom/github/benmanes/gradle/versions/updates/OutputFormatterArgument;", "getOutputFormatterName", "checkForGradleUpdate", "", "getCheckForGradleUpdate", "()Z", "setCheckForGradleUpdate", "(Z)V", "gradleVersionsApiBaseUrl", "getGradleVersionsApiBaseUrl", "setGradleVersionsApiBaseUrl", "checkConstraints", "getCheckConstraints", "setCheckConstraints", "filterConfigurations", "Lorg/gradle/api/specs/Spec;", "Lorg/gradle/api/artifacts/Configuration;", "getFilterConfigurations", "()Lorg/gradle/api/specs/Spec;", "setFilterConfigurations", "(Lorg/gradle/api/specs/Spec;)V", "checkBuildEnvironmentConstraints", "getCheckBuildEnvironmentConstraints", "setCheckBuildEnvironmentConstraints", "resolutionStrategy", "Lgroovy/lang/Closure;", "getResolutionStrategy$annotations", "getResolutionStrategy", "()Lgroovy/lang/Closure;", "setResolutionStrategy", "(Lgroovy/lang/Closure;)V", "resolutionStrategyAction", "Lorg/gradle/api/Action;", "Lcom/github/benmanes/gradle/versions/updates/resolutionstrategy/ResolutionStrategyWithCurrent;", "getResolutionStrategyAction$annotations", "dependencyUpdates", "", "requireNoParallel", "rejectVersionIf", "filter", "Lcom/github/benmanes/gradle/versions/updates/resolutionstrategy/ComponentFilter;", "action", "Lcom/github/benmanes/gradle/versions/reporter/result/Result;", "callIncompatibleWithConfigurationCache", "gradle-versions-plugin"})
@SourceDebugExtension(value={"SMAP\nDependencyUpdatesTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DependencyUpdatesTask.kt\ncom/github/benmanes/gradle/versions/updates/DependencyUpdatesTask\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,203:1\n1#2:204\n*E\n"})
public class DependencyUpdatesTask
extends DefaultTask {
    @Input
    @NotNull
    private String revision = "milestone";
    @Input
    @NotNull
    private String gradleReleaseChannel = GradleReleaseChannel.RELEASE_CANDIDATE.getId();
    @Input
    @NotNull
    private String outputDir;
    @Input
    @Optional
    @NotNull
    private String reportfileName;
    @NotNull
    private OutputFormatterArgument outputFormatterArgument;
    @Input
    private boolean checkForGradleUpdate;
    @Input
    @NotNull
    private String gradleVersionsApiBaseUrl;
    @Input
    private boolean checkConstraints;
    @Internal
    @NotNull
    private Spec<Configuration> filterConfigurations;
    @Input
    private boolean checkBuildEnvironmentConstraints;
    @Internal
    @Nullable
    private Closure<Object> resolutionStrategy;
    @Nullable
    private Action<? super ResolutionStrategyWithCurrent> resolutionStrategyAction;

    public DependencyUpdatesTask() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getProject().getBuildDir().getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        this.outputDir = stringBuilder.append(StringsKt.replace$default((String)string, (String)(this.getProject().getProjectDir().getPath() + '/'), (String)"", (boolean)false, (int)4, null)).append("/dependencyUpdates").toString();
        this.reportfileName = "report";
        this.outputFormatterArgument = OutputFormatterArgument.Companion.getDEFAULT();
        this.checkForGradleUpdate = true;
        this.gradleVersionsApiBaseUrl = "https://services.gradle.org/versions/";
        this.filterConfigurations = DependencyUpdatesTask::filterConfigurations$lambda$2;
        this.setDescription("Displays the dependency updates for the project.");
        this.setGroup("Help");
        this.getOutputs().upToDateWhen(arg_0 -> DependencyUpdatesTask._init_$lambda$4(DependencyUpdatesTask::_init_$lambda$3, arg_0));
        this.callIncompatibleWithConfigurationCache();
    }

    @NotNull
    public final String getRevision() {
        Object object = System.getProperties().get("revision");
        if (object == null) {
            object = this.revision;
        }
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        return (String)object;
    }

    public final void setRevision(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.revision = string;
    }

    @NotNull
    public final String getGradleReleaseChannel() {
        Object object = System.getProperties().get("gradleReleaseChannel");
        if (object == null) {
            object = this.gradleReleaseChannel;
        }
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        return (String)object;
    }

    public final void setGradleReleaseChannel(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.gradleReleaseChannel = string;
    }

    @NotNull
    public final String getOutputDir() {
        Object object = System.getProperties().get("outputDir");
        if (object == null) {
            object = this.outputDir;
        }
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        return (String)object;
    }

    public final void setOutputDir(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.outputDir = string;
    }

    @NotNull
    public final String getReportfileName() {
        Object object = System.getProperties().get("reportfileName");
        if (object == null) {
            object = this.reportfileName;
        }
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
        return (String)object;
    }

    public final void setReportfileName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.reportfileName = string;
    }

    @Internal
    @Nullable
    public final Object getOutputFormatter() {
        return null;
    }

    public final void setOutputFormatter(@Nullable Object value) {
        OutputFormatterArgument outputFormatterArgument;
        Object object = value;
        if (object instanceof String) {
            outputFormatterArgument = new OutputFormatterArgument.BuiltIn((String)value);
        } else if (object instanceof Reporter) {
            outputFormatterArgument = new OutputFormatterArgument.CustomReporter((Reporter)value);
        } else if (object instanceof Closure) {
            outputFormatterArgument = new OutputFormatterArgument.CustomAction((Action<Result>)((Action)arg_0 -> DependencyUpdatesTask._set_outputFormatter_$lambda$0(value, arg_0)));
        } else {
            throw new IllegalArgumentException("Unsupported output formatter provided " + value + ". Please use a String, a Reporter/Closure, or alternatively provide a function using the `outputFormatter(Action<Result>)` API.");
        }
        this.outputFormatterArgument = outputFormatterArgument;
    }

    @Input
    @Optional
    @Nullable
    public final String getOutputFormatterName() {
        OutputFormatterArgument $this$getOutputFormatterName_u24lambda_u241 = this.outputFormatterArgument;
        boolean bl = false;
        return $this$getOutputFormatterName_u24lambda_u241 instanceof OutputFormatterArgument.BuiltIn ? ((OutputFormatterArgument.BuiltIn)$this$getOutputFormatterName_u24lambda_u241).getFormatterNames() : null;
    }

    public final boolean getCheckForGradleUpdate() {
        return this.checkForGradleUpdate;
    }

    public final void setCheckForGradleUpdate(boolean bl) {
        this.checkForGradleUpdate = bl;
    }

    @NotNull
    public final String getGradleVersionsApiBaseUrl() {
        return this.gradleVersionsApiBaseUrl;
    }

    public final void setGradleVersionsApiBaseUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.gradleVersionsApiBaseUrl = string;
    }

    public final boolean getCheckConstraints() {
        return this.checkConstraints;
    }

    public final void setCheckConstraints(boolean bl) {
        this.checkConstraints = bl;
    }

    @NotNull
    public final Spec<Configuration> getFilterConfigurations() {
        return this.filterConfigurations;
    }

    public final void setFilterConfigurations(@NotNull Spec<Configuration> spec) {
        Intrinsics.checkNotNullParameter(spec, (String)"<set-?>");
        this.filterConfigurations = spec;
    }

    public final boolean getCheckBuildEnvironmentConstraints() {
        return this.checkBuildEnvironmentConstraints;
    }

    public final void setCheckBuildEnvironmentConstraints(boolean bl) {
        this.checkBuildEnvironmentConstraints = bl;
    }

    @Nullable
    public final Closure<Object> getResolutionStrategy() {
        return this.resolutionStrategy;
    }

    public final void setResolutionStrategy(@Nullable Closure<Object> closure) {
        this.resolutionStrategy = closure;
    }

    @javax.annotation.Nullable
    public static /* synthetic */ void getResolutionStrategy$annotations() {
    }

    @javax.annotation.Nullable
    private static /* synthetic */ void getResolutionStrategyAction$annotations() {
    }

    @TaskAction
    public final void dependencyUpdates() {
        this.requireNoParallel();
        this.getProject().evaluationDependsOnChildren();
        if (this.resolutionStrategy != null) {
            Closure<Object> closure = this.resolutionStrategy;
            Intrinsics.checkNotNull(closure);
            Closure<Object> closure2 = closure;
            this.resolutionStrategy((Action<? super ResolutionStrategyWithCurrent>)((Action)arg_0 -> DependencyUpdatesTask.dependencyUpdates$lambda$6(arg_0 -> DependencyUpdatesTask.dependencyUpdates$lambda$5(this, closure2, arg_0), arg_0)));
            this.getLogger().warn("dependencyUpdates.resolutionStrategy: Remove the assignment operator, \"=\", when setting this task property");
        }
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        DependencyUpdates evaluator = new DependencyUpdates(project, this.resolutionStrategyAction, this.getRevision(), this.outputFormatter(), this.getOutputDir(), this.getReportfileName(), this.checkForGradleUpdate, this.gradleVersionsApiBaseUrl, this.getGradleReleaseChannel(), this.checkConstraints, this.checkBuildEnvironmentConstraints, this.filterConfigurations);
        DependencyUpdatesReporter reporter = evaluator.run();
        reporter.write();
    }

    private final void requireNoParallel() {
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"9.0")) > 0 && this.getProject().getGradle().getStartParameter().isParallelProjectExecutionEnabled()) {
            throw new GradleException("Parallel project execution is not supported, run this task with --no-parallel");
        }
    }

    public final void rejectVersionIf(@NotNull ComponentFilter filter) {
        Intrinsics.checkNotNullParameter((Object)filter, (String)"filter");
        this.resolutionStrategy((Action<? super ResolutionStrategyWithCurrent>)((Action)arg_0 -> DependencyUpdatesTask.rejectVersionIf$lambda$11(arg_0 -> DependencyUpdatesTask.rejectVersionIf$lambda$10(filter, arg_0), arg_0)));
    }

    public final void resolutionStrategy(@Nullable Action<? super ResolutionStrategyWithCurrent> resolutionStrategy) {
        this.resolutionStrategyAction = resolutionStrategy;
        this.resolutionStrategy = null;
    }

    public static /* synthetic */ void resolutionStrategy$default(DependencyUpdatesTask dependencyUpdatesTask, Action action, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: resolutionStrategy");
        }
        if ((n & 1) != 0) {
            action = null;
        }
        dependencyUpdatesTask.resolutionStrategy((Action<? super ResolutionStrategyWithCurrent>)action);
    }

    private final OutputFormatterArgument outputFormatter() {
        OutputFormatterArgument outputFormatterArgument;
        String outputFormatterProperty;
        Object object = System.getProperties().get("outputFormatter");
        String string = outputFormatterProperty = object instanceof String ? (String)object : null;
        if (string != null) {
            String it = string;
            boolean bl = false;
            outputFormatterArgument = new OutputFormatterArgument.BuiltIn(it);
        } else {
            outputFormatterArgument = this.outputFormatterArgument;
        }
        return outputFormatterArgument;
    }

    public final void outputFormatter(@NotNull Action<Result> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.outputFormatterArgument = new OutputFormatterArgument.CustomAction(action);
    }

    private final void callIncompatibleWithConfigurationCache() {
        Object v0;
        block2: {
            Iterable iterable = Reflection.getOrCreateKotlinClass(((Object)((Object)this)).getClass()).getMembers();
            for (Object t : iterable) {
                KCallable it = (KCallable)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"notCompatibleWithConfigurationCache")) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        KCallable kCallable = v0;
        if (kCallable != null) {
            Object[] objectArray = new Object[]{this, "The gradle-versions-plugin isn't compatible with the configuration cache"};
            kCallable.call(objectArray);
        }
    }

    private static final void _set_outputFormatter_$lambda$0(Object $value, Result it) {
        ((Closure)$value).call((Object)it);
    }

    private static final boolean filterConfigurations$lambda$2(Configuration it) {
        return true;
    }

    private static final boolean _init_$lambda$3(Task it) {
        return false;
    }

    private static final boolean _init_$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit dependencyUpdates$lambda$5(DependencyUpdatesTask this$0, Closure $closure, ResolutionStrategyWithCurrent current) {
        this$0.getProject().configure((Object)current, $closure);
        return Unit.INSTANCE;
    }

    private static final void dependencyUpdates$lambda$6(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void rejectVersionIf$lambda$10$lambda$8$lambda$7(ComponentFilter $filter, ComponentSelectionWithCurrent current) {
        boolean isNotNull;
        boolean bl = isNotNull = current.getCurrentVersion() != null && current.getCandidate().getVersion() != null;
        if (isNotNull) {
            Intrinsics.checkNotNull((Object)current);
            if ($filter.reject(current)) {
                current.reject("Rejected by rejectVersionIf ");
            }
        }
    }

    private static final Unit rejectVersionIf$lambda$10$lambda$8(ComponentFilter $filter, ComponentSelectionRulesWithCurrent selection) {
        selection.all((Action<? super ComponentSelectionWithCurrent>)((Action)arg_0 -> DependencyUpdatesTask.rejectVersionIf$lambda$10$lambda$8$lambda$7($filter, arg_0)));
        return Unit.INSTANCE;
    }

    private static final void rejectVersionIf$lambda$10$lambda$9(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit rejectVersionIf$lambda$10(ComponentFilter $filter, ResolutionStrategyWithCurrent strategy) {
        strategy.componentSelection((Action<? super ComponentSelectionRulesWithCurrent>)((Action)arg_0 -> DependencyUpdatesTask.rejectVersionIf$lambda$10$lambda$9(arg_0 -> DependencyUpdatesTask.rejectVersionIf$lambda$10$lambda$8($filter, arg_0), arg_0)));
        return Unit.INSTANCE;
    }

    private static final void rejectVersionIf$lambda$11(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

