/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.Admission;
import com.github.benmanes.caffeine.cache.simulator.admission.Admittor;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.HillClimber;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.HillClimberType;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import org.jspecify.annotations.Nullable;

@Policy.PolicySpec(name="sketch.HillClimberWindowTinyLfu")
public final class HillClimberWindowTinyLfuPolicy
implements Policy.KeyOnlyPolicy {
    private static final boolean debug = false;
    private static final boolean trace = false;
    private final double initialPercentMain;
    private final Long2ObjectMap<Node> data;
    private final PolicyStats policyStats;
    private final HillClimber climber;
    private final Admittor admittor;
    private final int maximumSize;
    private final Node headWindow;
    private final Node headProbation;
    private final Node headProtected;
    private int maxWindow;
    private int maxProtected;
    private double windowSize;
    private double protectedSize;

    public HillClimberWindowTinyLfuPolicy(HillClimberType strategy, double percentMain, HillClimberWindowTinyLfuSettings settings) {
        this.maximumSize = Math.toIntExact(settings.maximumSize());
        int maxMain = (int)((double)this.maximumSize * percentMain);
        this.maxProtected = (int)((double)maxMain * settings.percentMainProtected());
        this.maxWindow = this.maximumSize - maxMain;
        this.data = new Long2ObjectOpenHashMap();
        this.headProtected = new Node();
        this.headProbation = new Node();
        this.headWindow = new Node();
        this.initialPercentMain = percentMain;
        this.policyStats = new PolicyStats(this.name() + " (%s %.0f%%)", strategy.name().toLowerCase(Locale.US), 100.0 * (1.0 - this.initialPercentMain));
        this.admittor = Admission.TINYLFU.from(settings.config(), this.policyStats);
        this.climber = strategy.create(settings.config());
        this.printSegmentSizes();
    }

    public static Set<Policy> policies(Config config) {
        HashSet<Policy> policies = new HashSet<Policy>();
        HillClimberWindowTinyLfuSettings settings = new HillClimberWindowTinyLfuSettings(config);
        for (HillClimberType climber : settings.strategy()) {
            for (double percentMain : settings.percentMain()) {
                policies.add(new HillClimberWindowTinyLfuPolicy(climber, percentMain, settings));
            }
        }
        return policies;
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void record(long key) {
        boolean isFull = this.data.size() >= this.maximumSize;
        this.policyStats.recordOperation();
        Node node = (Node)this.data.get(key);
        this.admittor.record(key);
        HillClimber.QueueType queue = null;
        if (node == null) {
            this.onMiss(key);
            this.policyStats.recordMiss();
        } else {
            this.onHit(node);
            queue = node.queue;
        }
        this.climb(key, queue, isFull);
    }

    private void onMiss(long key) {
        Node node = new Node(key, HillClimber.QueueType.WINDOW);
        node.appendToTail(this.headWindow);
        this.data.put(key, (Object)node);
        this.windowSize += 1.0;
        this.evict();
    }

    private void onHit(Node node) {
        Objects.requireNonNull(node.queue);
        this.policyStats.recordHit();
        switch (node.queue) {
            case WINDOW: {
                this.onWindowHit(node);
                break;
            }
            case PROBATION: {
                this.onProbationHit(node);
                break;
            }
            case PROTECTED: {
                this.onProtectedHit(node);
            }
        }
    }

    private void onWindowHit(Node node) {
        node.moveToTail(this.headWindow);
    }

    private void onProbationHit(Node node) {
        node.remove();
        node.queue = HillClimber.QueueType.PROTECTED;
        node.appendToTail(this.headProtected);
        this.protectedSize += 1.0;
        this.demoteProtected();
    }

    private void demoteProtected() {
        if (this.protectedSize > (double)this.maxProtected) {
            Node demote = Objects.requireNonNull(this.headProtected.next);
            demote.remove();
            demote.queue = HillClimber.QueueType.PROBATION;
            demote.appendToTail(this.headProbation);
            this.protectedSize -= 1.0;
        }
    }

    private void onProtectedHit(Node node) {
        node.moveToTail(this.headProtected);
    }

    private void evict() {
        if (this.windowSize <= (double)this.maxWindow) {
            return;
        }
        Node candidate = Objects.requireNonNull(this.headWindow.next);
        this.windowSize -= 1.0;
        candidate.remove();
        candidate.queue = HillClimber.QueueType.PROBATION;
        candidate.appendToTail(this.headProbation);
        if (this.data.size() > this.maximumSize) {
            Node victim = Objects.requireNonNull(this.headProbation.next);
            Node evict = this.admittor.admit(candidate.key, victim.key) ? victim : candidate;
            this.data.remove(evict.key);
            evict.remove();
            this.policyStats.recordEviction();
        }
    }

    private void climb(long key, @Nullable HillClimber.QueueType queue, boolean isFull) {
        if (queue == null) {
            this.climber.onMiss(key, isFull);
        } else {
            this.climber.onHit(key, queue, isFull);
        }
        double probationSize = (double)this.maximumSize - this.windowSize - this.protectedSize;
        HillClimber.Adaptation adaptation = this.climber.adapt(this.windowSize, probationSize, this.protectedSize, isFull);
        switch (adaptation.type()) {
            case INCREASE_WINDOW: {
                this.increaseWindow(adaptation.amount());
                break;
            }
            case DECREASE_WINDOW: {
                this.decreaseWindow(adaptation.amount());
                break;
            }
        }
    }

    private void increaseWindow(double amount) {
        Preconditions.checkState((amount >= 0.0 ? 1 : 0) != 0);
        if (this.maxProtected == 0) {
            return;
        }
        double quota = Math.min(amount, (double)this.maxProtected);
        int steps = (int)(this.windowSize + quota) - (int)this.windowSize;
        this.windowSize += quota;
        for (int i = 0; i < steps; ++i) {
            ++this.maxWindow;
            --this.maxProtected;
            this.demoteProtected();
            Objects.requireNonNull(this.headProbation.next);
            Node candidate = this.headProbation.next;
            candidate.remove();
            candidate.queue = HillClimber.QueueType.WINDOW;
            candidate.appendToTail(this.headWindow);
        }
        Preconditions.checkState((this.windowSize >= 0.0 ? 1 : 0) != 0);
        Preconditions.checkState((this.maxWindow >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((this.maxProtected >= 0 ? 1 : 0) != 0);
    }

    private void decreaseWindow(double amount) {
        Preconditions.checkState((amount >= 0.0 ? 1 : 0) != 0);
        if (this.maxWindow == 0) {
            return;
        }
        double quota = Math.min(amount, (double)this.maxWindow);
        int steps = (int)this.windowSize - (int)(this.windowSize - quota);
        this.windowSize -= quota;
        for (int i = 0; i < steps; ++i) {
            --this.maxWindow;
            ++this.maxProtected;
            Objects.requireNonNull(this.headWindow.next);
            Node candidate = this.headWindow.next;
            candidate.remove();
            candidate.queue = HillClimber.QueueType.PROBATION;
            candidate.appendToHead(this.headProbation);
        }
        Preconditions.checkState((this.windowSize >= 0.0 ? 1 : 0) != 0);
        Preconditions.checkState((this.maxWindow >= 0 ? 1 : 0) != 0);
        Preconditions.checkState((this.maxProtected >= 0 ? 1 : 0) != 0);
    }

    private void printSegmentSizes() {
    }

    @Override
    public void finished() {
        this.policyStats.setPercentAdaption((double)this.maxWindow / (double)this.maximumSize - (1.0 - this.initialPercentMain));
        this.printSegmentSizes();
        long actualWindowSize = this.data.values().stream().filter(n -> n.queue == HillClimber.QueueType.WINDOW).count();
        long actualProbationSize = this.data.values().stream().filter(n -> n.queue == HillClimber.QueueType.PROBATION).count();
        long actualProtectedSize = this.data.values().stream().filter(n -> n.queue == HillClimber.QueueType.PROTECTED).count();
        long calculatedProbationSize = (long)this.data.size() - actualWindowSize - actualProtectedSize;
        Preconditions.checkState(((long)this.windowSize == actualWindowSize ? 1 : 0) != 0, (String)"Window: %s != %s", (long)((long)this.windowSize), (long)actualWindowSize);
        Preconditions.checkState(((long)this.protectedSize == actualProtectedSize ? 1 : 0) != 0, (String)"Protected: %s != %s", (long)((long)this.protectedSize), (long)actualProtectedSize);
        Preconditions.checkState((actualProbationSize == calculatedProbationSize ? 1 : 0) != 0, (String)"Probation: %s != %s", (long)actualProbationSize, (long)calculatedProbationSize);
        Preconditions.checkState((this.data.size() <= this.maximumSize ? 1 : 0) != 0, (String)"Maximum: %s > %s", (int)this.data.size(), (int)this.maximumSize);
    }

    public static final class HillClimberWindowTinyLfuSettings
    extends BasicSettings {
        public HillClimberWindowTinyLfuSettings(Config config) {
            super(config);
        }

        public List<Double> percentMain() {
            return this.config().getDoubleList("hill-climber-window-tiny-lfu.percent-main");
        }

        public double percentMainProtected() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.percent-main-protected");
        }

        public ImmutableSet<HillClimberType> strategy() {
            return (ImmutableSet)this.config().getStringList("hill-climber-window-tiny-lfu.strategy").stream().map(strategy -> strategy.replace('-', '_').toUpperCase(Locale.US)).map(HillClimberType::valueOf).collect(Sets.toImmutableEnumSet());
        }
    }

    static final class Node {
        final long key;
        @Nullable Node prev;
        @Nullable Node next;
        @Nullable HillClimber.QueueType queue;

        public Node() {
            this.key = Integer.MIN_VALUE;
            this.prev = this;
            this.next = this;
        }

        public Node(long key, HillClimber.QueueType queue) {
            this.queue = queue;
            this.key = key;
        }

        public void moveToTail(Node head) {
            this.remove();
            this.appendToTail(head);
        }

        public void appendToHead(Node head) {
            Node first = Objects.requireNonNull(head.next);
            head.next = this;
            first.prev = this;
            this.prev = head;
            this.next = first;
        }

        public void appendToTail(Node head) {
            Node tail = Objects.requireNonNull(head.prev);
            head.prev = this;
            tail.next = this;
            this.next = head;
            this.prev = tail;
        }

        public void remove() {
            Objects.requireNonNull(this.prev);
            Objects.requireNonNull(this.next);
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.prev = null;
            this.next = null;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("queue", (Object)this.queue).toString();
        }
    }
}

