/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy;

import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.Preconditions;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.commons.lang3.StringUtils;

public interface Policy {
    public void record(AccessEvent var1);

    default public void finished() {
    }

    public PolicyStats stats();

    default public String name() {
        PolicySpec policySpec = this.getClass().getAnnotation(PolicySpec.class);
        if (policySpec != null && StringUtils.isNotBlank((CharSequence)policySpec.name())) {
            return policySpec.name().trim();
        }
        Preconditions.checkState((this.stats() != null ? 1 : 0) != 0, (String)"The @%s name must be specified on %s or by the %s", (Object)PolicySpec.class.getSimpleName(), this.getClass(), (Object)PolicyStats.class.getSimpleName());
        return this.stats().name();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface PolicySpec {
        public String name() default "";

        public Characteristic[] characteristics() default {};
    }

    public static interface KeyOnlyPolicy
    extends Policy {
        @Override
        default public void record(AccessEvent event) {
            this.record(event.key());
        }

        public void record(long var1);
    }

    public static enum Characteristic {
        WEIGHTED;

    }
}

