/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.admission.table;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.Frequency;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongCollection;
import java.util.Random;

public final class RandomRemovalFrequencyTable
implements Frequency {
    private static final int sampleFactor = 8;
    private final Long2IntMap table;
    private final Random random;
    private final int maxSum;
    private int currSum;

    public RandomRemovalFrequencyTable(Config config) {
        BasicSettings settings = new BasicSettings(config);
        this.maxSum = Math.toIntExact(8L * settings.maximumSize());
        this.random = new Random(settings.randomSeed());
        this.table = new Long2IntOpenHashMap(this.maxSum);
    }

    @Override
    public int frequency(long e) {
        return this.table.getOrDefault(e, 0);
    }

    @Override
    public void increment(long e) {
        LongArrayList array;
        long itemToRemove;
        int value = this.table.getOrDefault(e, 0) + 1;
        if (value > 8) {
            return;
        }
        this.table.put(e, value);
        if (this.currSum < this.maxSum) {
            ++this.currSum;
        }
        if (this.currSum == this.maxSum && (value = this.table.remove(itemToRemove = (array = new LongArrayList((LongCollection)this.table.keySet())).getLong(this.random.nextInt(array.size())))) > 1) {
            this.table.put(itemToRemove, value - 1);
        }
    }
}

