/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.admission;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.Admittor;
import com.github.benmanes.caffeine.cache.simulator.admission.TinyLfu;
import com.github.benmanes.caffeine.cache.simulator.admission.clairvoyant.Clairvoyant;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.Enums;
import com.typesafe.config.Config;
import java.util.Locale;
import java.util.function.BiFunction;

public enum Admission {
    ALWAYS((config, policyStats) -> Admittor.always(), ""),
    CLAIRVOYANT(Clairvoyant::new, "_Clairvoyant"),
    TINYLFU(TinyLfu::new, "_TinyLfu");

    private final BiFunction<Config, PolicyStats, Admittor> factory;
    private final String suffix;

    private Admission(BiFunction<Config, PolicyStats, Admittor> factory, String suffix) {
        this.factory = factory;
        this.suffix = suffix;
    }

    public Admittor from(Config config, PolicyStats policyStats) {
        if (this == TINYLFU) {
            String override = new BasicSettings(config).tinyLfu().sketch().toUpperCase(Locale.US);
            return ((Admission)((Object)Enums.getIfPresent(Admission.class, (String)override).or((Object)((Object)this)))).factory.apply(config, policyStats);
        }
        return this.factory.apply(config, policyStats);
    }

    public String format(String name) {
        return name + this.suffix;
    }
}

