/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.typesafe.config.Config;
import java.util.Set;

@Policy.PolicySpec(name="product.Caffeine", characteristics={Policy.Characteristic.WEIGHTED})
public final class CaffeinePolicy
implements Policy {
    private final Cache<Long, AccessEvent> cache;
    private final PolicyStats policyStats = new PolicyStats(this.name(), new Object[0]);

    public CaffeinePolicy(Config config, Set<Policy.Characteristic> characteristics) {
        BasicSettings settings = new BasicSettings(config);
        Caffeine builder = Caffeine.newBuilder().executor(Runnable::run);
        if (characteristics.contains((Object)Policy.Characteristic.WEIGHTED)) {
            builder.maximumWeight(settings.maximumSize());
            builder.weigher((l, value) -> value.weight());
        } else {
            builder.maximumSize(settings.maximumSize());
            builder.initialCapacity(Ints.saturatedCast((long)settings.maximumSize()));
        }
        this.cache = builder.recordStats().build();
    }

    @Override
    public void record(AccessEvent event) {
        Long key = event.longKey();
        AccessEvent value = (AccessEvent)this.cache.getIfPresent((Object)key);
        if (value == null) {
            this.cache.put((Object)key, (Object)event);
            this.policyStats.recordWeightedMiss(event.weight());
        } else {
            this.policyStats.recordWeightedHit(event.weight());
            if (event.weight() != value.weight()) {
                this.cache.put((Object)key, (Object)event);
            }
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        CacheStats stats = this.cache.stats();
        this.policyStats.addEvictions(stats.evictionCount());
        Preconditions.checkState((this.policyStats.hitCount() == stats.hitCount() ? 1 : 0) != 0);
        Preconditions.checkState((this.policyStats.missCount() == stats.missCount() ? 1 : 0) != 0);
    }
}

