/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.linked;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import java.util.Arrays;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

@Policy.PolicySpec(name="linked.MultiQueue")
public final class MultiQueuePolicy
implements Policy.KeyOnlyPolicy {
    private final Long2ObjectSortedMap<Node> out;
    private final Long2ObjectMap<Node> data;
    private final PolicyStats policyStats;
    private final long[] threshold;
    private final int maximumSize;
    private final long lifetime;
    private final Node[] headQ;
    private final int maxOut;
    private long currentTime;

    public MultiQueuePolicy(Config config) {
        MultiQueueSettings settings = new MultiQueueSettings(config);
        this.maximumSize = Math.toIntExact(settings.maximumSize());
        this.threshold = new long[settings.numberOfQueues()];
        this.headQ = new Node[settings.numberOfQueues()];
        this.out = new Long2ObjectLinkedOpenHashMap();
        this.policyStats = new PolicyStats(this.name(), new Object[0]);
        this.data = new Long2ObjectOpenHashMap();
        this.lifetime = settings.lifetime();
        Arrays.setAll(this.headQ, Node::sentinel);
        Arrays.setAll(this.threshold, i -> 1L << i);
        this.maxOut = (int)((double)this.maximumSize * settings.percentOut());
    }

    @Override
    public void record(long key) {
        this.policyStats.recordOperation();
        Node node = (Node)this.data.get(key);
        if (node == null) {
            this.policyStats.recordMiss();
            node = (Node)this.out.remove(key);
            if (node == null) {
                node = new Node(key);
            }
            this.data.put(key, (Object)node);
            if (this.data.size() > this.maximumSize) {
                this.policyStats.recordEviction();
                this.evict();
            }
        } else {
            this.policyStats.recordHit();
            node.remove();
        }
        ++node.reference;
        node.queueIndex = this.queueIndexFor(node);
        node.appendToTail(this.headQ[node.queueIndex]);
        node.expireTime = this.currentTime + this.lifetime;
        this.adjust();
    }

    private void adjust() {
        ++this.currentTime;
        for (int i = 1; i < this.headQ.length; ++i) {
            Node node = Objects.requireNonNull(this.headQ[i].next);
            Objects.requireNonNull(node.next);
            if (node.next.expireTime >= this.currentTime) continue;
            node.remove();
            node.queueIndex = i - 1;
            node.appendToTail(this.headQ[node.queueIndex]);
            node.expireTime = this.currentTime + this.lifetime;
        }
    }

    private int queueIndexFor(Node node) {
        for (int i = this.threshold.length - 1; i >= 0; --i) {
            if ((long)node.reference < this.threshold[i]) continue;
            return i;
        }
        throw new IllegalStateException();
    }

    private void evict() {
        Node victim = null;
        for (Node head : this.headQ) {
            if (head.next == head) continue;
            victim = head.next;
            break;
        }
        if (victim == null) {
            return;
        }
        victim.remove();
        this.data.remove(victim.key);
        this.out.put(victim.key, (Object)victim);
        if (this.out.size() > this.maxOut) {
            this.out.remove(this.out.firstLongKey());
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    static final class MultiQueueSettings
    extends BasicSettings {
        public MultiQueueSettings(Config config) {
            super(config);
        }

        public int lifetime() {
            return this.config().getInt("multi-queue.lifetime");
        }

        public int numberOfQueues() {
            int queues = this.config().getInt("multi-queue.num-queues");
            Preconditions.checkArgument((queues > 0 ? 1 : 0) != 0, (Object)"Must have one or more queues");
            Preconditions.checkArgument((queues <= 62 ? 1 : 0) != 0, (Object)"May not have more than 62 queues");
            return queues;
        }

        public double percentOut() {
            return this.config().getDouble("multi-queue.percent-out");
        }
    }

    static final class Node {
        final long key;
        @Nullable Node prev;
        @Nullable Node next;
        int reference;
        int queueIndex;
        long expireTime;

        Node(long key) {
            this.key = key;
        }

        static Node sentinel(int queueIndex) {
            Node node = new Node(Long.MIN_VALUE);
            node.expireTime = Long.MAX_VALUE;
            node.queueIndex = queueIndex;
            node.prev = node;
            node.next = node;
            return node;
        }

        public void appendToTail(Node head) {
            Node tail = Objects.requireNonNull(head.prev);
            head.prev = this;
            tail.next = this;
            this.next = head;
            this.prev = tail;
        }

        public void remove() {
            Objects.requireNonNull(this.prev);
            Objects.requireNonNull(this.next);
            this.queueIndex = -1;
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.next = null;
            this.prev = null;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("references", this.reference).toString();
        }
    }
}

