/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.irr;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;

@Policy.PolicySpec(name="irr.ClockProSimple")
public final class ClockProSimplePolicy
implements Policy.KeyOnlyPolicy {
    private static final boolean debug = false;
    private final Long2ObjectMap<Node> data;
    private final PolicyStats policyStats;
    private final Node headHot;
    private final Node headCold;
    private final Node headNonResident;
    private final int maxSize;
    private final int minColdSize;
    private final int maxColdSize;
    private int sizeHot;
    private int sizeCold;
    private int sizeNR;
    private long epoch;
    private int coldTarget;

    public ClockProSimplePolicy(Config config) {
        BasicSettings settings = new BasicSettings(config);
        this.maxSize = Math.toIntExact(settings.maximumSize());
        this.minColdSize = this.maxSize / 100;
        this.maxColdSize = this.maxSize - this.maxSize / 100;
        this.policyStats = new PolicyStats(this.name(), new Object[0]);
        this.data = new Long2ObjectOpenHashMap();
        this.headHot = new Node();
        this.headCold = new Node();
        this.headNonResident = new Node();
        this.epoch = Long.MIN_VALUE;
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        int cold = (int)this.data.values().stream().filter(node -> node.status == Status.COLD).count();
        int hot = (int)this.data.values().stream().filter(node -> node.status == Status.HOT).count();
        int nonResident = (int)this.data.values().stream().filter(node -> node.status == Status.NR).count();
        Preconditions.checkState((cold == this.sizeCold ? 1 : 0) != 0, (String)"Cold: expected %s but was %s", (int)this.sizeCold, (int)cold);
        Preconditions.checkState((hot == this.sizeHot ? 1 : 0) != 0, (String)"Hot: expected %s but was %s", (int)this.sizeHot, (int)hot);
        Preconditions.checkState((nonResident == this.sizeNR ? 1 : 0) != 0, (String)"NonResident: expected %s but was %s", (int)this.sizeNR, (int)nonResident);
        Preconditions.checkState((this.data.size() == cold + hot + nonResident ? 1 : 0) != 0);
        Preconditions.checkState((cold + hot <= this.maxSize ? 1 : 0) != 0);
        Preconditions.checkState((nonResident <= this.maxSize ? 1 : 0) != 0);
    }

    @Override
    public void record(long key) {
        Node node = (Node)this.data.get(key);
        if (node == null) {
            this.onMiss(key);
        } else if (node.status == Status.HOT || node.status == Status.COLD) {
            this.onHit(node);
        } else if (node.status == Status.NR) {
            this.onNonResidentMiss(node);
        } else {
            throw new IllegalStateException();
        }
    }

    private void onHit(Node node) {
        this.policyStats.recordOperation();
        this.policyStats.recordHit();
        node.marked = true;
    }

    private void onMiss(long key) {
        this.policyStats.recordOperation();
        this.policyStats.recordMiss();
        ++this.epoch;
        Node node = new Node(key, this.epoch);
        node.status = Status.COLD;
        node.link(this.headCold);
        this.data.put(key, (Object)node);
        ++this.sizeCold;
        this.evict();
    }

    private void prune() {
        while (this.sizeNR > 0 && !this.inTestPeriod(this.headNonResident.prev)) {
            this.scanNonResident();
        }
    }

    private void onNonResidentMiss(Node node) {
        this.policyStats.recordOperation();
        this.policyStats.recordMiss();
        node.unlink();
        --this.sizeNR;
        if (this.canPromote(node)) {
            node.status = Status.HOT;
            node.link(this.headHot);
            ++this.sizeHot;
        } else {
            node.status = Status.COLD;
            node.link(this.headCold);
            ++this.sizeCold;
        }
        node.epoch = this.epoch;
        this.evict();
    }

    private void evict() {
        this.policyStats.recordEviction();
        while (this.maxSize < this.sizeCold + this.sizeHot) {
            if (this.sizeCold > 0) {
                this.scanCold();
                continue;
            }
            this.scanHot(this.epoch);
        }
        this.prune();
    }

    private boolean canPromote(Node candidate) {
        if (!this.inTestPeriod(candidate)) {
            return false;
        }
        this.adjustColdTarget(1);
        while (this.sizeHot > 0 && this.sizeHot >= this.maxSize - this.coldTarget) {
            if (this.scanHot(candidate.epoch)) continue;
            return false;
        }
        return this.inTestPeriod(candidate);
    }

    private void scanCold() {
        this.policyStats.recordOperation();
        Node victim = this.headCold.prev;
        victim.unlink();
        if (victim.marked) {
            victim.marked = false;
            if (this.canPromote(victim)) {
                victim.status = Status.HOT;
                victim.link(this.headHot);
                --this.sizeCold;
                ++this.sizeHot;
            } else {
                victim.link(this.headCold);
            }
            ++this.epoch;
            victim.epoch = this.epoch;
        } else {
            --this.sizeCold;
            if (this.inTestPeriod(victim)) {
                victim.status = Status.NR;
                victim.link(this.headNonResident);
                ++this.sizeNR;
            } else {
                this.data.remove(victim.key);
            }
            while (this.sizeNR > this.maxSize) {
                this.scanNonResident();
            }
        }
    }

    @CanIgnoreReturnValue
    private boolean scanHot(long epoch) {
        Node victim = this.headHot.prev;
        while (victim.epoch <= epoch) {
            this.policyStats.recordOperation();
            victim.unlink();
            if (!victim.marked) {
                victim.status = Status.COLD;
                victim.link(this.headCold);
                --this.sizeHot;
                ++this.sizeCold;
                return true;
            }
            victim.marked = false;
            victim.link(this.headHot);
            victim.epoch = ++epoch;
            victim = this.headHot.prev;
        }
        return false;
    }

    private void scanNonResident() {
        this.policyStats.recordOperation();
        Node victim = this.headNonResident.prev;
        victim.unlink();
        this.data.remove(victim.key);
        --this.sizeNR;
        this.adjustColdTarget(-1);
    }

    private void adjustColdTarget(int n) {
        this.coldTarget += n;
        if (this.coldTarget < this.minColdSize) {
            this.coldTarget = this.minColdSize;
        } else if (this.coldTarget > this.maxColdSize) {
            this.coldTarget = this.maxColdSize;
        }
    }

    private boolean inTestPeriod(Node node) {
        return this.sizeHot == 0 || node.epoch > this.headHot.prev.epoch;
    }

    private void printClock() {
        Node n;
        if (this.sizeCold > 0) {
            System.out.println("** CLOCK-Pro list COLD HEAD (small recency) **");
            n = this.headCold.next;
            while (n != this.headCold) {
                System.out.println(n.toString());
                n = n.next;
            }
            System.out.println("** CLOCK-Pro list COLD TAIL (large recency) **");
        }
        if (this.sizeHot > 0) {
            System.out.println("** CLOCK-Pro list HOT HEAD (small recency) **");
            n = this.headHot.next;
            while (n != this.headHot) {
                System.out.println(n.toString());
                n = n.next;
            }
            System.out.println("** CLOCK-Pro list HOT TAIL (large recency) **");
        }
        if (this.sizeNR > 0) {
            System.out.println("** CLOCK-Pro list NR HEAD (small recency) **");
            n = this.headNonResident.next;
            while (n != this.headNonResident) {
                System.out.println(n.toString());
                n = n.next;
            }
            System.out.println("** CLOCK-Pro list NR TAIL (large recency) **");
        }
    }

    static final class Node {
        final long key;
        long epoch;
        Status status;
        Node prev;
        Node next;
        boolean marked;

        public Node() {
            this.key = Long.MIN_VALUE;
            this.prev = this.next = this;
        }

        public Node(long key, long epoch) {
            this.key = key;
            this.prev = this.next = this;
            this.epoch = epoch;
            this.status = Status.COLD;
        }

        public void unlink() {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.prev = this.next = this;
        }

        public void link(Node node) {
            this.prev = node;
            this.next = node.next;
            this.prev.next = this;
            this.next.prev = this;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("marked", this.marked).add("type", (Object)this.status).add("epoch", this.epoch).toString();
        }
    }

    static enum Status {
        HOT,
        COLD,
        NR;

    }
}

