/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.report.csv;

import com.github.benmanes.caffeine.cache.simulator.report.csv.AutoValue_PlotCsv_ChartStyle;
import com.google.auto.value.AutoValue;
import com.google.common.base.Strings;
import com.univocity.parsers.common.record.Record;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Locale;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtils;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import picocli.CommandLine;

@CommandLine.Command(mixinStandardHelpOptions=true)
public final class PlotCsv
implements Runnable {
    @CommandLine.Option(names={"--inputFile"}, required=true, description={"The csv file path"})
    private Path inputFile;
    @CommandLine.Option(names={"--outputFile"}, required=true, description={"The chart file path"})
    private Path outputFile;
    @CommandLine.Option(names={"--metric"}, required=true, defaultValue="Hit Rate", description={"The metric being compared (use _ for spaces)"})
    private String metric;
    @CommandLine.Option(names={"--title"}, description={"The chart's title"})
    private String title;
    @CommandLine.Option(names={"--theme"}, required=true, defaultValue="light", converter={ChartStyleConverter.class}, description={"The chart's theme (light, dark)"})
    private ChartStyle style;

    @Override
    public void run() {
        JFreeChart chart = ChartFactory.createLineChart((String)this.title, (String)"Maximum Size", (String)this.metric, (CategoryDataset)this.data());
        chart.setTextAntiAlias(true);
        chart.setAntiAlias(true);
        this.applyTheme(chart);
        this.configurePlot(chart);
        try {
            ChartUtils.saveChartAsPNG((File)this.outputFile.toFile(), (JFreeChart)chart, (int)1280, (int)720);
            System.out.printf(Locale.US, "Wrote chart to %s%n", this.outputFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private CategoryDataset data() {
        CsvParserSettings settings = new CsvParserSettings();
        settings.setHeaderExtractionEnabled(true);
        CsvParser parser = new CsvParser(settings);
        List records = parser.parseAllRecords(this.inputFile.toFile());
        String[] headers = parser.getContext().headers();
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        for (Record record : records) {
            for (int i = 1; i < headers.length; ++i) {
                Double value = record.getDouble(i);
                dataset.addValue((Number)value, (Comparable)((Object)record.getString(0)), (Comparable)((Object)headers[i]));
            }
        }
        return dataset;
    }

    private void configurePlot(JFreeChart chart) {
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        this.configureAxis((Axis)plot.getDomainAxis());
        this.configureAxis((Axis)plot.getRangeAxis());
        this.configureGrid(plot);
        for (int i = 0; i < plot.getCategories().size(); ++i) {
            plot.getRenderer().setSeriesStroke(i, (Stroke)new BasicStroke(3.0f));
        }
    }

    private void applyTheme(JFreeChart chart) {
        StandardChartTheme theme = (StandardChartTheme)StandardChartTheme.createJFreeTheme();
        theme.setDrawingSupplier((DrawingSupplier)new DefaultDrawingSupplier((Paint[])this.getWheelColors(), DefaultDrawingSupplier.DEFAULT_FILL_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_PAINT_SEQUENCE, DefaultDrawingSupplier.DEFAULT_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_OUTLINE_STROKE_SEQUENCE, DefaultDrawingSupplier.DEFAULT_SHAPE_SEQUENCE));
        theme.setPlotBackgroundPaint((Paint)this.style.background());
        theme.setChartBackgroundPaint((Paint)this.style.background());
        theme.setLegendBackgroundPaint((Paint)this.style.background());
        theme.setTitlePaint((Paint)this.style.label());
        theme.setSubtitlePaint((Paint)this.style.axisLabel());
        theme.setLegendItemPaint((Paint)this.style.legend());
        theme.setItemLabelPaint((Paint)this.style.label());
        theme.setAxisLabelPaint((Paint)this.style.axisLabel());
        theme.setTickLabelPaint((Paint)this.style.axisLabel());
        theme.setRangeGridlinePaint((Paint)this.style.gridLine());
        theme.setDomainGridlinePaint((Paint)this.style.gridLine());
        theme.setGridBandPaint((Paint)this.style.gridBand());
        theme.setExtraLargeFont(this.style.extraLargeFont());
        theme.setRegularFont(this.style.regularFont());
        theme.setLargeFont(this.style.largeFont());
        if (Strings.isNullOrEmpty((String)this.title)) {
            theme.setAxisOffset(this.style.axisOffset());
        }
        theme.apply(chart);
    }

    private void configureGrid(CategoryPlot plot) {
        plot.setDomainGridlineStroke((Stroke)new BasicStroke());
        plot.setDomainGridlinePaint((Paint)this.style.gridLine());
        plot.setDomainGridlinesVisible(true);
        plot.setRangeGridlineStroke((Stroke)new BasicStroke());
        plot.setRangeGridlinePaint((Paint)this.style.gridLine());
        plot.setRangeGridlinesVisible(true);
        plot.setOutlineVisible(false);
    }

    private void configureAxis(Axis axis) {
        axis.setAxisLineVisible(true);
        axis.setTickMarksVisible(true);
        axis.setAxisLinePaint((Paint)this.style.axisLine());
        axis.setTickMarkPaint((Paint)this.style.axisLine());
        axis.setTickLabelPaint((Paint)this.style.axisLine());
    }

    private Color[] getWheelColors() {
        int n = 360;
        int wheelStep = 3;
        int paintIndex = 0;
        Color[] colors = new Color[n];
        boolean[] wheelPaints = new boolean[n];
        while (paintIndex < n) {
            int step = n / wheelStep;
            for (int angle = 0; angle < n; angle += step) {
                if (wheelPaints[angle]) continue;
                wheelPaints[angle] = true;
                float hue = (float)angle / (float)n;
                colors[paintIndex++] = this.getLineColor(hue);
            }
            wheelStep += wheelStep;
        }
        return colors;
    }

    private Color getLineColor(float hue) {
        int rgb = 0xFFFFFF & Color.HSBtoRGB(hue, this.style.saturation(), this.style.brightness());
        int a = (int)((double)this.style.alpha() * 255.0 + 0.5) << 24;
        return new Color(rgb | a, true);
    }

    public static void main(String[] args) {
        new CommandLine(PlotCsv.class).setColorScheme(CommandLine.Help.defaultColorScheme((CommandLine.Help.Ansi)CommandLine.Help.Ansi.ON)).setCommandName(PlotCsv.class.getSimpleName()).setCaseInsensitiveEnumValuesAllowed(true).execute(args);
    }

    @AutoValue
    static abstract class ChartStyle {
        ChartStyle() {
        }

        abstract RectangleInsets axisOffset();

        abstract Color title();

        abstract Color subtitle();

        abstract Color background();

        abstract Color axisLine();

        abstract Color axisLabel();

        abstract Color gridLine();

        abstract Color gridBand();

        abstract Color legend();

        abstract Color label();

        abstract Font extraLargeFont();

        abstract Font regularFont();

        abstract Font largeFont();

        abstract float brightness();

        abstract float saturation();

        abstract float alpha();

        static ChartStyle forColors(Color background, Color content, Color grid) {
            return new AutoValue_PlotCsv_ChartStyle.Builder().axisOffset(new RectangleInsets(20.0, 20.0, 20.0, 20.0)).extraLargeFont(new Font("Helvetica", 1, 18)).regularFont(new Font("Helvetica", 0, 12)).largeFont(new Font("Helvetica", 1, 14)).background(background).axisLabel(content).axisLine(content).subtitle(content).brightness(0.6f).saturation(0.7f).legend(content).label(content).title(content).gridLine(grid).gridBand(grid).alpha(0.8f).build();
        }

        @AutoValue.Builder
        @AutoValue.CopyAnnotations
        static abstract class Builder {
            Builder() {
            }

            abstract Builder axisOffset(RectangleInsets var1);

            abstract Builder title(Color var1);

            abstract Builder subtitle(Color var1);

            abstract Builder background(Color var1);

            abstract Builder axisLine(Color var1);

            abstract Builder axisLabel(Color var1);

            abstract Builder gridLine(Color var1);

            abstract Builder gridBand(Color var1);

            abstract Builder legend(Color var1);

            abstract Builder label(Color var1);

            abstract Builder extraLargeFont(Font var1);

            abstract Builder regularFont(Font var1);

            abstract Builder largeFont(Font var1);

            abstract Builder brightness(float var1);

            abstract Builder saturation(float var1);

            abstract Builder alpha(float var1);

            abstract ChartStyle build();
        }
    }

    static final class ChartStyleConverter
    implements CommandLine.ITypeConverter<ChartStyle> {
        ChartStyleConverter() {
        }

        public ChartStyle convert(String value) {
            switch (value.toLowerCase(Locale.US)) {
                case "light": {
                    Color grid = new Color(15657173);
                    Color content = new Color(0x585858);
                    Color background = new Color(16643811);
                    return ChartStyle.forColors(background, content, grid);
                }
                case "dark": {
                    Color grid = new Color(472642);
                    Color content = new Color(9675169);
                    Color background = new Color(11062);
                    return ChartStyle.forColors(background, content, grid);
                }
            }
            throw new CommandLine.TypeConversionException(String.format(Locale.US, "expected one of %s (case-insensitive) but was '%s'", List.of("light", "dark"), value));
        }
    }
}

