/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.irr;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.Indicator;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;

@Policy.PolicySpec(name="irr.IndicatorFrd")
public final class IndicatorFrdPolicy
implements Policy.KeyOnlyPolicy {
    final Long2ObjectOpenHashMap<Node> data;
    final PolicyStats policyStats;
    final Indicator indicator;
    final Node headFilter;
    final Node headMain;
    final int period;
    int maximumMainResidentSize;
    int maximumFilterSize;
    final int maximumSize;
    int residentSize;
    int residentFilter;
    int residentMain;

    public IndicatorFrdPolicy(Config config) {
        FrdSettings settings = new FrdSettings(config);
        this.period = settings.period();
        this.maximumSize = Math.toIntExact(settings.maximumSize());
        this.maximumMainResidentSize = (int)((double)this.maximumSize * settings.percentMain());
        this.maximumFilterSize = this.maximumSize - this.maximumMainResidentSize;
        this.policyStats = new PolicyStats(this.name(), new Object[0]);
        this.data = new Long2ObjectOpenHashMap();
        this.headFilter = new Node();
        this.headMain = new Node();
        this.indicator = new Indicator(config);
    }

    @Override
    public void record(long key) {
        this.policyStats.recordOperation();
        this.adapt(key);
        Node node = (Node)this.data.get(key);
        if (node == null) {
            node = new Node(key);
            this.data.put(key, (Object)node);
            this.onMiss(node);
        } else if (node.status == Status.FILTER) {
            this.onFilterHit(node);
        } else if (node.status == Status.MAIN) {
            this.onMainHit(node);
        } else if (node.status == Status.NON_RESIDENT) {
            if (this.residentMain < this.maximumMainResidentSize) {
                Preconditions.checkState((this.residentFilter > this.maximumFilterSize ? 1 : 0) != 0);
                this.adaptFilterToMain(node);
            } else {
                this.onNonResidentHit(node);
            }
        } else {
            throw new IllegalStateException();
        }
    }

    private void adapt(long key) {
        this.indicator.record(key);
        if (this.indicator.getSample() == (long)this.period) {
            this.maximumFilterSize = (int)((double)this.maximumSize * this.indicator.getIndicator());
            if (this.maximumFilterSize <= 0) {
                this.maximumFilterSize = 1;
            }
            if (this.maximumFilterSize >= this.maximumSize) {
                this.maximumFilterSize = this.maximumSize - 1;
            }
            this.maximumMainResidentSize = this.maximumSize - this.maximumFilterSize;
            this.indicator.reset();
        }
    }

    private void onMiss(Node node) {
        this.policyStats.recordMiss();
        if (this.residentSize < this.maximumMainResidentSize) {
            this.onMainWarmupMiss(node);
            ++this.residentSize;
            ++this.residentMain;
        } else if (this.residentSize < this.maximumSize) {
            this.onFilterWarmupMiss(node);
            ++this.residentSize;
            ++this.residentFilter;
        } else if (this.residentFilter < this.maximumFilterSize) {
            this.adaptMainToFilter(node);
        } else {
            this.onFullMiss(node);
        }
    }

    private void adaptMainToFilter(Node node) {
        this.policyStats.recordEviction();
        this.pruneStack();
        Node victim = this.headMain.prevMain;
        victim.removeFrom(StackType.MAIN);
        this.data.remove(victim.key);
        this.pruneStack();
        --this.residentMain;
        node.moveToTop(StackType.FILTER);
        node.moveToTop(StackType.MAIN);
        node.status = Status.FILTER;
        ++this.residentFilter;
    }

    private void adaptFilterToMain(Node node) {
        this.policyStats.recordEviction();
        this.policyStats.recordMiss();
        Node victim = this.headFilter.prevFilter;
        victim.removeFrom(StackType.FILTER);
        if (victim.isInMain) {
            victim.status = Status.NON_RESIDENT;
        } else {
            this.data.remove(victim.key);
        }
        --this.residentFilter;
        node.moveToTop(StackType.MAIN);
        node.status = Status.MAIN;
        this.data.put(node.key, (Object)node);
        ++this.residentMain;
    }

    private void onMainWarmupMiss(Node node) {
        node.moveToTop(StackType.MAIN);
        node.status = Status.MAIN;
    }

    private void onFilterWarmupMiss(Node node) {
        node.moveToTop(StackType.FILTER);
        node.status = Status.FILTER;
    }

    private void onFullMiss(Node node) {
        this.policyStats.recordEviction();
        Node victim = this.headFilter.prevFilter;
        victim.removeFrom(StackType.FILTER);
        if (victim.isInMain) {
            victim.status = Status.NON_RESIDENT;
        } else {
            this.data.remove(victim.key);
        }
        node.moveToTop(StackType.FILTER);
        node.moveToTop(StackType.MAIN);
        node.status = Status.FILTER;
    }

    private void onFilterHit(Node node) {
        this.policyStats.recordHit();
        node.moveToTop(StackType.FILTER);
        node.moveToTop(StackType.MAIN);
    }

    private void onMainHit(Node node) {
        this.policyStats.recordHit();
        boolean wasBottom = this.headMain.prevMain == node;
        node.moveToTop(StackType.MAIN);
        if (wasBottom) {
            this.pruneStack();
        }
    }

    private void pruneStack() {
        Node bottom;
        while ((bottom = this.headMain.prevMain) != this.headMain && bottom.status != Status.MAIN) {
            if (bottom.status == Status.FILTER) {
                this.policyStats.recordOperation();
                bottom.removeFrom(StackType.MAIN);
                continue;
            }
            if (bottom.status != Status.NON_RESIDENT) continue;
            this.policyStats.recordOperation();
            bottom.removeFrom(StackType.MAIN);
            this.data.remove(bottom.key);
        }
    }

    private void onNonResidentHit(Node node) {
        this.policyStats.recordEviction();
        this.policyStats.recordMiss();
        this.pruneStack();
        Node victim = this.headMain.prevMain;
        victim.removeFrom(StackType.MAIN);
        this.data.remove(victim.key);
        this.pruneStack();
        node.moveToTop(StackType.MAIN);
        node.status = Status.MAIN;
        this.data.put(node.key, (Object)node);
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        long mainSize;
        long filterSize = this.data.values().stream().filter(node -> node.status == Status.FILTER).count();
        Preconditions.checkState((filterSize + (mainSize = this.data.values().stream().filter(node -> node.status == Status.MAIN).count()) <= (long)this.maximumSize ? 1 : 0) != 0);
        Preconditions.checkState(((long)this.residentFilter == filterSize ? 1 : 0) != 0);
        Preconditions.checkState(((long)this.residentMain == mainSize ? 1 : 0) != 0);
    }

    static final class FrdSettings
    extends BasicSettings {
        public FrdSettings(Config config) {
            super(config);
        }

        public double percentMain() {
            return this.config().getDouble("frd.percent-main");
        }

        public int period() {
            return this.config().getInt("frd.period");
        }
    }

    final class Node {
        final long key;
        Status status;
        Node prevFilter;
        Node nextFilter;
        Node prevMain;
        Node nextMain;
        boolean isInFilter;
        boolean isInMain;

        Node() {
            this.key = Long.MIN_VALUE;
            this.prevMain = this.nextMain = this;
            this.prevFilter = this.nextFilter = this;
        }

        Node(long key) {
            this.key = key;
        }

        public boolean isInStack(StackType stackType) {
            if (stackType == StackType.FILTER) {
                return this.isInFilter;
            }
            if (stackType == StackType.MAIN) {
                return this.isInMain;
            }
            throw new IllegalArgumentException();
        }

        public void moveToTop(StackType stackType) {
            if (this.isInStack(stackType)) {
                this.removeFrom(stackType);
            }
            if (stackType == StackType.FILTER) {
                Node next = IndicatorFrdPolicy.this.headFilter.nextFilter;
                IndicatorFrdPolicy.this.headFilter.nextFilter = this;
                next.prevFilter = this;
                this.nextFilter = next;
                this.prevFilter = IndicatorFrdPolicy.this.headFilter;
                this.isInFilter = true;
            } else if (stackType == StackType.MAIN) {
                Node next = IndicatorFrdPolicy.this.headMain.nextMain;
                IndicatorFrdPolicy.this.headMain.nextMain = this;
                next.prevMain = this;
                this.nextMain = next;
                this.prevMain = IndicatorFrdPolicy.this.headMain;
                this.isInMain = true;
            } else {
                throw new IllegalArgumentException();
            }
        }

        public void removeFrom(StackType stackType) {
            Preconditions.checkState((boolean)this.isInStack(stackType));
            if (stackType == StackType.FILTER) {
                this.prevFilter.nextFilter = this.nextFilter;
                this.nextFilter.prevFilter = this.prevFilter;
                this.nextFilter = null;
                this.prevFilter = null;
                this.isInFilter = false;
            } else if (stackType == StackType.MAIN) {
                this.prevMain.nextMain = this.nextMain;
                this.nextMain.prevMain = this.prevMain;
                this.nextMain = null;
                this.prevMain = null;
                this.isInMain = false;
            } else {
                throw new IllegalArgumentException();
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("type", (Object)this.status).toString();
        }
    }

    static enum StackType {
        FILTER,
        MAIN;

    }

    static enum Status {
        NON_RESIDENT,
        FILTER,
        MAIN;

    }
}

