/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.irr;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Policy.PolicySpec(name="irr.DClock")
public final class DClockPolicy
implements Policy.KeyOnlyPolicy {
    final Long2ObjectMap<Node> data;
    final PolicyStats policyStats;
    final Node headNonResident;
    final Node headInactive;
    final Node headActive;
    final int maximumSize;
    final int maxActive;
    int inactiveSize;
    int activeSize;
    long activations;
    long evictions;

    public DClockPolicy(DClockSettings settings, double percentActive) {
        this.policyStats = new PolicyStats(this.name() + " (active: %d%%)", (int)(100.0 * percentActive));
        this.maximumSize = Math.toIntExact(settings.maximumSize());
        this.maxActive = (int)(percentActive * (double)this.maximumSize);
        this.data = new Long2ObjectOpenHashMap();
        this.headNonResident = new Node();
        this.headInactive = new Node();
        this.headActive = new Node();
        Preconditions.checkArgument((this.maxActive != this.maximumSize ? 1 : 0) != 0, (Object)"Must allocate some space for the inactive region");
    }

    public static Set<Policy> policies(Config config) {
        DClockSettings settings = new DClockSettings(config);
        return settings.percentActive().stream().map(percentActive -> new DClockPolicy(settings, (double)percentActive)).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public void record(long key) {
        this.policyStats.recordOperation();
        Node node = (Node)this.data.get(key);
        if (node == null) {
            this.onMiss(key);
        } else if (node.status == Status.NON_RESIDENT) {
            this.onNonResidentHit(node);
        } else if (node.status == Status.INACTIVE) {
            this.onInactiveHit(node);
        } else if (node.status == Status.ACTIVE) {
            this.onActiveHit(node);
        } else {
            throw new IllegalStateException();
        }
    }

    private void onMiss(long key) {
        Node node = new Node(key, Status.INACTIVE);
        node.appendToHead(this.headInactive);
        this.policyStats.recordMiss();
        this.data.put(key, (Object)node);
        ++this.inactiveSize;
        this.evict();
    }

    private void onInactiveHit(Node node) {
        this.policyStats.recordHit();
        this.activate(node);
    }

    private void activate(Node node) {
        ++this.activeSize;
        if (this.activeSize > this.maxActive) {
            Node demote = this.headActive.next;
            ++this.inactiveSize;
            demote.remove();
            demote.status = Status.INACTIVE;
            demote.appendToHead(this.headInactive);
            --this.activeSize;
        }
        if (node.status == Status.INACTIVE) {
            --this.inactiveSize;
        } else {
            Preconditions.checkState((node.status == Status.NON_RESIDENT ? 1 : 0) != 0);
        }
        node.remove();
        node.status = Status.ACTIVE;
        node.appendToHead(this.headActive);
        ++this.activations;
    }

    private void onActiveHit(Node node) {
        node.moveToHead(this.headActive);
        this.policyStats.recordHit();
    }

    private void onNonResidentHit(Node node) {
        if (this.refaultDistance(node) <= (long)this.activeSize) {
            this.activate(node);
        } else {
            node.remove();
            ++this.inactiveSize;
            node.status = Status.INACTIVE;
            node.moveToHead(this.headInactive);
        }
        this.policyStats.recordMiss();
        this.evict();
    }

    private void evict() {
        int residentSize = this.inactiveSize + this.activeSize;
        if (residentSize > this.maximumSize) {
            Node victim = this.headInactive.prev;
            this.policyStats.recordEviction();
            ++this.evictions;
            --this.inactiveSize;
            victim.remove();
            victim.status = Status.NON_RESIDENT;
            victim.appendToHead(this.headNonResident);
            victim.nonResidentAge = this.currentNonResidentAge();
        }
        this.prune();
    }

    private void prune() {
        int nonResidentSize = this.data.size() - this.maximumSize;
        if (nonResidentSize > this.maxActive) {
            Node node = this.headNonResident.prev;
            this.data.remove(node.key);
            node.remove();
        }
    }

    private long refaultDistance(Node node) {
        return Math.abs(this.currentNonResidentAge() - node.nonResidentAge);
    }

    private long currentNonResidentAge() {
        return this.evictions + this.activations;
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        int active = (int)this.data.values().stream().filter(node -> node.status == Status.ACTIVE).count();
        int inactive = (int)this.data.values().stream().filter(node -> node.status == Status.INACTIVE).count();
        int nonResident = (int)this.data.values().stream().filter(node -> node.status == Status.NON_RESIDENT).count();
        Preconditions.checkState((active == this.activeSize ? 1 : 0) != 0, (String)"Active: expected %s but was %s", (int)this.activeSize, (int)active);
        Preconditions.checkState((inactive == this.inactiveSize ? 1 : 0) != 0, (String)"Inactive: expected %s but was %s", (int)this.inactiveSize, (int)inactive);
        Preconditions.checkState((nonResident <= this.maxActive ? 1 : 0) != 0, (String)"NonResident: expected %s less than %s", (int)nonResident, (int)this.maxActive);
        Preconditions.checkState((this.data.size() <= this.maximumSize + this.maxActive ? 1 : 0) != 0);
        Preconditions.checkState((inactive + active <= this.maximumSize ? 1 : 0) != 0);
    }

    static final class DClockSettings
    extends BasicSettings {
        public DClockSettings(Config config) {
            super(config);
        }

        public List<Double> percentActive() {
            return this.config().getDoubleList("dclock.percent-active");
        }
    }

    static final class Node {
        final long key;
        long nonResidentAge;
        Status status;
        Node prev;
        Node next;

        public Node() {
            this.key = Integer.MIN_VALUE;
            this.prev = this.next = this;
        }

        public Node(long key, Status status) {
            this.status = status;
            this.key = key;
        }

        public void appendToHead(Node head) {
            Node first = head.next;
            first.prev = this;
            head.next = this;
            this.next = first;
            this.prev = head;
        }

        public void moveToHead(Node head) {
            if (this.prev != null) {
                this.prev.next = this.next;
                this.next.prev = this.prev;
            }
            this.prev = head;
            this.next = head.next;
            this.prev.next = this;
            this.next.prev = this;
        }

        public void remove() {
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.next = null;
            this.prev = null;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("status", (Object)this.status).toString();
        }
    }

    static enum Status {
        ACTIVE,
        INACTIVE,
        NON_RESIDENT;

    }
}

