/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.admission.countmin64;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.Frequency;
import com.github.benmanes.caffeine.cache.simulator.admission.countmin64.CountMin64;
import com.typesafe.config.Config;

public final class CountMin64TinyLfu
implements Frequency {
    private static final int MAX_COUNT = 15;
    final boolean conservative;
    final CountMin64 sketch;
    final int sampleSize;
    int size;

    public CountMin64TinyLfu(Config config) {
        BasicSettings settings = new BasicSettings(config);
        this.sketch = new CountMin64(settings.tinyLfu().countMin64().eps(), settings.tinyLfu().countMin64().confidence(), settings.randomSeed());
        this.sampleSize = Math.toIntExact(10L * settings.maximumSize());
        this.conservative = settings.tinyLfu().conservative();
    }

    @Override
    public int frequency(long o) {
        return (int)this.sketch.estimateCount(o);
    }

    @Override
    public void increment(long o) {
        if (this.sketch.estimateCount(o) < 15L) {
            this.sketch.add(this.conservative, o, 1L);
        }
        ++this.size;
        this.resetIfNeeded();
    }

    private void resetIfNeeded() {
        if (this.size > this.sampleSize) {
            this.size /= 2;
            for (int i = 0; i < this.sketch.depth; ++i) {
                int j = 0;
                while (j < this.sketch.width) {
                    this.size -= (int)this.sketch.table[i][j] & 1;
                    long[] lArray = this.sketch.table[i];
                    int n = j++;
                    lArray[n] = lArray[n] >>> 1;
                }
            }
        }
    }
}

