/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.adaptive;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.typesafe.config.Config;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;

@Policy.PolicySpec(name="adaptive.Arc")
public final class ArcPolicy
implements Policy.KeyOnlyPolicy {
    private final Long2ObjectMap<Node> data;
    private final PolicyStats policyStats;
    private final int maximumSize;
    private final Node headT1;
    private final Node headT2;
    private final Node headB1;
    private final Node headB2;
    private int sizeT1;
    private int sizeT2;
    private int sizeB1;
    private int sizeB2;
    private int p;

    public ArcPolicy(Config config) {
        BasicSettings settings = new BasicSettings(config);
        this.maximumSize = Ints.checkedCast((long)settings.maximumSize());
        this.policyStats = new PolicyStats(this.name(), new Object[0]);
        this.data = new Long2ObjectOpenHashMap();
        this.headT1 = new Node();
        this.headT2 = new Node();
        this.headB1 = new Node();
        this.headB2 = new Node();
    }

    @Override
    public void record(long key) {
        this.policyStats.recordOperation();
        Node node = (Node)this.data.get(key);
        if (node == null) {
            this.onMiss(key);
        } else if (node.type == QueueType.B1) {
            this.onHitB1(node);
        } else if (node.type == QueueType.B2) {
            this.onHitB2(node);
        } else {
            this.onHit(node);
        }
    }

    private void onHit(Node node) {
        if (node.type == QueueType.T1) {
            --this.sizeT1;
            ++this.sizeT2;
        }
        node.remove();
        node.type = QueueType.T2;
        node.appendToTail(this.headT2);
        this.policyStats.recordHit();
    }

    private void onHitB1(Node node) {
        this.p = Math.min(this.maximumSize, this.p + Math.max(this.sizeB2 / this.sizeB1, 1));
        this.evict(node);
        ++this.sizeT2;
        --this.sizeB1;
        node.remove();
        node.type = QueueType.T2;
        node.appendToTail(this.headT2);
        this.policyStats.recordMiss();
    }

    private void onHitB2(Node node) {
        this.p = Math.max(0, this.p - Math.max(this.sizeB1 / this.sizeB2, 1));
        this.evict(node);
        ++this.sizeT2;
        --this.sizeB2;
        node.remove();
        node.type = QueueType.T2;
        node.appendToTail(this.headT2);
        this.policyStats.recordMiss();
    }

    private void onMiss(long key) {
        Node node = new Node(key);
        node.type = QueueType.T1;
        int sizeL1 = this.sizeT1 + this.sizeB1;
        int sizeL2 = this.sizeT2 + this.sizeB2;
        if (sizeL1 == this.maximumSize) {
            if (this.sizeT1 < this.maximumSize) {
                Node victim = this.headB1.next;
                this.data.remove(victim.key);
                victim.remove();
                --this.sizeB1;
                this.evict(node);
            } else {
                Node victim = this.headT1.next;
                this.data.remove(victim.key);
                victim.remove();
                --this.sizeT1;
            }
        } else if (sizeL1 < this.maximumSize && sizeL1 + sizeL2 >= this.maximumSize) {
            if (sizeL1 + sizeL2 >= 2 * this.maximumSize) {
                Node victim = this.headB2.next;
                this.data.remove(victim.key);
                victim.remove();
                --this.sizeB2;
            }
            this.evict(node);
        }
        ++this.sizeT1;
        this.data.put(key, (Object)node);
        node.appendToTail(this.headT1);
        this.policyStats.recordMiss();
    }

    private void evict(Node candidate) {
        if (this.sizeT1 >= 1 && (candidate.type == QueueType.B2 && this.sizeT1 == this.p || this.sizeT1 > this.p)) {
            Node victim = this.headT1.next;
            victim.remove();
            victim.type = QueueType.B1;
            victim.appendToTail(this.headB1);
            --this.sizeT1;
            ++this.sizeB1;
        } else {
            Node victim = this.headT2.next;
            victim.remove();
            victim.type = QueueType.B2;
            victim.appendToTail(this.headB2);
            --this.sizeT2;
            ++this.sizeB2;
        }
        this.policyStats.recordEviction();
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        this.policyStats.setPercentAdaption((double)this.sizeT1 / (double)this.maximumSize - 0.5);
        Preconditions.checkState(((long)this.sizeT1 == this.data.values().stream().filter(node -> node.type == QueueType.T1).count() ? 1 : 0) != 0);
        Preconditions.checkState(((long)this.sizeT2 == this.data.values().stream().filter(node -> node.type == QueueType.T2).count() ? 1 : 0) != 0);
        Preconditions.checkState(((long)this.sizeB1 == this.data.values().stream().filter(node -> node.type == QueueType.B1).count() ? 1 : 0) != 0);
        Preconditions.checkState(((long)this.sizeB2 == this.data.values().stream().filter(node -> node.type == QueueType.B2).count() ? 1 : 0) != 0);
        Preconditions.checkState((this.sizeT1 + this.sizeT2 <= this.maximumSize ? 1 : 0) != 0);
        Preconditions.checkState((this.sizeB1 + this.sizeB2 <= this.maximumSize ? 1 : 0) != 0);
    }

    static final class Node {
        final long key;
        Node prev;
        Node next;
        QueueType type;

        Node() {
            this.key = Long.MIN_VALUE;
            this.prev = this;
            this.next = this;
        }

        Node(long key) {
            this.key = key;
        }

        public void appendToTail(Node head) {
            Node tail = head.prev;
            head.prev = this;
            tail.next = this;
            this.next = head;
            this.prev = tail;
        }

        public void remove() {
            Preconditions.checkState((this.key != Long.MIN_VALUE ? 1 : 0) != 0);
            this.prev.next = this.next;
            this.next.prev = this.prev;
            this.next = null;
            this.prev = null;
            this.type = null;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", this.key).add("type", (Object)this.type).toString();
        }
    }

    private static enum QueueType {
        T1,
        B1,
        T2,
        B2;

    }
}

