/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.parser.adapt_size;

import com.github.benmanes.caffeine.cache.simulator.parser.TextTraceReader;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.google.common.hash.Hashing;
import java.util.Set;
import java.util.stream.Stream;

public final class AdaptSizeTraceReader
extends TextTraceReader {
    public AdaptSizeTraceReader(String filePath) {
        super(filePath);
    }

    @Override
    public Set<Policy.Characteristic> characteristics() {
        return Set.of(Policy.Characteristic.WEIGHTED);
    }

    @Override
    public Stream<AccessEvent> events() {
        return this.lines().map(line -> line.split(" ", 3)).map(array -> {
            long key = Long.parseLong(array[1]);
            int weight = Integer.parseInt(array[2]);
            long hashKey = Hashing.murmur3_128().newHasher().putLong(key).putInt(weight).hash().asLong();
            return AccessEvent.forKeyAndWeight(hashKey, weight);
        });
    }
}

