/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.primitives.Ints;
import com.typesafe.config.Config;
import java.util.Set;

@Policy.PolicySpec(name="product.Caffeine", characteristics={Policy.Characteristic.WEIGHTED})
public final class CaffeinePolicy
implements Policy {
    private final Cache<Long, AccessEvent> cache;
    private final PolicyStats policyStats = new PolicyStats(this.name(), new Object[0]);

    public CaffeinePolicy(Config config, Set<Policy.Characteristic> characteristics) {
        BasicSettings settings = new BasicSettings(config);
        Caffeine builder = Caffeine.newBuilder().removalListener((key, value, cause) -> this.policyStats.recordEviction()).executor(Runnable::run);
        if (characteristics.contains((Object)Policy.Characteristic.WEIGHTED)) {
            builder.maximumWeight(settings.maximumSize());
            builder.weigher((key, value) -> value.weight());
        } else {
            builder.maximumSize(settings.maximumSize());
            builder.initialCapacity(Ints.saturatedCast((long)settings.maximumSize()));
        }
        this.cache = builder.build();
    }

    @Override
    public void record(AccessEvent event) {
        AccessEvent value = (AccessEvent)this.cache.getIfPresent((Object)event.key());
        if (value == null) {
            this.cache.put((Object)event.key(), (Object)event);
            this.policyStats.recordWeightedMiss(event.weight());
        } else {
            this.policyStats.recordWeightedHit(event.weight());
            if (event.weight() != value.weight()) {
                this.cache.put((Object)event.key(), (Object)event);
            }
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }
}

