/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.adaptive.ArcPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.adaptive.CarPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.adaptive.CartPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.irr.ClockProPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.irr.FrdPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.irr.HillClimberFrdPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.irr.IndicatorFrdPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.irr.LirsPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.linked.FrequentlyUsedPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.linked.LinkedPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.linked.MultiQueuePolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.linked.S4LruPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.linked.SegmentedLruPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.opt.ClairvoyantPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.opt.UnboundedPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.Cache2kPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.CaffeinePolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.CollisionPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.Ehcache3Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.ElasticSearchPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.ExpiringMapPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.GuavaPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.OhcPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.TCachePolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sampled.SampledPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.WindowTinyLfuPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.HillClimberWindowTinyLfuPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.feedback.FeedbackTinyLfuPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.feedback.FeedbackWindowTinyLfuPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.segment.FullySegmentedWindowTinyLfuPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.segment.LruWindowTinyLfuPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.segment.RandomWindowTinyLfuPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.segment.S4WindowTinyLfuPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.tinycache.TinyCachePolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.tinycache.TinyCacheWithGhostCachePolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.tinycache.WindowTinyCachePolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.two_queue.TuQueuePolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.two_queue.TwoQueuePolicy;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Registry {
    private static final Map<String, Function<Config, Set<Policy>>> FACTORIES = Registry.makeRegistry();

    private Registry() {
    }

    private static Map<String, Function<Config, Set<Policy>>> makeRegistry() {
        HashMap<String, Function<Config, Set<Policy>>> factories = new HashMap<String, Function<Config, Set<Policy>>>();
        Registry.registerIrr(factories);
        Registry.registerLinked(factories);
        Registry.registerSketch(factories);
        Registry.registerOptimal(factories);
        Registry.registerSampled(factories);
        Registry.registerProduct(factories);
        Registry.registerTwoQueue(factories);
        Registry.registerAdaptive(factories);
        return factories.entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toLowerCase(Locale.US), Map.Entry::getValue));
    }

    public static Set<Policy> policies(BasicSettings settings) {
        return settings.policies().stream().flatMap(name -> Registry.policy(settings, name).stream()).collect(Collectors.toSet());
    }

    public static Set<Policy> policy(BasicSettings settings, String name) {
        Function<Config, Set<Policy>> factory = FACTORIES.get(name.toLowerCase(Locale.US));
        Preconditions.checkNotNull(factory, (String)"%s not found", (Object)name);
        return factory.apply(settings.config());
    }

    private static void registerOptimal(Map<String, Function<Config, Set<Policy>>> factories) {
        factories.put("opt.Clairvoyant", ClairvoyantPolicy::policies);
        factories.put("opt.Unbounded", UnboundedPolicy::policies);
    }

    private static void registerLinked(Map<String, Function<Config, Set<Policy>>> factories) {
        Stream.of(LinkedPolicy.EvictionPolicy.values()).forEach(priority -> {
            String id = "linked." + priority.name();
            factories.put(id, config -> LinkedPolicy.policies(config, priority));
        });
        Stream.of(FrequentlyUsedPolicy.EvictionPolicy.values()).forEach(priority -> {
            String id = "linked." + priority.name();
            factories.put(id, config -> FrequentlyUsedPolicy.policies(config, priority));
        });
        factories.put("linked.SegmentedLru", SegmentedLruPolicy::policies);
        factories.put("linked.Multiqueue", MultiQueuePolicy::policies);
        factories.put("linked.S4Lru", S4LruPolicy::policies);
    }

    private static void registerSampled(Map<String, Function<Config, Set<Policy>>> factories) {
        Stream.of(SampledPolicy.EvictionPolicy.values()).forEach(priority -> {
            String id = "sampled." + priority.name();
            factories.put(id, config -> SampledPolicy.policies(config, priority));
        });
    }

    private static void registerTwoQueue(Map<String, Function<Config, Set<Policy>>> factories) {
        factories.put("two-queue.TuQueue", TuQueuePolicy::policies);
        factories.put("two-queue.TwoQueue", TwoQueuePolicy::policies);
    }

    private static void registerSketch(Map<String, Function<Config, Set<Policy>>> factories) {
        factories.put("sketch.WindowTinyLfu", WindowTinyLfuPolicy::policies);
        factories.put("sketch.S4WindowTinyLfu", S4WindowTinyLfuPolicy::policies);
        factories.put("sketch.LruWindowTinyLfu", LruWindowTinyLfuPolicy::policies);
        factories.put("sketch.RandomWindowtinyLfu", RandomWindowTinyLfuPolicy::policies);
        factories.put("sketch.FullySegmentedWindowTinylfu", FullySegmentedWindowTinyLfuPolicy::policies);
        factories.put("sketch.FeedbackTinyLfu", FeedbackTinyLfuPolicy::policies);
        factories.put("sketch.FeedbackWindowTinyLfu", FeedbackWindowTinyLfuPolicy::policies);
        factories.put("sketch.HillClimberWindowTinyLfu", HillClimberWindowTinyLfuPolicy::policies);
        factories.put("sketch.TinyCache", TinyCachePolicy::policies);
        factories.put("sketch.WindowTinyCache", WindowTinyCachePolicy::policies);
        factories.put("sketch.TinyCache_GhostCache", TinyCacheWithGhostCachePolicy::policies);
    }

    private static void registerIrr(Map<String, Function<Config, Set<Policy>>> factories) {
        factories.put("irr.Frd", FrdPolicy::policies);
        factories.put("irr.IndicatorFrd", IndicatorFrdPolicy::policies);
        factories.put("irr.ClimberFrd", HillClimberFrdPolicy::policies);
        factories.put("irr.Lirs", LirsPolicy::policies);
        factories.put("irr.ClockPro", ClockProPolicy::policies);
    }

    private static void registerAdaptive(Map<String, Function<Config, Set<Policy>>> factories) {
        factories.put("adaptive.Arc", ArcPolicy::policies);
        factories.put("adaptive.Car", CarPolicy::policies);
        factories.put("adaptive.Cart", CartPolicy::policies);
    }

    private static void registerProduct(Map<String, Function<Config, Set<Policy>>> factories) {
        factories.put("product.OHC", OhcPolicy::policies);
        factories.put("product.Guava", GuavaPolicy::policies);
        factories.put("product.Tcache", TCachePolicy::policies);
        factories.put("product.Cache2k", Cache2kPolicy::policies);
        factories.put("product.Ehcache3", Ehcache3Policy::policies);
        factories.put("product.Caffeine", CaffeinePolicy::policies);
        factories.put("product.Collision", CollisionPolicy::policies);
        factories.put("product.ExpiringMap", ExpiringMapPolicy::policies);
        factories.put("product.Elasticsearch", ElasticSearchPolicy::policies);
    }
}

