/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator;

import com.github.benmanes.caffeine.cache.simulator.admission.Admission;
import com.github.benmanes.caffeine.cache.simulator.membership.FilterType;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceFormat;
import com.github.benmanes.caffeine.cache.simulator.report.ReportFormat;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class BasicSettings {
    private final Config config;

    public BasicSettings(Config config) {
        this.config = Objects.requireNonNull(config);
    }

    public ReportSettings report() {
        return new ReportSettings();
    }

    public int randomSeed() {
        return this.config().getInt("random-seed");
    }

    public int batchSize() {
        return this.config().getInt("batch-size");
    }

    public Set<String> policies() {
        return this.config().getStringList("policies").stream().map(String::toLowerCase).collect(Collectors.toSet());
    }

    public Set<Admission> admission() {
        return this.config().getStringList("admission").stream().map(String::toUpperCase).map(Admission::valueOf).collect(Collectors.toSet());
    }

    public FilterType membershipFilter() {
        return FilterType.valueOf(this.config.getString("membership-filter").toUpperCase(Locale.US));
    }

    public TinyLfuSettings tinyLfu() {
        return new TinyLfuSettings();
    }

    public int maximumSize() {
        return this.config().getInt("maximum-size");
    }

    public boolean isFiles() {
        return this.config().getString("source").equals("files");
    }

    public boolean isSynthetic() {
        return this.config().getString("source").equals("synthetic");
    }

    public TraceFilesSettings traceFiles() {
        Preconditions.checkState((boolean)this.isFiles());
        return new TraceFilesSettings();
    }

    public SyntheticSettings synthetic() {
        Preconditions.checkState((boolean)this.isSynthetic());
        return new SyntheticSettings();
    }

    public Config config() {
        return this.config;
    }

    public final class SyntheticSettings {
        public String distribution() {
            return BasicSettings.this.config().getString("synthetic.distribution");
        }

        public int events() {
            return BasicSettings.this.config().getInt("synthetic.events");
        }

        public CounterSettings counter() {
            return new CounterSettings();
        }

        public UniformSettings uniform() {
            return new UniformSettings();
        }

        public ExponentialSettings exponential() {
            return new ExponentialSettings();
        }

        public HotspotSettings hotspot() {
            return new HotspotSettings();
        }

        public ZipfianSettings zipfian() {
            return new ZipfianSettings();
        }

        public final class ZipfianSettings {
            public int items() {
                return BasicSettings.this.config().getInt("synthetic.zipfian.items");
            }

            public double constant() {
                return BasicSettings.this.config().getDouble("synthetic.zipfian.constant");
            }
        }

        public final class HotspotSettings {
            public int lowerBound() {
                return BasicSettings.this.config().getInt("synthetic.hotspot.lower-bound");
            }

            public int upperBound() {
                return BasicSettings.this.config().getInt("synthetic.hotspot.upper-bound");
            }

            public double hotsetFraction() {
                return BasicSettings.this.config().getDouble("synthetic.hotspot.hotset-fraction");
            }

            public double hotOpnFraction() {
                return BasicSettings.this.config().getDouble("synthetic.hotspot.hot-opn-fraction");
            }
        }

        public final class ExponentialSettings {
            public double mean() {
                return BasicSettings.this.config().getDouble("synthetic.exponential.mean");
            }
        }

        public final class UniformSettings {
            public int lowerBound() {
                return BasicSettings.this.config().getInt("synthetic.uniform.lower-bound");
            }

            public int upperBound() {
                return BasicSettings.this.config().getInt("synthetic.uniform.upper-bound");
            }
        }

        public final class CounterSettings {
            public int start() {
                return BasicSettings.this.config().getInt("synthetic.counter.start");
            }
        }
    }

    public final class TraceFilesSettings {
        public List<String> paths() {
            return BasicSettings.this.config().getStringList("files.paths");
        }

        public TraceFormat format() {
            return TraceFormat.named(BasicSettings.this.config().getString("files.format"));
        }
    }

    public final class TinyLfuSettings {
        public String sketch() {
            return BasicSettings.this.config().getString("tiny-lfu.sketch");
        }

        public boolean conservative() {
            return BasicSettings.this.config().getBoolean("tiny-lfu.count-min.conservative");
        }

        public CountMin4Settings countMin4() {
            return new CountMin4Settings();
        }

        public CountMin64Settings countMin64() {
            return new CountMin64Settings();
        }

        public final class DoorkeeperSettings {
            private static final String basePath = "tiny-lfu.count-min-4.periodic";

            public boolean enabled() {
                return BasicSettings.this.config().getBoolean("tiny-lfu.count-min-4.periodic.doorkeeper.enabled");
            }

            public double fpp() {
                return BasicSettings.this.config().getDouble("tiny-lfu.count-min-4.periodic.doorkeeper.fpp");
            }

            public double expectedInsertionsMultiplier() {
                return BasicSettings.this.config().getDouble("tiny-lfu.count-min-4.periodic.doorkeeper.expected-insertions-multiplier");
            }
        }

        public final class CountMin64Settings {
            public double eps() {
                return BasicSettings.this.config().getDouble("tiny-lfu.count-min-64.eps");
            }

            public double confidence() {
                return BasicSettings.this.config().getDouble("tiny-lfu.count-min-64.confidence");
            }
        }

        public final class CountMin4Settings {
            public String reset() {
                return BasicSettings.this.config().getString("tiny-lfu.count-min-4.reset");
            }

            public double countersMultiplier() {
                return BasicSettings.this.config().getDouble("tiny-lfu.count-min-4.counters-multiplier");
            }

            public IncrementalSettings incremental() {
                return new IncrementalSettings();
            }

            public PeriodicSettings periodic() {
                return new PeriodicSettings();
            }

            public final class PeriodicSettings {
                public DoorkeeperSettings doorkeeper() {
                    return new DoorkeeperSettings();
                }
            }

            public final class IncrementalSettings {
                public int interval() {
                    return BasicSettings.this.config().getInt("tiny-lfu.count-min-4.incremental.interval");
                }
            }
        }
    }

    public final class ReportSettings {
        public ReportFormat format() {
            return ReportFormat.valueOf(BasicSettings.this.config().getString("report.format").toUpperCase(Locale.US));
        }

        public String sortBy() {
            return BasicSettings.this.config().getString("report.sort-by").trim();
        }

        public boolean ascending() {
            return BasicSettings.this.config().getBoolean("report.ascending");
        }

        public String output() {
            return BasicSettings.this.config().getString("report.output").trim();
        }
    }
}

