/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.sketch.tinycache;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.tinycache.TinyCacheWithGhostCache;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.collect.ImmutableSet;
import com.typesafe.config.Config;
import java.util.Set;

public final class TinyCacheWithGhostCachePolicy
implements Policy {
    private final TinyCacheWithGhostCache tinyCache;
    private final PolicyStats policyStats;

    public TinyCacheWithGhostCachePolicy(Config config) {
        BasicSettings settings = new BasicSettings(config);
        this.policyStats = new PolicyStats("sketch.TinyCache_GhostCache");
        this.tinyCache = new TinyCacheWithGhostCache((int)Math.ceil((double)settings.maximumSize() / 64.0), 64, settings.randomSeed());
    }

    public static Set<Policy> policies(Config config) {
        return ImmutableSet.of((Object)new TinyCacheWithGhostCachePolicy(config));
    }

    @Override
    public void record(long key) {
        if (this.tinyCache.contains(key)) {
            this.tinyCache.recordItem(key);
            this.policyStats.recordHit();
        } else {
            boolean evicted = this.tinyCache.addItem(key);
            this.tinyCache.recordItem(key);
            this.policyStats.recordMiss();
            if (evicted) {
                this.policyStats.recordEviction();
            }
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }
}

