/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.collect.ImmutableSet;
import com.typesafe.config.Config;
import java.util.Set;
import org.rapidoid.cache.Cache;
import org.rapidoid.cache.Caching;

public final class RapidoidPolicy
implements Policy {
    private final Cache<Object, Object> cache;
    private final PolicyStats policyStats = new PolicyStats("product.Rapidoid");
    private final int maximumSize;

    public RapidoidPolicy(Config config) {
        BasicSettings settings = new BasicSettings(config);
        this.maximumSize = settings.maximumSize();
        this.cache = Caching.of(Object.class, Object.class).capacity(this.maximumSize).build();
    }

    public static Set<Policy> policies(Config config) {
        return ImmutableSet.of((Object)new RapidoidPolicy(config));
    }

    @Override
    public void record(long key) {
        Object value = this.cache.getIfExists((Object)key);
        if (value == null) {
            if (this.cache.size() == this.maximumSize) {
                this.policyStats.recordEviction();
            }
            this.cache.set((Object)key, (Object)key);
            this.policyStats.recordMiss();
        } else {
            this.policyStats.recordHit();
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }
}

