/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.core.internal.statistics.DefaultStatisticsService;
import org.ehcache.core.statistics.CacheStatistics;
import org.ehcache.spi.service.Service;

@Policy.PolicySpec(name="product.Ehcache3")
public final class Ehcache3Policy
implements Policy {
    private final Cache<Long, Boolean> cache;
    private final CacheManager cacheManager;
    private final PolicyStats policyStats = new PolicyStats(this.name(), new Object[0]);
    private final CacheStatistics stats;

    public Ehcache3Policy(Config config) {
        BasicSettings settings = new BasicSettings(config);
        DefaultStatisticsService statistics = new DefaultStatisticsService();
        this.cacheManager = CacheManagerBuilder.newCacheManagerBuilder().using((Service)statistics).build(true);
        this.cache = this.cacheManager.createCache("ehcache3", CacheConfigurationBuilder.newCacheConfigurationBuilder(Long.class, Boolean.class, (Builder)ResourcePoolsBuilder.newResourcePoolsBuilder().heap(settings.maximumSize(), (ResourceUnit)EntryUnit.ENTRIES)).build());
        this.stats = statistics.getCacheStatistics("ehcache3");
    }

    @Override
    public void record(AccessEvent event) {
        Long key = event.longKey();
        Boolean value = (Boolean)this.cache.get((Object)key);
        if (value == null) {
            this.cache.put((Object)key, (Object)true);
            this.policyStats.recordMiss();
        } else {
            this.policyStats.recordHit();
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        this.cacheManager.close();
        this.policyStats.addEvictions(this.stats.getCacheEvictions());
        Preconditions.checkState((this.policyStats.hitCount() == this.stats.getCacheHits() ? 1 : 0) != 0);
        Preconditions.checkState((this.policyStats.missCount() == this.stats.getCacheMisses() ? 1 : 0) != 0);
    }
}

