/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.product;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.CaseFormat;
import com.google.common.base.Enums;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.tangosol.net.cache.CacheStatistics;
import com.tangosol.net.cache.ConfigurableCacheMap;
import com.tangosol.net.cache.LocalCache;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.typesafe.config.Config;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@Policy.PolicySpec(name="product.Coherence", characteristics={Policy.Characteristic.WEIGHTED})
public final class CoherencePolicy
implements Policy {
    private final Map<Long, AccessEvent> map;
    private final PolicyStats policyStats;
    private final CacheStatistics stats;

    public CoherencePolicy(CoherenceSettings settings, Eviction policy) {
        this.policyStats = new PolicyStats(this.name() + " (%s)", new Object[]{policy});
        int factor = 1;
        long maximum = settings.maximumSize();
        while (maximum >= Integer.MAX_VALUE) {
            maximum /= 1024L;
            factor *= 1024;
        }
        LocalCache cache = new LocalCache();
        cache.setUnitFactor(factor);
        cache.setHighUnits((int)maximum);
        cache.setEvictionType(policy.type);
        cache.addMapListener((MapListener)new CoherenceListener(this));
        cache.setUnitCalculator((ConfigurableCacheMap.UnitCalculator)new AccessEventCalculator());
        this.stats = cache.getCacheStatistics();
        this.map = cache;
    }

    public static Set<Policy> policies(Config config) {
        CoherenceSettings settings = new CoherenceSettings(config);
        return settings.policy().stream().map(policy -> new CoherencePolicy(settings, (Eviction)((Object)policy))).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public void record(AccessEvent event) {
        Long key = event.longKey();
        AccessEvent value = this.map.get(key);
        if (value == null) {
            this.map.put(key, event);
            this.policyStats.recordWeightedMiss(event.weight());
        } else {
            this.policyStats.recordWeightedHit(event.weight());
            if (event.weight() != value.weight()) {
                this.map.put(key, event);
            }
        }
    }

    @Override
    public PolicyStats stats() {
        return this.policyStats;
    }

    @Override
    public void finished() {
        Preconditions.checkState((this.policyStats.hitCount() == this.stats.getCacheHits() ? 1 : 0) != 0);
        Preconditions.checkState((this.policyStats.missCount() == this.stats.getCacheMisses() ? 1 : 0) != 0);
    }

    public static final class CoherenceSettings
    extends BasicSettings {
        public CoherenceSettings(Config config) {
            super(config);
        }

        public ImmutableSet<Eviction> policy() {
            return (ImmutableSet)this.config().getStringList("coherence.policy").stream().map(policy -> (Eviction)((Object)((Object)Enums.getIfPresent(Eviction.class, (String)policy.toUpperCase(Locale.US)).toJavaUtil().orElseThrow(() -> new IllegalArgumentException("Unknown policy: " + policy))))).collect(Sets.toImmutableEnumSet());
        }
    }

    public static enum Eviction {
        HYBRID(0),
        LRU(1),
        LFU(2);

        final int type;

        private Eviction(int type) {
            this.type = type;
        }

        public String toString() {
            return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
        }
    }

    private final class CoherenceListener
    implements MapListener<Object, Object> {
        final /* synthetic */ CoherencePolicy this$0;

        private CoherenceListener(CoherencePolicy coherencePolicy) {
            CoherencePolicy coherencePolicy2 = coherencePolicy;
            Objects.requireNonNull(coherencePolicy2);
            this.this$0 = coherencePolicy2;
        }

        public void entryInserted(MapEvent<Object, Object> event) {
        }

        public void entryUpdated(MapEvent<Object, Object> event) {
        }

        public void entryDeleted(MapEvent<Object, Object> event) {
            this.this$0.policyStats.recordEviction();
        }
    }

    private static final class AccessEventCalculator
    implements ConfigurableCacheMap.UnitCalculator {
        private AccessEventCalculator() {
        }

        public String getName() {
            return "Coherence";
        }

        public int calculateUnits(Object key, Object value) {
            return ((AccessEvent)value).weight();
        }
    }
}

