/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Semaphore;
import org.jspecify.annotations.Nullable;

public final class PolicyActor {
    private final CompletableFuture<@Nullable Void> completed;
    private final Semaphore semaphore;
    private final Policy policy;
    private final Thread parent;
    private CompletableFuture<@Nullable Void> future;

    public PolicyActor(Thread parent, Policy policy, BasicSettings settings) {
        this.semaphore = new Semaphore(settings.actor().mailboxSize());
        this.future = CompletableFuture.completedFuture(null);
        this.completed = new CompletableFuture();
        this.policy = Objects.requireNonNull(policy);
        this.parent = Objects.requireNonNull(parent);
    }

    public void send(List<AccessEvent> events) {
        this.submit(new Execute(this, events));
    }

    public void finish() {
        this.submit(new Finish(this));
    }

    public CompletableFuture<@Nullable Void> completed() {
        return this.completed;
    }

    private void submit(Command command) {
        try {
            this.semaphore.acquire();
            this.future = this.future.thenRunAsync(command);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
    }

    public PolicyStats stats() {
        return this.policy.stats();
    }

    private final class Execute
    extends Command {
        final List<AccessEvent> events;
        final /* synthetic */ PolicyActor this$0;

        Execute(PolicyActor policyActor, List<AccessEvent> events) {
            PolicyActor policyActor2 = policyActor;
            Objects.requireNonNull(policyActor2);
            this.this$0 = policyActor2;
            super(policyActor);
            this.events = Objects.requireNonNull(events);
        }

        @Override
        public void execute() {
            this.this$0.policy.stats().stopwatch().start();
            for (AccessEvent event : this.events) {
                long priorMisses = this.this$0.policy.stats().missCount();
                long priorHits = this.this$0.policy.stats().hitCount();
                this.this$0.policy.record(event);
                if (this.this$0.policy.stats().hitCount() > priorHits) {
                    this.this$0.policy.stats().recordHitPenalty(event.hitPenalty());
                    continue;
                }
                if (this.this$0.policy.stats().missCount() <= priorMisses) continue;
                this.this$0.policy.stats().recordMissPenalty(event.missPenalty());
            }
            this.this$0.policy.stats().stopwatch().stop();
        }
    }

    private abstract class Command
    implements Runnable {
        final /* synthetic */ PolicyActor this$0;

        private Command(PolicyActor policyActor) {
            PolicyActor policyActor2 = policyActor;
            Objects.requireNonNull(policyActor2);
            this.this$0 = policyActor2;
        }

        @Override
        public final void run() {
            String name = Thread.currentThread().getName();
            Thread.currentThread().setName(this.this$0.policy.getClass().getSimpleName());
            try {
                this.execute();
            }
            catch (Throwable t) {
                this.this$0.completed.completeExceptionally(t);
                this.this$0.parent.interrupt();
                throw t;
            }
            finally {
                this.this$0.semaphore.release();
                Thread.currentThread().setName(name);
            }
        }

        abstract void execute();
    }

    private final class Finish
    extends Command {
        final /* synthetic */ PolicyActor this$0;

        private Finish(PolicyActor policyActor) {
            PolicyActor policyActor2 = policyActor;
            Objects.requireNonNull(policyActor2);
            this.this$0 = policyActor2;
            super(policyActor);
        }

        @Override
        public void execute() {
            this.this$0.policy.finished();
            this.this$0.completed.complete(null);
        }
    }
}

