/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.parser;

import com.github.benmanes.caffeine.cache.simulator.parser.AbstractTraceReader;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.google.common.io.Closeables;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jspecify.annotations.Nullable;

public abstract class BinaryTraceReader
extends AbstractTraceReader {
    protected BinaryTraceReader(String filePath) {
        super(filePath);
    }

    @Override
    public Stream<AccessEvent> events() {
        DataInputStream input = new DataInputStream(this.readFile());
        Stream<AccessEvent> stream = StreamSupport.stream(Spliterators.spliteratorUnknownSize(new TraceIterator(this, input), 272), false);
        return (Stream)stream.onClose(() -> Closeables.closeQuietly((InputStream)input));
    }

    protected abstract AccessEvent readEvent(DataInputStream var1) throws IOException;

    private final class TraceIterator
    implements Iterator<AccessEvent> {
        final DataInputStream input;
        @Nullable AccessEvent next;
        boolean ready;
        final /* synthetic */ BinaryTraceReader this$0;

        TraceIterator(BinaryTraceReader binaryTraceReader, DataInputStream input) {
            BinaryTraceReader binaryTraceReader2 = binaryTraceReader;
            Objects.requireNonNull(binaryTraceReader2);
            this.this$0 = binaryTraceReader2;
            this.input = Objects.requireNonNull(input);
        }

        @Override
        public boolean hasNext() {
            if (this.ready) {
                return true;
            }
            try {
                this.next = this.this$0.readEvent(this.input);
                this.ready = true;
                return true;
            }
            catch (EOFException eOFException) {
                return false;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public AccessEvent next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Objects.requireNonNull(this.next);
            this.ready = false;
            return this.next;
        }
    }
}

