/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator;

import com.github.benmanes.caffeine.cache.simulator.admission.Admission;
import com.github.benmanes.caffeine.cache.simulator.membership.FilterType;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceFormat;
import com.github.benmanes.caffeine.cache.simulator.report.ReportFormat;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;

public class BasicSettings {
    private static final Pattern NUMERIC_SEPARATOR = Pattern.compile("[_,]");
    private final Config config;

    public BasicSettings(Config config) {
        this.config = Objects.requireNonNull(config);
    }

    public ActorSettings actor() {
        return new ActorSettings(this);
    }

    public ReportSettings report() {
        return new ReportSettings(this);
    }

    public int randomSeed() {
        return this.getFormattedInt("random-seed");
    }

    public Set<String> policies() {
        return (Set)this.config().getStringList("policies").stream().map(policy -> policy.toLowerCase(Locale.US)).collect(ImmutableSet.toImmutableSet());
    }

    public Set<Admission> admission() {
        return (Set)this.config().getStringList("admission").stream().map(policy -> policy.toUpperCase(Locale.US)).map(Admission::valueOf).collect(Sets.toImmutableEnumSet());
    }

    public MembershipSettings membership() {
        return new MembershipSettings(this);
    }

    public TinyLfuSettings tinyLfu() {
        return new TinyLfuSettings(this);
    }

    public long maximumSize() {
        return this.getFormattedLong("maximum-size");
    }

    public TraceSettings trace() {
        return new TraceSettings(this);
    }

    public Config config() {
        return this.config;
    }

    protected int getFormattedInt(String path) {
        Function<String, @Nullable Integer> tryParse = Ints::tryParse;
        return this.parseFormattedNumber(path, arg_0 -> ((Config)this.config()).getInt(arg_0), tryParse);
    }

    protected long getFormattedLong(String path) {
        Function<String, @Nullable Long> tryParse = Longs::tryParse;
        return this.parseFormattedNumber(path, arg_0 -> ((Config)this.config()).getLong(arg_0), tryParse);
    }

    private <T extends Number> T parseFormattedNumber(String path, Function<String, T> getter, Function<String, @Nullable T> tryParse) {
        try {
            return (T)((Number)getter.apply(path));
        }
        catch (ConfigException.Parse | ConfigException.WrongType e) {
            Matcher matcher = NUMERIC_SEPARATOR.matcher(this.config().getString(path));
            Number value = (Number)tryParse.apply(matcher.replaceAll(""));
            if (value == null) {
                throw e;
            }
            return (T)value;
        }
    }

    public final class ActorSettings {
        final /* synthetic */ BasicSettings this$0;

        public ActorSettings(BasicSettings this$0) {
            BasicSettings basicSettings = this$0;
            Objects.requireNonNull(basicSettings);
            this.this$0 = basicSettings;
        }

        public int mailboxSize() {
            return this.this$0.config().getInt("actor.mailbox-size");
        }

        public int batchSize() {
            return this.this$0.config().getInt("actor.batch-size");
        }
    }

    public final class ReportSettings {
        final /* synthetic */ BasicSettings this$0;

        public ReportSettings(BasicSettings this$0) {
            BasicSettings basicSettings = this$0;
            Objects.requireNonNull(basicSettings);
            this.this$0 = basicSettings;
        }

        public ReportFormat format() {
            return ReportFormat.valueOf(this.this$0.config().getString("report.format").toUpperCase(Locale.US));
        }

        public String sortBy() {
            return this.this$0.config().getString("report.sort-by").trim();
        }

        public boolean ascending() {
            return this.this$0.config().getBoolean("report.ascending");
        }

        public String output() {
            return this.this$0.config().getString("report.output").trim();
        }
    }

    public final class MembershipSettings {
        final /* synthetic */ BasicSettings this$0;

        public MembershipSettings(BasicSettings this$0) {
            BasicSettings basicSettings = this$0;
            Objects.requireNonNull(basicSettings);
            this.this$0 = basicSettings;
        }

        public FilterType filter() {
            String type = this.this$0.config().getString("membership.filter");
            return FilterType.valueOf(CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, type));
        }

        public long expectedInsertions() {
            double multiplier = this.this$0.config().getDouble("membership.expected-insertions-multiplier");
            return (long)((double)this.this$0.maximumSize() * multiplier);
        }

        public double fpp() {
            return this.this$0.config().getDouble("membership.fpp");
        }
    }

    public final class TinyLfuSettings {
        final /* synthetic */ BasicSettings this$0;

        public TinyLfuSettings(BasicSettings this$0) {
            BasicSettings basicSettings = this$0;
            Objects.requireNonNull(basicSettings);
            this.this$0 = basicSettings;
        }

        public String sketch() {
            return this.this$0.config().getString("tiny-lfu.sketch");
        }

        public boolean conservative() {
            return this.this$0.config().getBoolean("tiny-lfu.count-min.conservative");
        }

        public JitterSettings jitter() {
            return new JitterSettings(this);
        }

        public CountMin4Settings countMin4() {
            return new CountMin4Settings(this);
        }

        public CountMin64Settings countMin64() {
            return new CountMin64Settings(this);
        }

        public final class JitterSettings {
            final /* synthetic */ TinyLfuSettings this$1;

            public JitterSettings(TinyLfuSettings this$1) {
                TinyLfuSettings tinyLfuSettings = this$1;
                Objects.requireNonNull(tinyLfuSettings);
                this.this$1 = tinyLfuSettings;
            }

            public boolean enabled() {
                return this.this$1.this$0.config().getBoolean("tiny-lfu.jitter.enabled");
            }

            public int threshold() {
                return this.this$1.this$0.config().getInt("tiny-lfu.jitter.threshold");
            }

            public double probability() {
                return this.this$1.this$0.config().getDouble("tiny-lfu.jitter.probability");
            }
        }

        public final class CountMin4Settings {
            final /* synthetic */ TinyLfuSettings this$1;

            public CountMin4Settings(TinyLfuSettings this$1) {
                TinyLfuSettings tinyLfuSettings = this$1;
                Objects.requireNonNull(tinyLfuSettings);
                this.this$1 = tinyLfuSettings;
            }

            public String reset() {
                return this.this$1.this$0.config().getString("tiny-lfu.count-min-4.reset");
            }

            public double countersMultiplier() {
                return this.this$1.this$0.config().getDouble("tiny-lfu.count-min-4.counters-multiplier");
            }

            public IncrementalSettings incremental() {
                return new IncrementalSettings(this);
            }

            public PeriodicSettings periodic() {
                return new PeriodicSettings(this);
            }

            public final class IncrementalSettings {
                final /* synthetic */ CountMin4Settings this$2;

                public IncrementalSettings(CountMin4Settings this$2) {
                    CountMin4Settings countMin4Settings = this$2;
                    Objects.requireNonNull(countMin4Settings);
                    this.this$2 = countMin4Settings;
                }

                public int interval() {
                    return this.this$2.this$1.this$0.config().getInt("tiny-lfu.count-min-4.incremental.interval");
                }
            }

            public final class PeriodicSettings {
                final /* synthetic */ CountMin4Settings this$2;

                public PeriodicSettings(CountMin4Settings this$2) {
                    CountMin4Settings countMin4Settings = this$2;
                    Objects.requireNonNull(countMin4Settings);
                    this.this$2 = countMin4Settings;
                }

                public DoorkeeperSettings doorkeeper() {
                    return new DoorkeeperSettings(this.this$2.this$1);
                }
            }
        }

        public final class CountMin64Settings {
            final /* synthetic */ TinyLfuSettings this$1;

            public CountMin64Settings(TinyLfuSettings this$1) {
                TinyLfuSettings tinyLfuSettings = this$1;
                Objects.requireNonNull(tinyLfuSettings);
                this.this$1 = tinyLfuSettings;
            }

            public double eps() {
                return this.this$1.this$0.config().getDouble("tiny-lfu.count-min-64.eps");
            }

            public double confidence() {
                return this.this$1.this$0.config().getDouble("tiny-lfu.count-min-64.confidence");
            }
        }

        public final class DoorkeeperSettings {
            final /* synthetic */ TinyLfuSettings this$1;

            public DoorkeeperSettings(TinyLfuSettings this$1) {
                TinyLfuSettings tinyLfuSettings = this$1;
                Objects.requireNonNull(tinyLfuSettings);
                this.this$1 = tinyLfuSettings;
            }

            public boolean enabled() {
                return this.this$1.this$0.config().getBoolean("tiny-lfu.count-min-4.periodic.doorkeeper.enabled");
            }
        }
    }

    public final class TraceSettings {
        final /* synthetic */ BasicSettings this$0;

        public TraceSettings(BasicSettings this$0) {
            BasicSettings basicSettings = this$0;
            Objects.requireNonNull(basicSettings);
            this.this$0 = basicSettings;
        }

        public long skip() {
            return this.this$0.getFormattedLong("trace.skip");
        }

        public long limit() {
            return this.this$0.config().getIsNull("trace.limit") ? Long.MAX_VALUE : this.this$0.getFormattedLong("trace.limit");
        }

        public boolean isFiles() {
            return this.this$0.config().getString("trace.source").equals("files");
        }

        public boolean isSynthetic() {
            return this.this$0.config().getString("trace.source").equals("synthetic");
        }

        public TraceFilesSettings traceFiles() {
            Preconditions.checkState((boolean)this.isFiles());
            return new TraceFilesSettings(this.this$0);
        }

        public SyntheticSettings synthetic() {
            Preconditions.checkState((boolean)this.isSynthetic());
            return new SyntheticSettings(this.this$0);
        }
    }

    public final class SyntheticSettings {
        final /* synthetic */ BasicSettings this$0;

        public SyntheticSettings(BasicSettings this$0) {
            BasicSettings basicSettings = this$0;
            Objects.requireNonNull(basicSettings);
            this.this$0 = basicSettings;
        }

        public String distribution() {
            return this.this$0.config().getString("synthetic.distribution");
        }

        public int events() {
            return this.this$0.config().getInt("synthetic.events");
        }

        public CounterSettings counter() {
            return new CounterSettings(this);
        }

        public RepeatSettings repeating() {
            return new RepeatSettings(this);
        }

        public UniformSettings uniform() {
            return new UniformSettings(this);
        }

        public ExponentialSettings exponential() {
            return new ExponentialSettings(this);
        }

        public HotspotSettings hotspot() {
            return new HotspotSettings(this);
        }

        public ZipfianSettings zipfian() {
            return new ZipfianSettings(this);
        }

        public final class CounterSettings {
            final /* synthetic */ SyntheticSettings this$1;

            public CounterSettings(SyntheticSettings this$1) {
                SyntheticSettings syntheticSettings = this$1;
                Objects.requireNonNull(syntheticSettings);
                this.this$1 = syntheticSettings;
            }

            public int start() {
                return this.this$1.this$0.config().getInt("synthetic.counter.start");
            }
        }

        public final class RepeatSettings {
            final /* synthetic */ SyntheticSettings this$1;

            public RepeatSettings(SyntheticSettings this$1) {
                SyntheticSettings syntheticSettings = this$1;
                Objects.requireNonNull(syntheticSettings);
                this.this$1 = syntheticSettings;
            }

            public int items() {
                return this.this$1.this$0.config().getInt("synthetic.repeating.items");
            }
        }

        public final class UniformSettings {
            final /* synthetic */ SyntheticSettings this$1;

            public UniformSettings(SyntheticSettings this$1) {
                SyntheticSettings syntheticSettings = this$1;
                Objects.requireNonNull(syntheticSettings);
                this.this$1 = syntheticSettings;
            }

            public int lowerBound() {
                return this.this$1.this$0.config().getInt("synthetic.uniform.lower-bound");
            }

            public int upperBound() {
                return this.this$1.this$0.config().getInt("synthetic.uniform.upper-bound");
            }
        }

        public final class ExponentialSettings {
            final /* synthetic */ SyntheticSettings this$1;

            public ExponentialSettings(SyntheticSettings this$1) {
                SyntheticSettings syntheticSettings = this$1;
                Objects.requireNonNull(syntheticSettings);
                this.this$1 = syntheticSettings;
            }

            public double mean() {
                return this.this$1.this$0.config().getDouble("synthetic.exponential.mean");
            }
        }

        public final class HotspotSettings {
            final /* synthetic */ SyntheticSettings this$1;

            public HotspotSettings(SyntheticSettings this$1) {
                SyntheticSettings syntheticSettings = this$1;
                Objects.requireNonNull(syntheticSettings);
                this.this$1 = syntheticSettings;
            }

            public int lowerBound() {
                return this.this$1.this$0.config().getInt("synthetic.hotspot.lower-bound");
            }

            public int upperBound() {
                return this.this$1.this$0.config().getInt("synthetic.hotspot.upper-bound");
            }

            public double hotsetFraction() {
                return this.this$1.this$0.config().getDouble("synthetic.hotspot.hotset-fraction");
            }

            public double hotOpnFraction() {
                return this.this$1.this$0.config().getDouble("synthetic.hotspot.hot-opn-fraction");
            }
        }

        public final class ZipfianSettings {
            final /* synthetic */ SyntheticSettings this$1;

            public ZipfianSettings(SyntheticSettings this$1) {
                SyntheticSettings syntheticSettings = this$1;
                Objects.requireNonNull(syntheticSettings);
                this.this$1 = syntheticSettings;
            }

            public int items() {
                return this.this$1.this$0.config().getInt("synthetic.zipfian.items");
            }

            public double constant() {
                return this.this$1.this$0.config().getDouble("synthetic.zipfian.constant");
            }
        }
    }

    public final class TraceFilesSettings {
        final /* synthetic */ BasicSettings this$0;

        public TraceFilesSettings(BasicSettings this$0) {
            BasicSettings basicSettings = this$0;
            Objects.requireNonNull(basicSettings);
            this.this$0 = basicSettings;
        }

        public List<String> paths() {
            return this.this$0.config().getStringList("files.paths");
        }

        public TraceFormat format() {
            return TraceFormat.named(this.this$0.config().getString("files.format"));
        }
    }
}

