/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing;

import com.google.common.base.Preconditions;

public interface HillClimber {
    public void onHit(long var1, QueueType var3, boolean var4);

    public void onMiss(long var1, boolean var3);

    public Adaptation adapt(double var1, double var3, double var5, boolean var7);

    public record Adaptation(double amount, Type type) {
        private static final Adaptation HOLD = new Adaptation(0.0, Type.HOLD);

        public Adaptation {
            Preconditions.checkArgument((amount >= 0.0 ? 1 : 0) != 0, (String)"Step size %s must be positive", (Object)amount);
        }

        public static Adaptation adaptBy(double amount) {
            if (amount == 0.0) {
                return Adaptation.hold();
            }
            if (amount < 0.0) {
                return Adaptation.decreaseWindow(Math.abs(amount));
            }
            return Adaptation.increaseWindow(amount);
        }

        public static int roundToInt(double amount) {
            return amount < 0.0 ? (int)Math.floor(amount) : (int)Math.ceil(amount);
        }

        public static Adaptation hold() {
            return HOLD;
        }

        public static Adaptation increaseWindow(double amount) {
            return new Adaptation(amount, Type.INCREASE_WINDOW);
        }

        public static Adaptation decreaseWindow(double amount) {
            return new Adaptation(amount, Type.DECREASE_WINDOW);
        }

        @Override
        public String toString() {
            return switch (this.type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "0";
                case 1 -> "+" + this.amount;
                case 2 -> "-" + this.amount;
            };
        }

        public static enum Type {
            HOLD,
            INCREASE_WINDOW,
            DECREASE_WINDOW;

        }
    }

    public static enum QueueType {
        WINDOW,
        PROBATION,
        PROTECTED;

    }
}

