/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.parser.adapt_size;

import com.github.benmanes.caffeine.cache.simulator.parser.TraceWriter;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;

public final class AdaptSizeTraceWriter
implements TraceWriter {
    private final BufferedWriter writer;
    private long tick;

    public AdaptSizeTraceWriter(OutputStream output) {
        this.writer = new BufferedWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));
    }

    @Override
    public void writeEvent(AccessEvent event) throws IOException {
        this.writer.write(Long.toString(++this.tick));
        this.writer.write(" ");
        this.writer.write(Long.toString(event.key()));
        this.writer.write(" ");
        this.writer.write(Integer.toString(event.weight()));
        this.writer.newLine();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

