/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.report;

import com.github.benmanes.caffeine.cache.simulator.policy.PolicyStats;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.DoubleFunction;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.LongFunction;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;

public record Metrics(Function<Object, String> objectFormatter, LongFunction<String> longFormatter, DoubleFunction<String> percentFormatter, DoubleFunction<String> doubleFormatter) {
    public Metrics {
        Objects.requireNonNull(longFormatter);
        Objects.requireNonNull(objectFormatter);
        Objects.requireNonNull(doubleFormatter);
        Objects.requireNonNull(percentFormatter);
    }

    public String format(PolicyStats.Metric metric) {
        if (metric == null) {
            return "";
        }
        Object object = metric.value();
        if (object instanceof LongSupplier) {
            LongSupplier supplier = (LongSupplier)object;
            long value = supplier.getAsLong();
            return value > 0L || metric.required() ? this.longFormatter().apply(value) : "";
        }
        Object value = metric.value();
        if (value instanceof DoubleSupplier) {
            DoubleSupplier supplier = (DoubleSupplier)value;
            double value2 = supplier.getAsDouble();
            if (value2 == 0.0 && !metric.required()) {
                return "";
            }
            return metric.type() == PolicyStats.Metric.MetricType.PERCENT ? this.percentFormatter().apply(value2) : this.doubleFormatter().apply(value2);
        }
        value = metric.value();
        if (value instanceof Supplier) {
            Supplier supplier = (Supplier)value;
            value = supplier.get();
            return (String)MoreObjects.firstNonNull((Object)this.objectFormatter().apply(value), (Object)"");
        }
        return (String)MoreObjects.firstNonNull((Object)this.objectFormatter().apply(metric.value()), (Object)"");
    }

    public Comparator<PolicyStats> comparator(String header) {
        return new MetricComparator(this, header);
    }

    public static Builder builder() {
        return new Builder().percentFormatter(value -> value == 0.0 ? "" : Double.toString(100.0 * value)).doubleFormatter(value -> value == 0.0 ? "" : Double.toString(value)).objectFormatter(object -> object == null ? "" : object.toString()).longFormatter(value -> value == 0L ? "" : Long.toString(value));
    }

    private record MetricComparator(Metrics metrics, String header) implements Comparator<PolicyStats>,
    Serializable
    {
        private MetricComparator {
            Objects.requireNonNull(metrics);
            Objects.requireNonNull(header);
        }

        @Override
        public int compare(PolicyStats p1, PolicyStats p2) {
            PolicyStats.Metric metric1 = p1.metrics().get(this.header);
            PolicyStats.Metric metric2 = p2.metrics().get(this.header);
            if (metric1 == null) {
                return metric2 == null ? 0 : -1;
            }
            if (metric2 == null) {
                return 1;
            }
            Object object = metric1.value();
            if (object instanceof LongSupplier) {
                LongSupplier supplier1 = (LongSupplier)object;
                object = metric2.value();
                if (object instanceof LongSupplier) {
                    LongSupplier supplier2 = (LongSupplier)object;
                    return Long.compare(supplier1.getAsLong(), supplier2.getAsLong());
                }
            }
            if ((object = metric1.value()) instanceof DoubleSupplier) {
                DoubleSupplier supplier1 = (DoubleSupplier)object;
                object = metric2.value();
                if (object instanceof DoubleSupplier) {
                    DoubleSupplier supplier2 = (DoubleSupplier)object;
                    return Double.compare(supplier1.getAsDouble(), supplier2.getAsDouble());
                }
            }
            if ((object = metric1.value()) instanceof Supplier) {
                Supplier supplier1 = (Supplier)object;
                object = metric2.value();
                if (object instanceof Supplier) {
                    Supplier supplier2 = (Supplier)object;
                    Object value1 = supplier1.get();
                    Object value2 = supplier2.get();
                    if (value1 instanceof Comparable) {
                        Comparable comparable = (Comparable)value1;
                        return comparable.compareTo(value2);
                    }
                    return this.metrics.objectFormatter.apply(value1).compareTo(this.metrics.objectFormatter.apply(value2));
                }
            }
            return this.metrics.objectFormatter.apply(metric1.value()).compareTo(this.metrics.objectFormatter.apply(metric2.value()));
        }
    }

    public static final class Builder {
        private @Nullable Function<Object, String> objectFormatter;
        private @Nullable DoubleFunction<String> percentFormatter;
        private @Nullable DoubleFunction<String> doubleFormatter;
        private @Nullable LongFunction<String> longFormatter;

        @CanIgnoreReturnValue
        public Builder objectFormatter(Function<Object, String> objectFormatter) {
            this.objectFormatter = Objects.requireNonNull(objectFormatter);
            Objects.requireNonNull(objectFormatter);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder percentFormatter(DoubleFunction<String> percentFormatter) {
            this.percentFormatter = Objects.requireNonNull(percentFormatter);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder doubleFormatter(DoubleFunction<String> doubleFormatter) {
            this.doubleFormatter = Objects.requireNonNull(doubleFormatter);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder longFormatter(LongFunction<String> longFormatter) {
            this.longFormatter = Objects.requireNonNull(longFormatter);
            return this;
        }

        public Metrics build() {
            Objects.requireNonNull(this.longFormatter);
            Objects.requireNonNull(this.objectFormatter);
            Objects.requireNonNull(this.doubleFormatter);
            Objects.requireNonNull(this.percentFormatter);
            return new Metrics(this.objectFormatter, this.longFormatter, this.percentFormatter, this.doubleFormatter);
        }
    }
}

