/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator;

import com.github.benmanes.caffeine.cache.simulator.admission.Admission;
import com.github.benmanes.caffeine.cache.simulator.membership.FilterType;
import com.github.benmanes.caffeine.cache.simulator.parser.TraceFormat;
import com.github.benmanes.caffeine.cache.simulator.report.ReportFormat;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;

public class BasicSettings {
    private static final Pattern NUMERIC_SEPARATOR = Pattern.compile("[_,]");
    private final Config config;

    public BasicSettings(Config config) {
        this.config = Objects.requireNonNull(config);
    }

    public ActorSettings actor() {
        return new ActorSettings();
    }

    public ReportSettings report() {
        return new ReportSettings();
    }

    public int randomSeed() {
        return this.getFormattedInt("random-seed");
    }

    public Set<String> policies() {
        return (Set)this.config().getStringList("policies").stream().map(policy -> policy.toLowerCase(Locale.US)).collect(ImmutableSet.toImmutableSet());
    }

    public Set<Admission> admission() {
        return (Set)this.config().getStringList("admission").stream().map(policy -> policy.toUpperCase(Locale.US)).map(Admission::valueOf).collect(Sets.toImmutableEnumSet());
    }

    public MembershipSettings membership() {
        return new MembershipSettings();
    }

    public TinyLfuSettings tinyLfu() {
        return new TinyLfuSettings();
    }

    public long maximumSize() {
        return this.getFormattedLong("maximum-size");
    }

    public TraceSettings trace() {
        return new TraceSettings();
    }

    public Config config() {
        return this.config;
    }

    protected int getFormattedInt(String path) {
        Function<String, @Nullable Integer> tryParse = Ints::tryParse;
        return this.parseFormattedNumber(path, arg_0 -> ((Config)this.config()).getInt(arg_0), tryParse);
    }

    protected long getFormattedLong(String path) {
        Function<String, @Nullable Long> tryParse = Longs::tryParse;
        return this.parseFormattedNumber(path, arg_0 -> ((Config)this.config()).getLong(arg_0), tryParse);
    }

    private <T extends Number> T parseFormattedNumber(String path, Function<String, T> getter, Function<String, @Nullable T> tryParse) {
        try {
            return (T)((Number)getter.apply(path));
        }
        catch (ConfigException.Parse | ConfigException.WrongType e) {
            Matcher matcher = NUMERIC_SEPARATOR.matcher(this.config().getString(path));
            Number value = (Number)tryParse.apply(matcher.replaceAll(""));
            if (value == null) {
                throw e;
            }
            return (T)value;
        }
    }

    public final class ActorSettings {
        public int mailboxSize() {
            return BasicSettings.this.config().getInt("actor.mailbox-size");
        }

        public int batchSize() {
            return BasicSettings.this.config().getInt("actor.batch-size");
        }
    }

    public final class ReportSettings {
        public ReportFormat format() {
            return ReportFormat.valueOf(BasicSettings.this.config().getString("report.format").toUpperCase(Locale.US));
        }

        public String sortBy() {
            return BasicSettings.this.config().getString("report.sort-by").trim();
        }

        public boolean ascending() {
            return BasicSettings.this.config().getBoolean("report.ascending");
        }

        public String output() {
            return BasicSettings.this.config().getString("report.output").trim();
        }
    }

    public final class MembershipSettings {
        public FilterType filter() {
            String type = BasicSettings.this.config().getString("membership.filter");
            return FilterType.valueOf(CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, type));
        }

        public long expectedInsertions() {
            double multiplier = BasicSettings.this.config().getDouble("membership.expected-insertions-multiplier");
            return (long)((double)BasicSettings.this.maximumSize() * multiplier);
        }

        public double fpp() {
            return BasicSettings.this.config().getDouble("membership.fpp");
        }
    }

    public final class TinyLfuSettings {
        public String sketch() {
            return BasicSettings.this.config().getString("tiny-lfu.sketch");
        }

        public boolean conservative() {
            return BasicSettings.this.config().getBoolean("tiny-lfu.count-min.conservative");
        }

        public JitterSettings jitter() {
            return new JitterSettings();
        }

        public CountMin4Settings countMin4() {
            return new CountMin4Settings();
        }

        public CountMin64Settings countMin64() {
            return new CountMin64Settings();
        }

        public final class JitterSettings {
            public boolean enabled() {
                return BasicSettings.this.config().getBoolean("tiny-lfu.jitter.enabled");
            }

            public int threshold() {
                return BasicSettings.this.config().getInt("tiny-lfu.jitter.threshold");
            }

            public double probability() {
                return BasicSettings.this.config().getDouble("tiny-lfu.jitter.probability");
            }
        }

        public final class CountMin4Settings {
            public String reset() {
                return BasicSettings.this.config().getString("tiny-lfu.count-min-4.reset");
            }

            public double countersMultiplier() {
                return BasicSettings.this.config().getDouble("tiny-lfu.count-min-4.counters-multiplier");
            }

            public IncrementalSettings incremental() {
                return new IncrementalSettings();
            }

            public PeriodicSettings periodic() {
                return new PeriodicSettings();
            }

            public final class IncrementalSettings {
                public int interval() {
                    return BasicSettings.this.config().getInt("tiny-lfu.count-min-4.incremental.interval");
                }
            }

            public final class PeriodicSettings {
                public DoorkeeperSettings doorkeeper() {
                    return new DoorkeeperSettings();
                }
            }
        }

        public final class CountMin64Settings {
            public double eps() {
                return BasicSettings.this.config().getDouble("tiny-lfu.count-min-64.eps");
            }

            public double confidence() {
                return BasicSettings.this.config().getDouble("tiny-lfu.count-min-64.confidence");
            }
        }

        public final class DoorkeeperSettings {
            public boolean enabled() {
                return BasicSettings.this.config().getBoolean("tiny-lfu.count-min-4.periodic.doorkeeper.enabled");
            }
        }
    }

    public final class TraceSettings {
        public long skip() {
            return BasicSettings.this.getFormattedLong("trace.skip");
        }

        public long limit() {
            return BasicSettings.this.config().getIsNull("trace.limit") ? Long.MAX_VALUE : BasicSettings.this.getFormattedLong("trace.limit");
        }

        public boolean isFiles() {
            return BasicSettings.this.config().getString("trace.source").equals("files");
        }

        public boolean isSynthetic() {
            return BasicSettings.this.config().getString("trace.source").equals("synthetic");
        }

        public TraceFilesSettings traceFiles() {
            Preconditions.checkState((boolean)this.isFiles());
            return new TraceFilesSettings();
        }

        public SyntheticSettings synthetic() {
            Preconditions.checkState((boolean)this.isSynthetic());
            return new SyntheticSettings();
        }
    }

    public final class SyntheticSettings {
        public String distribution() {
            return BasicSettings.this.config().getString("synthetic.distribution");
        }

        public int events() {
            return BasicSettings.this.config().getInt("synthetic.events");
        }

        public CounterSettings counter() {
            return new CounterSettings();
        }

        public RepeatSettings repeating() {
            return new RepeatSettings();
        }

        public UniformSettings uniform() {
            return new UniformSettings();
        }

        public ExponentialSettings exponential() {
            return new ExponentialSettings();
        }

        public HotspotSettings hotspot() {
            return new HotspotSettings();
        }

        public ZipfianSettings zipfian() {
            return new ZipfianSettings();
        }

        public final class CounterSettings {
            public int start() {
                return BasicSettings.this.config().getInt("synthetic.counter.start");
            }
        }

        public final class RepeatSettings {
            public int items() {
                return BasicSettings.this.config().getInt("synthetic.repeating.items");
            }
        }

        public final class UniformSettings {
            public int lowerBound() {
                return BasicSettings.this.config().getInt("synthetic.uniform.lower-bound");
            }

            public int upperBound() {
                return BasicSettings.this.config().getInt("synthetic.uniform.upper-bound");
            }
        }

        public final class ExponentialSettings {
            public double mean() {
                return BasicSettings.this.config().getDouble("synthetic.exponential.mean");
            }
        }

        public final class HotspotSettings {
            public int lowerBound() {
                return BasicSettings.this.config().getInt("synthetic.hotspot.lower-bound");
            }

            public int upperBound() {
                return BasicSettings.this.config().getInt("synthetic.hotspot.upper-bound");
            }

            public double hotsetFraction() {
                return BasicSettings.this.config().getDouble("synthetic.hotspot.hotset-fraction");
            }

            public double hotOpnFraction() {
                return BasicSettings.this.config().getDouble("synthetic.hotspot.hot-opn-fraction");
            }
        }

        public final class ZipfianSettings {
            public int items() {
                return BasicSettings.this.config().getInt("synthetic.zipfian.items");
            }

            public double constant() {
                return BasicSettings.this.config().getDouble("synthetic.zipfian.constant");
            }
        }
    }

    public final class TraceFilesSettings {
        public List<String> paths() {
            return BasicSettings.this.config().getStringList("files.paths");
        }

        public TraceFormat format() {
            return TraceFormat.named(BasicSettings.this.config().getString("files.format"));
        }
    }
}

