/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.AutoValue_Registry_Factory;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.adaptive.ArcPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.adaptive.CarPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.adaptive.CartPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.irr.ClockProPlusPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.irr.ClockProPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.irr.DClockPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.irr.FrdPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.irr.HillClimberFrdPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.irr.IndicatorFrdPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.irr.LirsPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.linked.FrequentlyUsedPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.linked.LinkedPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.linked.MultiQueuePolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.linked.S4LruPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.linked.SegmentedLruPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.opt.ClairvoyantPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.opt.UnboundedPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.Cache2kPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.CaffeinePolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.Ehcache3Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.ElasticSearchPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.ExpiringMapPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.GuavaPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.OhcPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.TCachePolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sampled.SampledPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.WindowTinyLfuPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.HillClimberWindowTinyLfuPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.feedback.FeedbackTinyLfuPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.feedback.FeedbackWindowTinyLfuPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.segment.FullySegmentedWindowTinyLfuPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.segment.LruWindowTinyLfuPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.segment.RandomWindowTinyLfuPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.segment.S4WindowTinyLfuPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.tinycache.TinyCachePolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.tinycache.TinyCacheWithGhostCachePolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.tinycache.WindowTinyCachePolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.two_queue.TuQueuePolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.two_queue.TwoQueuePolicy;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.typesafe.config.Config;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public final class Registry {
    private final Set<Policy.Characteristic> characteristics;
    private final Map<String, Factory> factories;
    private final BasicSettings settings;

    public Registry(BasicSettings settings, Set<Policy.Characteristic> characteristics) {
        this.characteristics = characteristics;
        this.factories = new HashMap<String, Factory>();
        this.settings = settings;
        this.buildRegistry();
    }

    public Set<Policy> policies() {
        return this.settings.policies().stream().map(name -> this.factories.get(name.toLowerCase(Locale.US))).filter(factory -> factory.characteristics().containsAll(this.characteristics)).flatMap(factory -> factory.creator().apply(this.settings.config()).stream()).collect(Collectors.toSet());
    }

    public Set<Policy> policy(String name) {
        Factory factory = this.factories.get(name.toLowerCase(Locale.US));
        Preconditions.checkNotNull((Object)factory, (String)"%s not found", (Object)name);
        return factory.creator().apply(this.settings.config());
    }

    private void buildRegistry() {
        this.registerIrr();
        this.registerLinked();
        this.registerSketch();
        this.registerOptimal();
        this.registerSampled();
        this.registerProduct();
        this.registerTwoQueue();
        this.registerAdaptive();
    }

    private void register(Class<? extends Policy> policyClass, Function<Config, Policy> creator) {
        this.registerMany(policyClass, config -> ImmutableSet.of((Object)((Policy)creator.apply((Config)config))));
    }

    private void register(Class<? extends Policy> policyClass, BiFunction<Config, Set<Policy.Characteristic>, Policy> creator) {
        this.registerMany(policyClass, config -> ImmutableSet.of((Object)((Policy)creator.apply((Config)config, this.characteristics))));
    }

    private void registerMany(Class<? extends Policy> policyClass, Function<Config, Set<Policy>> creator) {
        Policy.PolicySpec policySpec = policyClass.getAnnotation(Policy.PolicySpec.class);
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)policySpec.name()), (String)"The name must be specified on %s", policyClass);
        this.registerMany(policySpec.name(), policyClass, creator);
    }

    private void registerMany(String name, Class<? extends Policy> policyClass, Function<Config, Set<Policy>> creator) {
        this.factories.put(name.trim().toLowerCase(Locale.US), Factory.of(policyClass, creator));
    }

    private void registerOptimal() {
        this.register(ClairvoyantPolicy.class, ClairvoyantPolicy::new);
        this.register(UnboundedPolicy.class, (Config config) -> new UnboundedPolicy((Config)config, this.characteristics));
    }

    private void registerLinked() {
        Stream.of(LinkedPolicy.EvictionPolicy.values()).forEach(priority -> this.registerMany(priority.label(), LinkedPolicy.class, config -> LinkedPolicy.policies(config, this.characteristics, priority)));
        Stream.of(FrequentlyUsedPolicy.EvictionPolicy.values()).forEach(priority -> this.registerMany(priority.label(), FrequentlyUsedPolicy.class, config -> FrequentlyUsedPolicy.policies(config, priority)));
        this.registerMany(S4LruPolicy.class, S4LruPolicy::policies);
        this.register(MultiQueuePolicy.class, MultiQueuePolicy::new);
        this.registerMany(SegmentedLruPolicy.class, SegmentedLruPolicy::policies);
    }

    private void registerSampled() {
        Stream.of(SampledPolicy.EvictionPolicy.values()).forEach(priority -> this.registerMany(priority.label(), SampledPolicy.class, config -> SampledPolicy.policies(config, priority)));
    }

    private void registerTwoQueue() {
        this.register(TuQueuePolicy.class, TuQueuePolicy::new);
        this.register(TwoQueuePolicy.class, TwoQueuePolicy::new);
    }

    private void registerSketch() {
        this.registerMany(WindowTinyLfuPolicy.class, WindowTinyLfuPolicy::policies);
        this.registerMany(S4WindowTinyLfuPolicy.class, S4WindowTinyLfuPolicy::policies);
        this.registerMany(LruWindowTinyLfuPolicy.class, LruWindowTinyLfuPolicy::policies);
        this.registerMany(RandomWindowTinyLfuPolicy.class, RandomWindowTinyLfuPolicy::policies);
        this.registerMany(FullySegmentedWindowTinyLfuPolicy.class, FullySegmentedWindowTinyLfuPolicy::policies);
        this.register(FeedbackTinyLfuPolicy.class, FeedbackTinyLfuPolicy::new);
        this.registerMany(FeedbackWindowTinyLfuPolicy.class, FeedbackWindowTinyLfuPolicy::policies);
        this.registerMany(HillClimberWindowTinyLfuPolicy.class, HillClimberWindowTinyLfuPolicy::policies);
        this.register(TinyCachePolicy.class, TinyCachePolicy::new);
        this.register(WindowTinyCachePolicy.class, WindowTinyCachePolicy::new);
        this.register(TinyCacheWithGhostCachePolicy.class, TinyCacheWithGhostCachePolicy::new);
    }

    private void registerIrr() {
        this.register(FrdPolicy.class, FrdPolicy::new);
        this.register(IndicatorFrdPolicy.class, IndicatorFrdPolicy::new);
        this.register(HillClimberFrdPolicy.class, HillClimberFrdPolicy::new);
        this.register(LirsPolicy.class, LirsPolicy::new);
        this.register(ClockProPolicy.class, ClockProPolicy::new);
        this.register(ClockProPlusPolicy.class, ClockProPlusPolicy::new);
        this.registerMany(DClockPolicy.class, DClockPolicy::policies);
    }

    private void registerAdaptive() {
        this.register(ArcPolicy.class, ArcPolicy::new);
        this.register(CarPolicy.class, CarPolicy::new);
        this.register(CartPolicy.class, CartPolicy::new);
    }

    private void registerProduct() {
        this.register(GuavaPolicy.class, GuavaPolicy::new);
        this.register(TCachePolicy.class, TCachePolicy::new);
        this.register(Cache2kPolicy.class, Cache2kPolicy::new);
        this.registerMany(OhcPolicy.class, OhcPolicy::policies);
        this.register(CaffeinePolicy.class, CaffeinePolicy::new);
        this.register(Ehcache3Policy.class, Ehcache3Policy::new);
        this.register(ExpiringMapPolicy.class, ExpiringMapPolicy::new);
        this.register(ElasticSearchPolicy.class, ElasticSearchPolicy::new);
    }

    @AutoValue
    static abstract class Factory {
        Factory() {
        }

        abstract Class<? extends Policy> policyClass();

        abstract Function<Config, Set<Policy>> creator();

        Set<Policy.Characteristic> characteristics() {
            Policy.PolicySpec policySpec = this.policyClass().getAnnotation(Policy.PolicySpec.class);
            return policySpec == null ? ImmutableSet.of() : ImmutableSet.copyOf((Object[])policySpec.characteristics());
        }

        static Factory of(Class<? extends Policy> policyClass, Function<Config, Set<Policy>> creator) {
            return new AutoValue_Registry_Factory(policyClass, creator);
        }
    }
}

