/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.parser.snia.parallel;

import com.github.benmanes.caffeine.cache.simulator.parser.TextTraceReader;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.util.Set;
import java.util.stream.Stream;

public final class TencentPhotoTraceReader
extends TextTraceReader {
    private static final String JPEG_FORMAT = "0";
    private static final String WEBP_FORMAT = "5";

    public TencentPhotoTraceReader(String filePath) {
        super(filePath);
    }

    @Override
    public Set<Policy.Characteristic> characteristics() {
        return Sets.immutableEnumSet((Enum)Policy.Characteristic.WEIGHTED, (Enum[])new Policy.Characteristic[0]);
    }

    @Override
    public Stream<AccessEvent> events() throws IOException {
        return this.lines().map(line -> line.split(" ")).filter(array -> array[2].equals(JPEG_FORMAT) || array[2].equals(WEBP_FORMAT)).map(array -> {
            long key = Hashing.murmur3_128().hashBytes(BaseEncoding.base16().lowerCase().decode((CharSequence)array[1])).asLong();
            return AccessEvent.forKeyAndWeight(key, Integer.parseInt(array[4]));
        });
    }
}

