/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.gradient;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.AbstractClimber;
import com.typesafe.config.Config;
import java.util.List;
import java.util.Locale;

public final class Stochastic
extends AbstractClimber {
    private final Acceleration acceleration;
    private final int stepSize;
    private final double beta;
    private double velocity;

    public Stochastic(Config config) {
        StochasticSettings settings = new StochasticSettings(config);
        this.sampleSize = (int)(settings.percentSample() * (double)settings.maximumSize());
        this.stepSize = (int)(settings.percentPivot() * (double)settings.maximumSize());
        this.acceleration = settings.acceleration();
        this.beta = settings.beta();
    }

    @Override
    protected double adjust(double hitRate) {
        double currentMissRate = 1.0 - hitRate;
        double previousMissRate = 1.0 - this.previousHitRate;
        double gradient = currentMissRate - previousMissRate;
        switch (this.acceleration) {
            case NONE: {
                return (double)this.stepSize * gradient;
            }
            case MOMENTUM: {
                this.velocity = this.beta * this.velocity + (1.0 - this.beta) * gradient;
                return (double)this.stepSize * this.velocity;
            }
            case NESTEROV: {
                double previousVelocity = this.velocity;
                this.velocity = this.beta * this.velocity + (double)this.stepSize * gradient;
                return -(this.beta * previousVelocity) + (1.0 + this.beta) * this.velocity;
            }
        }
        throw new IllegalStateException("Unknown acceleration type: " + (Object)((Object)this.acceleration));
    }

    static final class StochasticSettings
    extends BasicSettings {
        static final String BASE_PATH = "hill-climber-window-tiny-lfu.stochastic-gradient-descent.";

        public StochasticSettings(Config config) {
            super(config);
        }

        public List<Double> percentMain() {
            return this.config().getDoubleList("hill-climber-window-tiny-lfu.percent-main");
        }

        public double percentPivot() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.stochastic-gradient-descent.percent-pivot");
        }

        public double percentSample() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.stochastic-gradient-descent.percent-sample");
        }

        public Acceleration acceleration() {
            return Acceleration.valueOf(this.config().getString("hill-climber-window-tiny-lfu.stochastic-gradient-descent.acceleration").toUpperCase(Locale.US));
        }

        public double beta() {
            return this.config().getDouble("hill-climber-window-tiny-lfu.stochastic-gradient-descent.beta");
        }
    }

    static enum Acceleration {
        NONE,
        MOMENTUM,
        NESTEROV;

    }
}

