/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.adaptive.ArcPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.adaptive.CarPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.adaptive.CartPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.irr.ClockProPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.irr.FrdPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.irr.HillClimberFrdPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.irr.IndicatorFrdPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.irr.LirsPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.linked.FrequentlyUsedPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.linked.LinkedPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.linked.MultiQueuePolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.linked.S4LruPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.linked.SegmentedLruPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.opt.ClairvoyantPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.opt.UnboundedPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.Cache2kPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.CaffeinePolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.CollisionPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.Ehcache3Policy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.ElasticSearchPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.ExpiringMapPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.GuavaPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.OhcPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.product.TCachePolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sampled.SampledPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.WindowTinyLfuPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.climbing.HillClimberWindowTinyLfuPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.feedback.FeedbackTinyLfuPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.feedback.FeedbackWindowTinyLfuPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.segment.FullySegmentedWindowTinyLfuPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.segment.LruWindowTinyLfuPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.segment.RandomWindowTinyLfuPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.segment.S4WindowTinyLfuPolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.tinycache.TinyCachePolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.tinycache.TinyCacheWithGhostCachePolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.sketch.tinycache.WindowTinyCachePolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.two_queue.TuQueuePolicy;
import com.github.benmanes.caffeine.cache.simulator.policy.two_queue.TwoQueuePolicy;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Registry {
    private final Set<Policy.Characteristic> characteristics;
    private final Map<String, Factory> factories;
    private final BasicSettings settings;

    public Registry(BasicSettings settings, Set<Policy.Characteristic> characteristics) {
        this.characteristics = characteristics;
        this.factories = new HashMap<String, Factory>();
        this.settings = settings;
        this.buildRegistry();
    }

    public Set<Policy> policies() {
        return this.settings.policies().stream().flatMap(name -> this.policy((String)name).stream()).filter(policy -> policy.characteristics().containsAll(this.characteristics)).collect(Collectors.toSet());
    }

    public Set<Policy> policy(String name) {
        Factory factory = this.factories.get(name.toLowerCase(Locale.US));
        Preconditions.checkNotNull((Object)factory, (String)"%s not found", (Object)name);
        return (Set)factory.apply(this.settings.config());
    }

    private void buildRegistry() {
        this.registerIrr();
        this.registerLinked();
        this.registerSketch();
        this.registerOptimal();
        this.registerSampled();
        this.registerProduct();
        this.registerTwoQueue();
        this.registerAdaptive();
        Map<String, Factory> normalized = this.factories.entrySet().stream().collect(Collectors.toMap(entry -> ((String)entry.getKey()).toLowerCase(Locale.US), Map.Entry::getValue));
        this.factories.clear();
        this.factories.putAll(normalized);
    }

    private void registerOptimal() {
        this.factories.put("opt.Clairvoyant", ClairvoyantPolicy::policies);
        this.factories.put("opt.Unbounded", UnboundedPolicy::policies);
    }

    private void registerLinked() {
        Stream.of(LinkedPolicy.EvictionPolicy.values()).forEach(priority -> {
            String id = "linked." + priority.name();
            this.factories.put(id, config -> LinkedPolicy.policies(config, priority));
        });
        Stream.of(FrequentlyUsedPolicy.EvictionPolicy.values()).forEach(priority -> {
            String id = "linked." + priority.name();
            this.factories.put(id, config -> FrequentlyUsedPolicy.policies(config, priority));
        });
        this.factories.put("linked.SegmentedLru", SegmentedLruPolicy::policies);
        this.factories.put("linked.Multiqueue", MultiQueuePolicy::policies);
        this.factories.put("linked.S4Lru", S4LruPolicy::policies);
    }

    private void registerSampled() {
        Stream.of(SampledPolicy.EvictionPolicy.values()).forEach(priority -> {
            String id = "sampled." + priority.name();
            this.factories.put(id, config -> SampledPolicy.policies(config, priority));
        });
    }

    private void registerTwoQueue() {
        this.factories.put("two-queue.TuQueue", TuQueuePolicy::policies);
        this.factories.put("two-queue.TwoQueue", TwoQueuePolicy::policies);
    }

    private void registerSketch() {
        this.factories.put("sketch.WindowTinyLfu", WindowTinyLfuPolicy::policies);
        this.factories.put("sketch.S4WindowTinyLfu", S4WindowTinyLfuPolicy::policies);
        this.factories.put("sketch.LruWindowTinyLfu", LruWindowTinyLfuPolicy::policies);
        this.factories.put("sketch.RandomWindowtinyLfu", RandomWindowTinyLfuPolicy::policies);
        this.factories.put("sketch.FullySegmentedWindowTinylfu", FullySegmentedWindowTinyLfuPolicy::policies);
        this.factories.put("sketch.FeedbackTinyLfu", FeedbackTinyLfuPolicy::policies);
        this.factories.put("sketch.FeedbackWindowTinyLfu", FeedbackWindowTinyLfuPolicy::policies);
        this.factories.put("sketch.HillClimberWindowTinyLfu", HillClimberWindowTinyLfuPolicy::policies);
        this.factories.put("sketch.TinyCache", TinyCachePolicy::policies);
        this.factories.put("sketch.WindowTinyCache", WindowTinyCachePolicy::policies);
        this.factories.put("sketch.TinyCache_GhostCache", TinyCacheWithGhostCachePolicy::policies);
    }

    private void registerIrr() {
        this.factories.put("irr.Frd", FrdPolicy::policies);
        this.factories.put("irr.IndicatorFrd", IndicatorFrdPolicy::policies);
        this.factories.put("irr.ClimberFrd", HillClimberFrdPolicy::policies);
        this.factories.put("irr.Lirs", LirsPolicy::policies);
        this.factories.put("irr.ClockPro", ClockProPolicy::policies);
    }

    private void registerAdaptive() {
        this.factories.put("adaptive.Arc", ArcPolicy::policies);
        this.factories.put("adaptive.Car", CarPolicy::policies);
        this.factories.put("adaptive.Cart", CartPolicy::policies);
    }

    private void registerProduct() {
        this.factories.put("product.OHC", OhcPolicy::policies);
        this.factories.put("product.Guava", GuavaPolicy::policies);
        this.factories.put("product.Tcache", TCachePolicy::policies);
        this.factories.put("product.Cache2k", Cache2kPolicy::policies);
        this.factories.put("product.Ehcache3", Ehcache3Policy::policies);
        this.factories.put("product.Collision", CollisionPolicy::policies);
        this.factories.put("product.ExpiringMap", ExpiringMapPolicy::policies);
        this.factories.put("product.Elasticsearch", ElasticSearchPolicy::policies);
        this.factories.put("product.Caffeine", config -> CaffeinePolicy.policies(config, this.characteristics));
    }

    private static interface Factory
    extends Function<Config, Set<Policy>> {
    }
}

