/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.policy;

import akka.actor.AbstractActor;
import akka.dispatch.BoundedMessageQueueSemantics;
import akka.dispatch.RequiresMessageQueue;
import com.github.benmanes.caffeine.cache.simulator.Simulator;
import com.github.benmanes.caffeine.cache.simulator.policy.AccessEvent;
import com.github.benmanes.caffeine.cache.simulator.policy.Policy;
import java.util.List;
import java.util.Objects;

public final class PolicyActor
extends AbstractActor
implements RequiresMessageQueue<BoundedMessageQueueSemantics> {
    private final Policy policy;

    public PolicyActor(Policy policy) {
        this.policy = Objects.requireNonNull(policy);
    }

    public AbstractActor.Receive createReceive() {
        return this.receiveBuilder().matchEquals((Object)Simulator.Message.FINISH, msg -> this.finish()).matchUnchecked(List.class, () -> true, this::process).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process(List<AccessEvent> events) {
        try {
            this.policy.stats().stopwatch().start();
            for (AccessEvent event : events) {
                long priorHits = this.policy.stats().hitCount();
                long priorMisses = this.policy.stats().missCount();
                this.policy.record(event);
                if (this.policy.stats().hitCount() > priorHits) {
                    this.policy.stats().recordHitPenalty(event.hitPenalty());
                    continue;
                }
                if (this.policy.stats().missCount() <= priorMisses) continue;
                this.policy.stats().recordMissPenalty(event.missPenalty());
            }
        }
        catch (Exception e) {
            this.sender().tell((Object)Simulator.Message.ERROR, this.self());
            this.context().system().log().error((Throwable)e, "");
        }
        finally {
            this.policy.stats().stopwatch().stop();
        }
    }

    private void finish() {
        try {
            this.policy.finished();
            this.sender().tell((Object)this.policy.stats(), this.self());
        }
        catch (Exception e) {
            this.sender().tell((Object)Simulator.Message.ERROR, this.self());
            this.context().system().log().error((Throwable)e, "");
        }
    }
}

