/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.parser;

import com.github.benmanes.caffeine.cache.simulator.parser.TraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.address.AddressTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.arc.ArcTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.cache2k.Cache2kTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.corda.CordaTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.gradle.GradleTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.lirs.LirsTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.scarab.ScarabTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.snia.cambridge.CambridgeTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.umass.network.YoutubeTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.umass.storage.StorageTraceReader;
import com.github.benmanes.caffeine.cache.simulator.parser.wikipedia.WikipediaTraceReader;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.stream.LongStream;

public enum TraceFormat {
    ADDRESS(AddressTraceReader::new),
    ARC(ArcTraceReader::new),
    CACHE2K(Cache2kTraceReader::new),
    CORDA(CordaTraceReader::new),
    GRADLE(GradleTraceReader::new),
    LIRS(LirsTraceReader::new),
    SCARAB(ScarabTraceReader::new),
    SNIA_CAMBRIDGE(CambridgeTraceReader::new),
    UMASS_STORAGE(StorageTraceReader::new),
    UMASS_YOUTUBE(YoutubeTraceReader::new),
    WIKIPEDIA(WikipediaTraceReader::new);

    private final Function<String, TraceReader> factory;

    private TraceFormat(Function<String, TraceReader> factory) {
        this.factory = factory;
    }

    public TraceReader readFiles(List<String> filePaths) {
        return () -> {
            LongStream events = LongStream.empty();
            for (String path : filePaths) {
                List parts = Splitter.on((char)':').limit(2).splitToList((CharSequence)path);
                TraceFormat format = parts.size() == 1 ? this : TraceFormat.named((String)parts.get(0));
                LongStream next = format.factory.apply((String)Iterables.getLast((Iterable)parts)).events();
                events = LongStream.concat(events, next);
            }
            return events;
        };
    }

    public static TraceFormat named(String name) {
        return TraceFormat.valueOf(name.replace('-', '_').toUpperCase(Locale.US));
    }
}

