/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache.simulator.admission.countmin4;

import com.github.benmanes.caffeine.cache.simulator.BasicSettings;
import com.github.benmanes.caffeine.cache.simulator.admission.countmin4.CountMin4;
import com.typesafe.config.Config;

public final class IncrementalResetCountMin4
extends CountMin4 {
    final int interval;
    int additions;
    int cursor;

    public IncrementalResetCountMin4(Config config) {
        super(config);
        this.cursor = this.randomSeed;
        BasicSettings settings = new BasicSettings(config);
        this.interval = settings.tinyLfu().countMin4().incremental().interval();
    }

    @Override
    protected void tryReset(boolean added) {
        if (!added) {
            return;
        }
        ++this.additions;
        if (this.additions != this.interval) {
            return;
        }
        int i = this.cursor & this.tableMask;
        this.table[i] = this.table[i] >>> 1 & 0x7777777777777777L;
        ++this.cursor;
        this.additions = 0;
    }
}

