/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache.expiry;

import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;

public final class JCacheExpiryPolicy
implements ExpiryPolicy,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Duration creation;
    private final Duration update;
    private final Duration access;

    public JCacheExpiryPolicy(@Nonnull Duration creation, @Nullable Duration update, @Nullable Duration access) {
        this.creation = Objects.requireNonNull(creation);
        this.update = update;
        this.access = access;
    }

    public Duration getExpiryForCreation() {
        return this.creation;
    }

    public Duration getExpiryForUpdate() {
        return this.update;
    }

    public Duration getExpiryForAccess() {
        return this.access;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExpiryPolicy)) {
            return false;
        }
        ExpiryPolicy policy = (ExpiryPolicy)o;
        return Objects.equals(this.creation, policy.getExpiryForCreation()) && Objects.equals(this.update, policy.getExpiryForUpdate()) && Objects.equals(this.access, policy.getExpiryForAccess());
    }

    public int hashCode() {
        return Objects.hash(this.creation, this.update, this.access);
    }
}

