/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache.event;

import com.github.benmanes.caffeine.jcache.event.JCacheEntryEvent;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;
import javax.cache.event.EventType;

final class EventTypeAwareListener<K, V>
implements CacheEntryCreatedListener<K, V>,
CacheEntryUpdatedListener<K, V>,
CacheEntryRemovedListener<K, V>,
CacheEntryExpiredListener<K, V> {
    static final Logger logger = Logger.getLogger(EventTypeAwareListener.class.getName());
    final CacheEntryListener<? super K, ? super V> listener;

    public EventTypeAwareListener(CacheEntryListener<? super K, ? super V> listener) {
        this.listener = Objects.requireNonNull(listener);
    }

    public boolean isCompatible(@Nonnull EventType eventType) {
        switch (eventType) {
            case CREATED: {
                return this.listener instanceof CacheEntryCreatedListener;
            }
            case UPDATED: {
                return this.listener instanceof CacheEntryUpdatedListener;
            }
            case REMOVED: {
                return this.listener instanceof CacheEntryRemovedListener;
            }
            case EXPIRED: {
                return this.listener instanceof CacheEntryExpiredListener;
            }
        }
        throw new IllegalStateException("Unknown event type: " + eventType);
    }

    public void dispatch(@Nonnull JCacheEntryEvent<K, V> event) {
        try {
            switch (event.getEventType()) {
                case CREATED: {
                    this.onCreated(event);
                    break;
                }
                case UPDATED: {
                    this.onUpdated(event);
                    break;
                }
                case REMOVED: {
                    this.onRemoved(event);
                    break;
                }
                case EXPIRED: {
                    this.onExpired(event);
                }
            }
            throw new IllegalStateException("Unknown event type: " + event.getEventType());
        }
        catch (Exception e) {
            logger.log(Level.WARNING, null, e);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, null, t);
        }
    }

    public void onCreated(Iterable<CacheEntryEvent<? extends K, ? extends V>> events) {
        if (this.listener instanceof CacheEntryCreatedListener) {
            ((CacheEntryCreatedListener)this.listener).onCreated(events);
        }
    }

    public void onUpdated(Iterable<CacheEntryEvent<? extends K, ? extends V>> events) {
        if (this.listener instanceof CacheEntryUpdatedListener) {
            ((CacheEntryUpdatedListener)this.listener).onUpdated(events);
        }
    }

    public void onRemoved(Iterable<CacheEntryEvent<? extends K, ? extends V>> events) {
        if (this.listener instanceof CacheEntryRemovedListener) {
            ((CacheEntryRemovedListener)this.listener).onRemoved(events);
        }
    }

    public void onExpired(Iterable<CacheEntryEvent<? extends K, ? extends V>> events) {
        if (this.listener instanceof CacheEntryExpiredListener) {
            ((CacheEntryExpiredListener)this.listener).onExpired(events);
        }
    }
}

