/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache;

import com.github.benmanes.caffeine.jcache.CacheFactory;
import com.github.benmanes.caffeine.jcache.CacheProxy;
import com.github.benmanes.caffeine.jcache.configuration.CaffeineConfiguration;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.spi.CachingProvider;

public final class CacheManagerImpl
implements CacheManager {
    private final WeakReference<ClassLoader> classLoaderReference;
    private final Map<String, CacheProxy<?, ?>> caches;
    private final CachingProvider cacheProvider;
    private final CacheFactory cacheFactory;
    private final Properties properties;
    private final URI uri;
    private volatile boolean closed;

    public CacheManagerImpl(CachingProvider cacheProvider, URI uri, ClassLoader classLoader, Properties properties) {
        this(cacheProvider, uri, classLoader, properties, ConfigFactory.load());
    }

    public CacheManagerImpl(CachingProvider cacheProvider, URI uri, ClassLoader classLoader, Properties properties, Config rootConfig) {
        this.classLoaderReference = new WeakReference<ClassLoader>(Objects.requireNonNull(classLoader));
        this.cacheFactory = new CacheFactory(this, rootConfig);
        this.cacheProvider = Objects.requireNonNull(cacheProvider);
        this.properties = Objects.requireNonNull(properties);
        this.caches = new ConcurrentHashMap();
        this.uri = Objects.requireNonNull(uri);
    }

    public CachingProvider getCachingProvider() {
        return this.cacheProvider;
    }

    public URI getURI() {
        return this.uri;
    }

    public ClassLoader getClassLoader() {
        return (ClassLoader)this.classLoaderReference.get();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public <K, V, C extends Configuration<K, V>> Cache<K, V> createCache(String cacheName, C configuration) throws IllegalArgumentException {
        this.requireNotClosed();
        Objects.requireNonNull(configuration);
        CacheProxy cache = this.caches.compute(cacheName, (name, existing) -> {
            if (existing != null && !existing.isClosed()) {
                throw new CacheException("Cache " + cacheName + " already exists");
            }
            return this.cacheFactory.createCache(cacheName, configuration);
        });
        this.enableManagement(cache.getName(), cache.getConfiguration().isManagementEnabled());
        this.enableStatistics(cache.getName(), cache.getConfiguration().isStatisticsEnabled());
        CacheProxy castedCache = cache;
        return castedCache;
    }

    public <K, V> Cache<K, V> getCache(String cacheName, Class<K> keyType, Class<V> valueType) {
        CacheProxy<K, V> cache = this.getOrCreateCache(cacheName);
        if (cache == null) {
            return null;
        }
        Objects.requireNonNull(keyType);
        Objects.requireNonNull(valueType);
        CaffeineConfiguration<K, V> config = cache.getConfiguration();
        if (keyType != config.getKeyType()) {
            throw new ClassCastException("Incompatible cache key types specified, expected " + config.getKeyType() + " but " + keyType + " was specified");
        }
        if (valueType != config.getValueType()) {
            throw new ClassCastException("Incompatible cache value types specified, expected " + config.getValueType() + " but " + valueType + " was specified");
        }
        return cache;
    }

    public <K, V> Cache<K, V> getCache(String cacheName) {
        CacheProxy<K, V> cache = this.getOrCreateCache(cacheName);
        if (cache == null) {
            return null;
        }
        CaffeineConfiguration<K, V> configuration = cache.getConfiguration();
        if (!Object.class.equals((Object)configuration.getKeyType()) || !Object.class.equals((Object)configuration.getValueType())) {
            String msg = String.format("Cache %s was defined with specific types Cache<%s, %s> in which case CacheManager.getCache(String, Class, Class) must be used", cacheName, configuration.getKeyType(), configuration.getValueType());
            throw new IllegalArgumentException(msg);
        }
        return cache;
    }

    @Nullable
    private <K, V> CacheProxy<K, V> getOrCreateCache(String cacheName) {
        CacheProxy cache;
        Objects.requireNonNull(cacheName);
        this.requireNotClosed();
        CacheProxy castedCache = cache = this.caches.computeIfAbsent(cacheName, name -> {
            CacheProxy created = this.cacheFactory.tryToCreateFromExternalSettings((String)name);
            if (created != null) {
                created.enableManagement(created.getConfiguration().isManagementEnabled());
                created.enableStatistics(created.getConfiguration().isStatisticsEnabled());
            }
            return created;
        });
        return castedCache;
    }

    public Iterable<String> getCacheNames() {
        return Collections.unmodifiableCollection(new ArrayList<String>(this.caches.keySet()));
    }

    public void destroyCache(String cacheName) {
        this.requireNotClosed();
        Cache cache = this.caches.remove(cacheName);
        if (cache != null) {
            cache.close();
        }
    }

    public void enableManagement(String cacheName, boolean enabled) {
        this.requireNotClosed();
        CacheProxy<?, ?> cache = this.caches.get(cacheName);
        if (cache == null) {
            return;
        }
        cache.enableManagement(enabled);
    }

    public void enableStatistics(String cacheName, boolean enabled) {
        this.requireNotClosed();
        CacheProxy<?, ?> cache = this.caches.get(cacheName);
        if (cache == null) {
            return;
        }
        cache.enableStatistics(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.isClosed()) {
            return;
        }
        CacheFactory cacheFactory = this.cacheFactory;
        synchronized (cacheFactory) {
            if (!this.isClosed()) {
                this.cacheProvider.close(this.uri, (ClassLoader)this.classLoaderReference.get());
                for (Cache cache : this.caches.values()) {
                    cache.close();
                }
                this.closed = true;
            }
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return clazz.cast(this);
        }
        throw new IllegalArgumentException("Unwapping to " + clazz + " is not a supported by this implementation");
    }

    private void requireNotClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException();
        }
    }
}

