/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.Ticker;
import com.github.benmanes.caffeine.cache.Weigher;
import com.github.benmanes.caffeine.jcache.CacheProxy;
import com.github.benmanes.caffeine.jcache.LoadingCacheProxy;
import com.github.benmanes.caffeine.jcache.configuration.CaffeineConfiguration;
import com.github.benmanes.caffeine.jcache.configuration.TypesafeConfigurator;
import com.github.benmanes.caffeine.jcache.event.EventDispatcher;
import com.github.benmanes.caffeine.jcache.event.JCacheEvictionListener;
import com.github.benmanes.caffeine.jcache.integration.JCacheLoaderAdapter;
import com.github.benmanes.caffeine.jcache.management.JCacheStatisticsMXBean;
import com.typesafe.config.Config;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.cache.CacheManager;
import javax.cache.configuration.CompleteConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;

final class CacheFactory {
    static final boolean USE_DIRECT_EXECUTOR = System.getProperties().containsKey("org.jsr107.tck.management.agentId");
    final Config rootConfig;
    final CacheManager cacheManager;

    public CacheFactory(CacheManager cacheManager, Config rootConfig) {
        this.cacheManager = Objects.requireNonNull(cacheManager);
        this.rootConfig = Objects.requireNonNull(rootConfig);
    }

    @Nullable
    public <K, V> CacheProxy<K, V> tryToCreateFromExternalSettings(String cacheName) {
        Optional configuration = TypesafeConfigurator.from(this.rootConfig, cacheName);
        return configuration.isPresent() ? this.createCache(cacheName, (Configuration)configuration.get()) : null;
    }

    public <K, V> CacheProxy<K, V> createCache(String cacheName, Configuration<K, V> configuration) {
        CaffeineConfiguration<K, V> config = this.resolveConfigurationFor(configuration);
        return new Builder<K, V>(cacheName, config).build();
    }

    private <K, V> CaffeineConfiguration<K, V> resolveConfigurationFor(Configuration<K, V> configuration) {
        if (configuration instanceof CaffeineConfiguration) {
            return new CaffeineConfiguration((CaffeineConfiguration)configuration);
        }
        CaffeineConfiguration defaults = TypesafeConfigurator.defaults(this.rootConfig);
        if (configuration instanceof CompleteConfiguration) {
            CaffeineConfiguration config = new CaffeineConfiguration((CompleteConfiguration)configuration);
            config.setCopierFactory(defaults.getCopierFactory());
            return config;
        }
        defaults.setTypes(configuration.getKeyType(), configuration.getValueType());
        defaults.setStoreByValue(configuration.isStoreByValue());
        return defaults;
    }

    private final class Builder<K, V> {
        final Ticker ticker;
        final String cacheName;
        final Executor executor;
        final ExpiryPolicy expiry;
        final EventDispatcher<K, V> dispatcher;
        final JCacheStatisticsMXBean statistics;
        final Caffeine<Object, Object> caffeine;
        final CaffeineConfiguration<K, V> config;
        CacheLoader<K, V> cacheLoader;
        JCacheEvictionListener<K, V> evictionListener;

        Builder(String cacheName, CaffeineConfiguration<K, V> config) {
            this.config = config;
            this.cacheName = cacheName;
            this.caffeine = Caffeine.newBuilder();
            this.statistics = new JCacheStatisticsMXBean();
            this.ticker = (Ticker)config.getTickerFactory().create();
            this.expiry = (ExpiryPolicy)config.getExpiryPolicyFactory().create();
            this.executor = USE_DIRECT_EXECUTOR ? Runnable::run : ForkJoinPool.commonPool();
            this.dispatcher = new EventDispatcher(this.executor);
            this.caffeine.executor(this.executor);
            if (config.getCacheLoaderFactory() != null) {
                this.cacheLoader = (CacheLoader)config.getCacheLoaderFactory().create();
            }
            config.getCacheEntryListenerConfigurations().forEach(this.dispatcher::register);
        }

        public CacheProxy<K, V> build() {
            CacheProxy<K, V> cache;
            boolean evicts;
            boolean bl = evicts = this.configureMaximumSize() || this.configureMaximumWeight() || this.configureExpireAfterWrite() || this.configureExpireAfterAccess() || this.configureExpireVariably();
            if (evicts) {
                this.configureEvictionListener();
            }
            if (this.isReadThrough()) {
                this.configureRefreshAfterWrite();
                cache = this.newLoadingCacheProxy();
            } else {
                cache = this.newCacheProxy();
            }
            if (evicts) {
                this.evictionListener.setCache(cache);
            }
            return cache;
        }

        private boolean isReadThrough() {
            return this.config.isReadThrough() && this.cacheLoader != null;
        }

        private CacheProxy<K, V> newCacheProxy() {
            return new CacheProxy<K, V>(this.cacheName, this.executor, CacheFactory.this.cacheManager, this.config, this.caffeine.build(), this.dispatcher, Optional.ofNullable(this.cacheLoader), this.expiry, this.ticker, this.statistics);
        }

        private CacheProxy<K, V> newLoadingCacheProxy() {
            JCacheLoaderAdapter<K, V> adapter = new JCacheLoaderAdapter<K, V>(this.cacheLoader, this.dispatcher, this.expiry, this.ticker, this.statistics);
            LoadingCacheProxy<K, V> cache = new LoadingCacheProxy<K, V>(this.cacheName, this.executor, CacheFactory.this.cacheManager, this.config, this.caffeine.build(adapter), this.dispatcher, this.cacheLoader, this.expiry, this.ticker, this.statistics);
            adapter.setCache(cache);
            return cache;
        }

        private boolean configureMaximumSize() {
            if (this.config.getMaximumSize().isPresent()) {
                this.caffeine.maximumSize(this.config.getMaximumSize().getAsLong());
            }
            return this.config.getMaximumSize().isPresent();
        }

        private boolean configureMaximumWeight() {
            if (this.config.getMaximumWeight().isPresent()) {
                this.caffeine.maximumWeight(this.config.getMaximumWeight().getAsLong());
                this.caffeine.weigher((Weigher)this.config.getWeigherFactory().create());
            }
            return this.config.getMaximumWeight().isPresent();
        }

        private boolean configureExpireAfterWrite() {
            if (this.config.getExpireAfterWrite().isPresent()) {
                this.caffeine.expireAfterWrite(this.config.getExpireAfterWrite().getAsLong(), TimeUnit.NANOSECONDS);
            }
            return this.config.getExpireAfterWrite().isPresent();
        }

        private boolean configureExpireAfterAccess() {
            if (this.config.getExpireAfterAccess().isPresent()) {
                this.caffeine.expireAfterAccess(this.config.getExpireAfterAccess().getAsLong(), TimeUnit.NANOSECONDS);
            }
            return this.config.getExpireAfterAccess().isPresent();
        }

        private boolean configureExpireVariably() {
            this.config.getExpiryFactory().ifPresent(factory -> this.caffeine.expireAfter((Expiry)factory.create()));
            return this.config.getExpireAfterWrite().isPresent();
        }

        private boolean configureRefreshAfterWrite() {
            if (this.config.getRefreshAfterWrite().isPresent()) {
                this.caffeine.refreshAfterWrite(this.config.getRefreshAfterWrite().getAsLong(), TimeUnit.NANOSECONDS);
            }
            return this.config.getRefreshAfterWrite().isPresent();
        }

        private void configureEvictionListener() {
            this.evictionListener = new JCacheEvictionListener<K, V>(this.dispatcher, this.statistics);
            this.caffeine.writer(this.evictionListener);
        }
    }
}

