/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.jcache.processor;

import com.github.benmanes.caffeine.jcache.processor.Action;
import java.util.Objects;
import java.util.Optional;
import javax.cache.integration.CacheLoader;
import javax.cache.processor.MutableEntry;
import org.jspecify.annotations.Nullable;

public final class EntryProcessorEntry<K, V>
implements MutableEntry<K, V> {
    private final boolean hasEntry;
    private final K key;
    private Action action;
    private @Nullable V value;
    private Optional<CacheLoader<K, V>> cacheLoader;

    public EntryProcessorEntry(K key, @Nullable V value, Optional<CacheLoader<K, V>> cacheLoader) {
        this.hasEntry = value != null;
        this.cacheLoader = cacheLoader;
        this.action = Action.NONE;
        this.value = value;
        this.key = key;
    }

    public boolean exists() {
        return this.getValue() != null;
    }

    public K getKey() {
        return this.key;
    }

    public @Nullable V getValue() {
        if (this.action != Action.NONE) {
            return this.value;
        }
        if (this.value != null) {
            this.action = Action.READ;
        } else if (this.cacheLoader.isPresent()) {
            this.value = this.cacheLoader.orElseThrow().load(this.key);
            this.cacheLoader = Optional.empty();
            if (this.value != null) {
                this.action = Action.LOADED;
            }
        }
        return this.value;
    }

    public void remove() {
        Action action = this.action = this.action == Action.CREATED ? Action.NONE : Action.DELETED;
        if (this.value != null) {
            this.value = null;
        }
    }

    public void setValue(V value) {
        Objects.requireNonNull(value);
        if (this.action != Action.CREATED) {
            this.action = this.hasEntry && this.exists() ? Action.UPDATED : Action.CREATED;
        }
        this.value = value;
    }

    public Action getAction() {
        return this.action;
    }

    public <T> T unwrap(Class<T> clazz) {
        if (!clazz.isInstance(this)) {
            throw new IllegalArgumentException("Class " + String.valueOf(clazz) + " is unknown to this implementation");
        }
        EntryProcessorEntry castedEntry = this;
        return (T)castedEntry;
    }

    public String toString() {
        return String.valueOf(this.key) + "=" + String.valueOf(this.getValue());
    }
}

