/*
 * Decompiled with CFR 0.152.
 */
package com.beeline09.daterangepicker.date;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.Bundle;
import android.text.format.DateFormat;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import androidx.core.view.AccessibilityDelegateCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.accessibility.AccessibilityNodeInfoCompat;
import androidx.customview.widget.ExploreByTouchHelper;
import com.beeline09.daterangepicker.R;
import com.beeline09.daterangepicker.TypefaceHelper;
import com.beeline09.daterangepicker.date.DateRangePickerController;
import com.beeline09.daterangepicker.date.MonthAdapter;
import java.security.InvalidParameterException;
import java.util.Calendar;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0007\n\u0002\b\u001a\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b&\u0018\u0000 \u00c7\u00012\u00020\u0001:\u0006\u00c7\u0001\u00c8\u0001\u00c9\u0001B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u008e\u0001\u001a\u00020\u0017H\u0002J\b\u0010\u008f\u0001\u001a\u00030\u0090\u0001J\u0013\u0010\u0091\u0001\u001a\u00020.2\b\u0010\u0092\u0001\u001a\u00030\u0093\u0001H\u0016Je\u0010\u0094\u0001\u001a\u00030\u0090\u00012\b\u0010\u0095\u0001\u001a\u00030\u0096\u00012\u0007\u0010\u008b\u0001\u001a\u00020\u00172\u0007\u0010\u0080\u0001\u001a\u00020\u00172\u0007\u0010\u0097\u0001\u001a\u00020\u00172\u0007\u0010\u0098\u0001\u001a\u00020\u00172\u0007\u0010\u0099\u0001\u001a\u00020\u00172\u0007\u0010\u009a\u0001\u001a\u00020\u00172\u0007\u0010\u009b\u0001\u001a\u00020\u00172\u0007\u0010\u009c\u0001\u001a\u00020\u00172\u0007\u0010\u009d\u0001\u001a\u00020\u0017H&J\u0014\u0010\u009e\u0001\u001a\u00030\u0090\u00012\b\u0010\u0095\u0001\u001a\u00030\u0096\u0001H\u0004J\u0014\u0010\u009f\u0001\u001a\u00030\u0090\u00012\b\u0010\u0095\u0001\u001a\u00030\u0096\u0001H\u0004J\u0014\u0010\u00a0\u0001\u001a\u00030\u0090\u00012\b\u0010\u0095\u0001\u001a\u00030\u0096\u0001H\u0004J\t\u0010\u00a1\u0001\u001a\u00020\u0017H\u0004J\u001b\u0010\u00a2\u0001\u001a\u00020\u00172\b\u0010\u0098\u0001\u001a\u00030\u00a3\u00012\b\u0010\u0099\u0001\u001a\u00030\u00a3\u0001J\u001d\u0010\u00a4\u0001\u001a\u00020\u00172\b\u0010\u0098\u0001\u001a\u00030\u00a3\u00012\b\u0010\u0099\u0001\u001a\u00030\u00a3\u0001H\u0004J\n\u0010\u00a5\u0001\u001a\u00030\u0090\u0001H\u0004J$\u0010\u00a6\u0001\u001a\u00020.2\u0007\u0010\u008b\u0001\u001a\u00020\u00172\u0007\u0010\u0080\u0001\u001a\u00020\u00172\u0007\u0010\u0097\u0001\u001a\u00020\u0017H\u0002J$\u0010\u00a7\u0001\u001a\u00020.2\u0007\u0010\u008b\u0001\u001a\u00020\u00172\u0007\u0010\u0080\u0001\u001a\u00020\u00172\u0007\u0010\u0097\u0001\u001a\u00020\u0017H\u0002J$\u0010\u00a8\u0001\u001a\u00020.2\u0007\u0010\u008b\u0001\u001a\u00020\u00172\u0007\u0010\u0080\u0001\u001a\u00020\u00172\u0007\u0010\u0097\u0001\u001a\u00020\u0017H\u0004J$\u0010\u00a9\u0001\u001a\u00020.2\u0007\u0010\u008b\u0001\u001a\u00020\u00172\u0007\u0010\u0080\u0001\u001a\u00020\u00172\u0007\u0010\u0097\u0001\u001a\u00020\u0017H\u0004J$\u0010\u00aa\u0001\u001a\u00020.2\u0007\u0010\u008b\u0001\u001a\u00020\u00172\u0007\u0010\u0080\u0001\u001a\u00020\u00172\u0007\u0010\u0097\u0001\u001a\u00020\u0017H\u0002J\u0013\u0010\u00ab\u0001\u001a\u00030\u0090\u00012\u0007\u0010\u0097\u0001\u001a\u00020\u0017H\u0002J\u0014\u0010\u00ac\u0001\u001a\u00030\u0090\u00012\b\u0010\u0095\u0001\u001a\u00030\u0096\u0001H\u0014J\u001c\u0010\u00ad\u0001\u001a\u00030\u0090\u00012\u0007\u0010\u00ae\u0001\u001a\u00020\u00172\u0007\u0010\u00af\u0001\u001a\u00020\u0017H\u0014J.\u0010\u00b0\u0001\u001a\u00030\u0090\u00012\u0007\u0010\u00b1\u0001\u001a\u00020\u00172\u0007\u0010\u00b2\u0001\u001a\u00020\u00172\u0007\u0010\u00b3\u0001\u001a\u00020\u00172\u0007\u0010\u00b4\u0001\u001a\u00020\u0017H\u0014J\u0013\u0010\u00b5\u0001\u001a\u00020.2\b\u0010\u0092\u0001\u001a\u00030\u0093\u0001H\u0016J\u0010\u0010\u00b6\u0001\u001a\u00020.2\u0007\u0010\u0097\u0001\u001a\u00020\nJ\b\u0010\u00b7\u0001\u001a\u00030\u0090\u0001J\u001b\u0010\u00b8\u0001\u001a\u00020.2\u0007\u0010\u0097\u0001\u001a\u00020\u00172\u0007\u0010\u00b9\u0001\u001a\u00020\u000eH\u0002J\u0011\u0010\u00ba\u0001\u001a\u00030\u0090\u00012\u0007\u0010\u00bb\u0001\u001a\u00020\u0017J\u0016\u0010\u00bc\u0001\u001a\u00030\u0090\u00012\n\u0010\u00bd\u0001\u001a\u0005\u0018\u00010\u00be\u0001H\u0016J\u0011\u0010\u00bf\u0001\u001a\u00030\u0090\u00012\u0007\u0010\u00c0\u0001\u001a\u00020\u0007J\u001e\u0010\u00c1\u0001\u001a\u00030\u0090\u00012\u0014\u0010\u00c2\u0001\u001a\u000f\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00170\u00c3\u0001J\u0011\u0010\u00c4\u0001\u001a\u00030\u0090\u00012\u0007\u0010\u00c5\u0001\u001a\u00020WJ\u0011\u0010\u00c6\u0001\u001a\u00030\u0090\u00012\u0007\u0010\u0097\u0001\u001a\u00020\u0017R\u0013\u0010\t\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001c\"\u0004\b!\u0010\u001eR\u001a\u0010\"\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001c\"\u0004\b$\u0010\u001eR\u001a\u0010%\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001c\"\u0004\b'\u0010\u001eR\u001a\u0010(\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u001c\"\u0004\b*\u0010\u001eR\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010-\u001a\u00020.X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001a\u00103\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b4\u0010\u001c\"\u0004\b5\u0010\u001eR\u001a\u00106\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u0010\u001c\"\u0004\b8\u0010\u001eR\u000e\u00109\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010:\u001a\u0004\u0018\u00010;X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u001a\u0010@\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010\u001c\"\u0004\bB\u0010\u001eR\u001c\u0010C\u001a\u0004\u0018\u00010;X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010=\"\u0004\bE\u0010?R\u001a\u0010F\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010\u001c\"\u0004\bH\u0010\u001eR\u001c\u0010I\u001a\u0004\u0018\u00010;X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010=\"\u0004\bK\u0010?R\u000e\u0010L\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010M\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010\u001c\"\u0004\bO\u0010\u001eR\u001a\u0010P\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010\u001c\"\u0004\bR\u0010\u001eR\u001a\u0010S\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010\u001c\"\u0004\bU\u0010\u001eR\u001c\u0010V\u001a\u0004\u0018\u00010WX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bX\u0010Y\"\u0004\bZ\u0010[R\u001a\u0010\\\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b]\u0010\u001c\"\u0004\b^\u0010\u001eR\u001c\u0010_\u001a\u0004\u0018\u00010;X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b`\u0010=\"\u0004\ba\u0010?R\u001a\u0010b\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bc\u0010\u001c\"\u0004\bd\u0010\u001eR\u001a\u0010e\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bf\u0010\u001c\"\u0004\bg\u0010\u001eR\u001a\u0010h\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bi\u0010\u001c\"\u0004\bj\u0010\u001eR\u001a\u0010k\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bl\u0010\u001c\"\u0004\bm\u0010\u001eR\u0012\u0010n\u001a\u00060oj\u0002`pX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010q\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\br\u0010\u001c\"\u0004\bs\u0010\u001eR\u001a\u0010t\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bu\u0010\u001c\"\u0004\bv\u0010\u001eR\u0012\u0010w\u001a\u00060xR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010y\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bz\u0010\u001c\"\u0004\b{\u0010\u001eR\u001a\u0010|\u001a\u00020\u0017X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b}\u0010\u001c\"\u0004\b~\u0010\u001eR'\u0010\u0080\u0001\u001a\u00020\u00172\u0006\u0010\u007f\u001a\u00020\u0017@DX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u0081\u0001\u0010\u001c\"\u0005\b\u0082\u0001\u0010\u001eR\u0017\u0010\u0083\u0001\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\b\u001a\u0006\b\u0084\u0001\u0010\u0085\u0001R\u0016\u0010\u0086\u0001\u001a\u00020\u00178DX\u0084\u0004\u00a2\u0006\u0007\u001a\u0005\b\u0087\u0001\u0010\u001cR\u001b\u0010\u0088\u0001\u001a\u00060xR\u00020\u00008DX\u0084\u0004\u00a2\u0006\b\u001a\u0006\b\u0089\u0001\u0010\u008a\u0001R'\u0010\u008b\u0001\u001a\u00020\u00172\u0006\u0010\u007f\u001a\u00020\u0017@DX\u0086\u000e\u00a2\u0006\u0010\n\u0000\u001a\u0005\b\u008c\u0001\u0010\u001c\"\u0005\b\u008d\u0001\u0010\u001e\u00a8\u0006\u00ca\u0001"}, d2={"Lcom/beeline09/daterangepicker/date/MonthView;", "Landroid/view/View;", "context", "Landroid/content/Context;", "attr", "Landroid/util/AttributeSet;", "mController", "Lcom/beeline09/daterangepicker/date/DateRangePickerController;", "(Landroid/content/Context;Landroid/util/AttributeSet;Lcom/beeline09/daterangepicker/date/DateRangePickerController;)V", "accessibilityFocus", "Lcom/beeline09/daterangepicker/date/MonthAdapter$CalendarDay;", "getAccessibilityFocus", "()Lcom/beeline09/daterangepicker/date/MonthAdapter$CalendarDay;", "mCalendar", "Ljava/util/Calendar;", "getMController", "()Lcom/beeline09/daterangepicker/date/DateRangePickerController;", "setMController", "(Lcom/beeline09/daterangepicker/date/DateRangePickerController;)V", "mDayLabelCalendar", "getMDayLabelCalendar", "()Ljava/util/Calendar;", "mDayOfWeekStart", "", "mDayOfWeekTypeface", "", "mDayTextColor", "getMDayTextColor", "()I", "setMDayTextColor", "(I)V", "mDisabledDayTextColor", "getMDisabledDayTextColor", "setMDisabledDayTextColor", "mEdgePadding", "getMEdgePadding", "setMEdgePadding", "mFirstJulianDay", "getMFirstJulianDay", "setMFirstJulianDay", "mFirstMonth", "getMFirstMonth", "setMFirstMonth", "mFormatter", "Ljava/util/Formatter;", "mHasToday", "", "getMHasToday", "()Z", "setMHasToday", "(Z)V", "mHighlightedDayTextColor", "getMHighlightedDayTextColor", "setMHighlightedDayTextColor", "mLastMonth", "getMLastMonth", "setMLastMonth", "mLockAccessibilityDelegate", "mMonthDayLabelPaint", "Landroid/graphics/Paint;", "getMMonthDayLabelPaint", "()Landroid/graphics/Paint;", "setMMonthDayLabelPaint", "(Landroid/graphics/Paint;)V", "mMonthDayTextColor", "getMMonthDayTextColor", "setMMonthDayTextColor", "mMonthNumPaint", "getMMonthNumPaint", "setMMonthNumPaint", "mMonthTitleColor", "getMMonthTitleColor", "setMMonthTitleColor", "mMonthTitlePaint", "getMMonthTitlePaint", "setMMonthTitlePaint", "mMonthTitleTypeface", "mNumCells", "getMNumCells", "setMNumCells", "mNumDays", "getMNumDays", "setMNumDays", "mNumRows", "getMNumRows", "setMNumRows", "mOnDayClickListener", "Lcom/beeline09/daterangepicker/date/MonthView$OnDayClickListener;", "getMOnDayClickListener", "()Lcom/beeline09/daterangepicker/date/MonthView$OnDayClickListener;", "setMOnDayClickListener", "(Lcom/beeline09/daterangepicker/date/MonthView$OnDayClickListener;)V", "mRowHeight", "getMRowHeight", "setMRowHeight", "mSelectedCirclePaint", "getMSelectedCirclePaint", "setMSelectedCirclePaint", "mSelectedDay", "getMSelectedDay", "setMSelectedDay", "mSelectedDayTextColor", "getMSelectedDayTextColor", "setMSelectedDayTextColor", "mSelectedLeft", "getMSelectedLeft", "setMSelectedLeft", "mSelectedRight", "getMSelectedRight", "setMSelectedRight", "mStringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "mToday", "getMToday", "setMToday", "mTodayNumberColor", "getMTodayNumberColor", "setMTodayNumberColor", "mTouchHelper", "Lcom/beeline09/daterangepicker/date/MonthView$MonthViewTouchHelper;", "mWeekStart", "getMWeekStart", "setMWeekStart", "mWidth", "getMWidth", "setMWidth", "<set-?>", "month", "getMonth", "setMonth", "monthAndYearString", "getMonthAndYearString", "()Ljava/lang/String;", "monthHeaderSize", "getMonthHeaderSize", "monthViewTouchHelper", "getMonthViewTouchHelper", "()Lcom/beeline09/daterangepicker/date/MonthView$MonthViewTouchHelper;", "year", "getYear", "setYear", "calculateNumRows", "clearAccessibilityFocus", "", "dispatchHoverEvent", "event", "Landroid/view/MotionEvent;", "drawMonthDay", "canvas", "Landroid/graphics/Canvas;", "day", "x", "y", "startX", "stopX", "startY", "stopY", "drawMonthDayLabels", "drawMonthNums", "drawMonthTitle", "findDayOffset", "getDayFromLocation", "", "getInternalDayFromLocation", "initView", "isAfterMax", "isBeforeMin", "isHighlighted", "isOutOfRange", "isSelectable", "onDayClick", "onDraw", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onSizeChanged", "w", "h", "oldw", "oldh", "onTouchEvent", "restoreAccessibilityFocus", "reuse", "sameDay", "today", "setAccentColor", "color", "setAccessibilityDelegate", "delegate", "Landroid/view/View$AccessibilityDelegate;", "setDatePickerController", "controller", "setMonthParams", "params", "Ljava/util/HashMap;", "setOnDayClickListener", "listener", "setSelectedDay", "Companion", "MonthViewTouchHelper", "OnDayClickListener", "daterangepicker_release"})
public abstract class MonthView
extends View {
    private int mEdgePadding;
    private final String mDayOfWeekTypeface;
    private final String mMonthTitleTypeface;
    @Nullable
    private Paint mMonthNumPaint;
    @Nullable
    private Paint mMonthTitlePaint;
    @Nullable
    private Paint mSelectedCirclePaint;
    @Nullable
    private Paint mMonthDayLabelPaint;
    private final Formatter mFormatter;
    private final StringBuilder mStringBuilder;
    private int mFirstJulianDay;
    private int mFirstMonth;
    private int mLastMonth;
    private int month;
    private int year;
    private int mWidth;
    private int mRowHeight;
    private boolean mHasToday;
    private int mSelectedDay;
    private int mToday;
    private int mWeekStart;
    private int mNumDays;
    private int mNumCells;
    private int mSelectedLeft;
    private int mSelectedRight;
    private final Calendar mCalendar;
    @NotNull
    private final Calendar mDayLabelCalendar;
    private final MonthViewTouchHelper mTouchHelper;
    private int mNumRows;
    @Nullable
    private OnDayClickListener mOnDayClickListener;
    private final boolean mLockAccessibilityDelegate;
    private int mDayTextColor;
    private int mSelectedDayTextColor;
    private int mMonthDayTextColor;
    private int mTodayNumberColor;
    private int mHighlightedDayTextColor;
    private int mDisabledDayTextColor;
    private int mMonthTitleColor;
    private int mDayOfWeekStart;
    @Nullable
    private DateRangePickerController mController;
    private static final String TAG = "MonthView";
    @NotNull
    private static final String VIEW_PARAMS_HEIGHT = "height";
    @NotNull
    private static final String VIEW_PARAMS_MONTH = "month";
    @NotNull
    private static final String VIEW_PARAMS_YEAR = "year";
    @NotNull
    private static final String VIEW_PARAMS_SELECTED_DAY = "selected_day";
    @NotNull
    private static final String VIEW_PARAMS_WEEK_START = "week_start";
    @NotNull
    private static final String VIEW_PARAMS_NUM_DAYS = "num_days";
    @NotNull
    private static final String VIEW_PARAMS_FOCUS_MONTH = "focus_month";
    @NotNull
    private static final String VIEW_PARAMS_SHOW_WK_NUM = "show_wk_num";
    private static int DEFAULT_HEIGHT;
    private static int MIN_HEIGHT;
    private static final int DEFAULT_SELECTED_DAY = -1;
    private static final int DEFAULT_WEEK_START = 1;
    private static final int DEFAULT_NUM_DAYS = 7;
    private static final int DEFAULT_SHOW_WK_NUM = 0;
    private static final int DEFAULT_FOCUS_MONTH = -1;
    private static final int DEFAULT_NUM_ROWS = 6;
    private static final int MAX_NUM_ROWS = 6;
    private static final int SELECTED_CIRCLE_ALPHA = 255;
    private static int DAY_SEPARATOR_WIDTH;
    private static int MINI_DAY_NUMBER_TEXT_SIZE;
    private static int MONTH_LABEL_TEXT_SIZE;
    private static int MONTH_DAY_LABEL_TEXT_SIZE;
    private static int MONTH_HEADER_SIZE;
    private static int DAY_SELECTED_CIRCLE_SIZE;
    private static float mScale;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    protected final int getMEdgePadding() {
        return this.mEdgePadding;
    }

    protected final void setMEdgePadding(int n) {
        this.mEdgePadding = n;
    }

    @Nullable
    protected final Paint getMMonthNumPaint() {
        return this.mMonthNumPaint;
    }

    protected final void setMMonthNumPaint(@Nullable Paint paint) {
        this.mMonthNumPaint = paint;
    }

    @Nullable
    protected final Paint getMMonthTitlePaint() {
        return this.mMonthTitlePaint;
    }

    protected final void setMMonthTitlePaint(@Nullable Paint paint) {
        this.mMonthTitlePaint = paint;
    }

    @Nullable
    protected final Paint getMSelectedCirclePaint() {
        return this.mSelectedCirclePaint;
    }

    protected final void setMSelectedCirclePaint(@Nullable Paint paint) {
        this.mSelectedCirclePaint = paint;
    }

    @Nullable
    protected final Paint getMMonthDayLabelPaint() {
        return this.mMonthDayLabelPaint;
    }

    protected final void setMMonthDayLabelPaint(@Nullable Paint paint) {
        this.mMonthDayLabelPaint = paint;
    }

    protected final int getMFirstJulianDay() {
        return this.mFirstJulianDay;
    }

    protected final void setMFirstJulianDay(int n) {
        this.mFirstJulianDay = n;
    }

    protected final int getMFirstMonth() {
        return this.mFirstMonth;
    }

    protected final void setMFirstMonth(int n) {
        this.mFirstMonth = n;
    }

    protected final int getMLastMonth() {
        return this.mLastMonth;
    }

    protected final void setMLastMonth(int n) {
        this.mLastMonth = n;
    }

    public final int getMonth() {
        return this.month;
    }

    protected final void setMonth(int n) {
        this.month = n;
    }

    public final int getYear() {
        return this.year;
    }

    protected final void setYear(int n) {
        this.year = n;
    }

    protected final int getMWidth() {
        return this.mWidth;
    }

    protected final void setMWidth(int n) {
        this.mWidth = n;
    }

    protected final int getMRowHeight() {
        return this.mRowHeight;
    }

    protected final void setMRowHeight(int n) {
        this.mRowHeight = n;
    }

    protected final boolean getMHasToday() {
        return this.mHasToday;
    }

    protected final void setMHasToday(boolean bl) {
        this.mHasToday = bl;
    }

    protected final int getMSelectedDay() {
        return this.mSelectedDay;
    }

    protected final void setMSelectedDay(int n) {
        this.mSelectedDay = n;
    }

    protected final int getMToday() {
        return this.mToday;
    }

    protected final void setMToday(int n) {
        this.mToday = n;
    }

    protected final int getMWeekStart() {
        return this.mWeekStart;
    }

    protected final void setMWeekStart(int n) {
        this.mWeekStart = n;
    }

    protected final int getMNumDays() {
        return this.mNumDays;
    }

    protected final void setMNumDays(int n) {
        this.mNumDays = n;
    }

    protected final int getMNumCells() {
        return this.mNumCells;
    }

    protected final void setMNumCells(int n) {
        this.mNumCells = n;
    }

    protected final int getMSelectedLeft() {
        return this.mSelectedLeft;
    }

    protected final void setMSelectedLeft(int n) {
        this.mSelectedLeft = n;
    }

    protected final int getMSelectedRight() {
        return this.mSelectedRight;
    }

    protected final void setMSelectedRight(int n) {
        this.mSelectedRight = n;
    }

    @NotNull
    protected final Calendar getMDayLabelCalendar() {
        return this.mDayLabelCalendar;
    }

    protected final int getMNumRows() {
        return this.mNumRows;
    }

    protected final void setMNumRows(int n) {
        this.mNumRows = n;
    }

    @Nullable
    protected final OnDayClickListener getMOnDayClickListener() {
        return this.mOnDayClickListener;
    }

    protected final void setMOnDayClickListener(@Nullable OnDayClickListener onDayClickListener) {
        this.mOnDayClickListener = onDayClickListener;
    }

    protected final int getMDayTextColor() {
        return this.mDayTextColor;
    }

    protected final void setMDayTextColor(int n) {
        this.mDayTextColor = n;
    }

    protected final int getMSelectedDayTextColor() {
        return this.mSelectedDayTextColor;
    }

    protected final void setMSelectedDayTextColor(int n) {
        this.mSelectedDayTextColor = n;
    }

    protected final int getMMonthDayTextColor() {
        return this.mMonthDayTextColor;
    }

    protected final void setMMonthDayTextColor(int n) {
        this.mMonthDayTextColor = n;
    }

    protected final int getMTodayNumberColor() {
        return this.mTodayNumberColor;
    }

    protected final void setMTodayNumberColor(int n) {
        this.mTodayNumberColor = n;
    }

    protected final int getMHighlightedDayTextColor() {
        return this.mHighlightedDayTextColor;
    }

    protected final void setMHighlightedDayTextColor(int n) {
        this.mHighlightedDayTextColor = n;
    }

    protected final int getMDisabledDayTextColor() {
        return this.mDisabledDayTextColor;
    }

    protected final void setMDisabledDayTextColor(int n) {
        this.mDisabledDayTextColor = n;
    }

    protected final int getMMonthTitleColor() {
        return this.mMonthTitleColor;
    }

    protected final void setMMonthTitleColor(int n) {
        this.mMonthTitleColor = n;
    }

    @NotNull
    protected final MonthViewTouchHelper getMonthViewTouchHelper() {
        return new MonthViewTouchHelper(this);
    }

    protected final int getMonthHeaderSize() {
        return MONTH_HEADER_SIZE;
    }

    private final String getMonthAndYearString() {
        int flags = 52;
        this.mStringBuilder.setLength(0);
        long millis = this.mCalendar.getTimeInMillis();
        String string2 = DateUtils.formatDateRange((Context)this.getContext(), (Formatter)this.mFormatter, (long)millis, (long)millis, (int)flags, null).toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"DateUtils.formatDateRang\u2026         null).toString()");
        return string2;
    }

    @Nullable
    public final MonthAdapter.CalendarDay getAccessibilityFocus() {
        int day = this.mTouchHelper.getFocusedVirtualView();
        return day >= 0 ? new MonthAdapter.CalendarDay(this.year, this.month, day) : null;
    }

    public final void setDatePickerController(@NotNull DateRangePickerController controller) {
        Intrinsics.checkParameterIsNotNull((Object)controller, (String)"controller");
        this.mController = controller;
    }

    public void setAccessibilityDelegate(@Nullable View.AccessibilityDelegate delegate) {
        if (!this.mLockAccessibilityDelegate) {
            super.setAccessibilityDelegate(delegate);
        }
    }

    public final void setOnDayClickListener(@NotNull OnDayClickListener listener) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        this.mOnDayClickListener = listener;
    }

    public boolean dispatchHoverEvent(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        return this.mTouchHelper.dispatchHoverEvent(event) ? true : super.dispatchHoverEvent(event);
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        switch (event.getAction()) {
            case 1: {
                int day = this.getDayFromLocation(event.getX(), event.getY());
                if (day < 0) break;
                this.onDayClick(day);
            }
        }
        return true;
    }

    protected final void initView() {
        block24: {
            Paint paint = this.mMonthTitlePaint = new Paint();
            if (paint != null) {
                paint.setFakeBoldText(true);
            }
            Paint paint2 = this.mMonthTitlePaint;
            if (paint2 != null) {
                paint2.setAntiAlias(true);
            }
            Paint paint3 = this.mMonthTitlePaint;
            if (paint3 != null) {
                paint3.setTextSize((float)MONTH_LABEL_TEXT_SIZE);
            }
            Paint paint4 = this.mMonthTitlePaint;
            if (paint4 != null) {
                paint4.setTypeface(Typeface.create((String)this.mMonthTitleTypeface, (int)1));
            }
            Paint paint5 = this.mMonthTitlePaint;
            if (paint5 != null) {
                paint5.setColor(this.mDayTextColor);
            }
            Paint paint6 = this.mMonthTitlePaint;
            if (paint6 != null) {
                paint6.setTextAlign(Paint.Align.CENTER);
            }
            Paint paint7 = this.mMonthTitlePaint;
            if (paint7 != null) {
                paint7.setStyle(Paint.Style.FILL);
            }
            Paint paint8 = this.mSelectedCirclePaint = new Paint();
            if (paint8 != null) {
                paint8.setFakeBoldText(true);
            }
            Paint paint9 = this.mSelectedCirclePaint;
            if (paint9 != null) {
                paint9.setAntiAlias(true);
            }
            Paint paint10 = this.mSelectedCirclePaint;
            if (paint10 != null) {
                paint10.setColor(this.mTodayNumberColor);
            }
            Paint paint11 = this.mSelectedCirclePaint;
            if (paint11 != null) {
                paint11.setTextAlign(Paint.Align.CENTER);
            }
            Paint paint12 = this.mSelectedCirclePaint;
            if (paint12 != null) {
                paint12.setStyle(Paint.Style.FILL);
            }
            Paint paint13 = this.mSelectedCirclePaint;
            if (paint13 != null) {
                paint13.setAlpha(SELECTED_CIRCLE_ALPHA);
            }
            Paint paint14 = this.mMonthDayLabelPaint = new Paint();
            if (paint14 != null) {
                paint14.setAntiAlias(true);
            }
            Paint paint15 = this.mMonthDayLabelPaint;
            if (paint15 != null) {
                paint15.setTextSize((float)MONTH_DAY_LABEL_TEXT_SIZE);
            }
            Paint paint16 = this.mMonthDayLabelPaint;
            if (paint16 != null) {
                paint16.setColor(this.mMonthDayTextColor);
            }
            Paint paint17 = this.mMonthDayLabelPaint;
            if (paint17 != null) {
                Context context = this.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                paint17.setTypeface(TypefaceHelper.INSTANCE.get(context, "Roboto-Medium"));
            }
            Paint paint18 = this.mMonthDayLabelPaint;
            if (paint18 != null) {
                paint18.setStyle(Paint.Style.FILL);
            }
            Paint paint19 = this.mMonthDayLabelPaint;
            if (paint19 != null) {
                paint19.setTextAlign(Paint.Align.CENTER);
            }
            Paint paint20 = this.mMonthDayLabelPaint;
            if (paint20 != null) {
                paint20.setFakeBoldText(true);
            }
            Paint paint21 = this.mMonthNumPaint = new Paint();
            if (paint21 != null) {
                paint21.setAntiAlias(true);
            }
            Paint paint22 = this.mMonthNumPaint;
            if (paint22 != null) {
                paint22.setTextSize((float)MINI_DAY_NUMBER_TEXT_SIZE);
            }
            Paint paint23 = this.mMonthNumPaint;
            if (paint23 != null) {
                paint23.setStyle(Paint.Style.FILL);
            }
            Paint paint24 = this.mMonthNumPaint;
            if (paint24 != null) {
                paint24.setTextAlign(Paint.Align.CENTER);
            }
            Paint paint25 = this.mMonthNumPaint;
            if (paint25 == null) break block24;
            paint25.setFakeBoldText(false);
        }
    }

    public final void setAccentColor(int color) {
        block0: {
            this.mTodayNumberColor = color;
            Paint paint = this.mSelectedCirclePaint;
            if (paint == null) break block0;
            paint.setColor(color);
        }
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        this.drawMonthTitle(canvas);
        this.drawMonthDayLabels(canvas);
        this.drawMonthNums(canvas);
    }

    /*
     * WARNING - void declaration
     */
    public final void setMonthParams(@NotNull HashMap<String, Integer> params) {
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        if (!params.containsKey(VIEW_PARAMS_MONTH) && !params.containsKey(VIEW_PARAMS_YEAR)) {
            throw (Throwable)new InvalidParameterException("You must specify month and year for this view");
        }
        this.setTag(params);
        if (params.containsKey(VIEW_PARAMS_HEIGHT)) {
            Integer n = params.get(VIEW_PARAMS_HEIGHT);
            if (n == null) {
                Intrinsics.throwNpe();
            }
            this.mRowHeight = ((Number)n).intValue();
            if (this.mRowHeight < MIN_HEIGHT) {
                this.mRowHeight = MIN_HEIGHT;
            }
        }
        if (params.containsKey(VIEW_PARAMS_SELECTED_DAY)) {
            Integer n = params.get(VIEW_PARAMS_SELECTED_DAY);
            if (n == null) {
                Intrinsics.throwNpe();
            }
            this.mSelectedDay = ((Number)n).intValue();
        }
        Integer n = params.get(VIEW_PARAMS_MONTH);
        if (n == null) {
            Intrinsics.throwNpe();
        }
        this.month = ((Number)n).intValue();
        Integer n2 = params.get(VIEW_PARAMS_YEAR);
        if (n2 == null) {
            Intrinsics.throwNpe();
        }
        this.year = ((Number)n2).intValue();
        Calendar today = Calendar.getInstance();
        this.mHasToday = false;
        this.mToday = -1;
        this.mCalendar.set(2, this.month);
        this.mCalendar.set(1, this.year);
        this.mCalendar.set(5, 1);
        this.mDayOfWeekStart = this.mCalendar.get(7);
        if (params.containsKey(VIEW_PARAMS_WEEK_START)) {
            Integer n3 = params.get(VIEW_PARAMS_WEEK_START);
            if (n3 == null) {
                Intrinsics.throwNpe();
            }
            this.mWeekStart = ((Number)n3).intValue();
        } else {
            this.mWeekStart = this.mCalendar.getFirstDayOfWeek();
        }
        this.mNumCells = this.mCalendar.getActualMaximum(5);
        int n4 = 0;
        int n5 = this.mNumCells;
        while (n4 < n5) {
            void i;
            void day = i + true;
            Calendar calendar = today;
            Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"today");
            if (this.sameDay((int)day, calendar)) {
                this.mHasToday = true;
                this.mToday = day;
            }
            ++i;
        }
        this.mNumRows = this.calculateNumRows();
        this.mTouchHelper.invalidateRoot();
    }

    public final void setSelectedDay(int day) {
        this.mSelectedDay = day;
    }

    public final void reuse() {
        this.mNumRows = DEFAULT_NUM_ROWS;
        this.requestLayout();
    }

    private final int calculateNumRows() {
        int offset = this.findDayOffset();
        int dividend = (offset + this.mNumCells) / this.mNumDays;
        int remainder = (offset + this.mNumCells) % this.mNumDays;
        return dividend + (remainder > 0 ? 1 : 0);
    }

    private final boolean sameDay(int day, Calendar today) {
        return this.year == today.get(1) && this.month == today.get(2) && day == today.get(5);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), this.mRowHeight * this.mNumRows + this.getMonthHeaderSize() + 5);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        this.mWidth = w;
        this.mTouchHelper.invalidateRoot();
    }

    protected final void drawMonthTitle(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        int x = (this.mWidth + 2 * this.mEdgePadding) / 2;
        int y = (this.getMonthHeaderSize() - MONTH_DAY_LABEL_TEXT_SIZE) / 2;
        String string2 = this.getMonthAndYearString();
        float f = x;
        float f2 = y;
        Paint paint = this.mMonthTitlePaint;
        if (paint == null) {
            paint = new Paint();
        }
        canvas.drawText(string2, f, f2, paint);
    }

    /*
     * WARNING - void declaration
     */
    protected final void drawMonthDayLabels(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        int y = this.getMonthHeaderSize() - MONTH_DAY_LABEL_TEXT_SIZE / 2;
        int dayWidthHalf = (this.mWidth - this.mEdgePadding * 2) / (this.mNumDays * 2);
        int n = 0;
        int n2 = this.mNumDays;
        while (n < n2) {
            String weekString;
            Locale locale;
            String localWeekDisplayName;
            void i;
            int x = (2 * i + 1) * dayWidthHalf + this.mEdgePadding;
            void calendarDay = (i + this.mWeekStart) % this.mNumDays;
            this.mDayLabelCalendar.set(7, (int)calendarDay);
            Locale locale2 = Locale.getDefault();
            String string2 = localWeekDisplayName = this.mDayLabelCalendar.getDisplayName(7, 1, locale2);
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            String string3 = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale2, (String)"locale");
            int n3 = 0;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toUpperCase(locale);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toUpperCase(locale)");
            string3 = string5;
            int n4 = 0;
            n3 = 1;
            int n5 = 0;
            String string6 = string3;
            if (string6 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string6.substring(n4, n3), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            if (Intrinsics.areEqual((Object)locale2, (Object)Locale.CHINA) || Intrinsics.areEqual((Object)locale2, (Object)Locale.CHINESE) || Intrinsics.areEqual((Object)locale2, (Object)Locale.SIMPLIFIED_CHINESE) || Intrinsics.areEqual((Object)locale2, (Object)Locale.TRADITIONAL_CHINESE)) {
                int len = localWeekDisplayName.length();
                String string7 = localWeekDisplayName;
                n3 = len - 1;
                n5 = 0;
                String string8 = string7.substring(n3, len);
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                weekString = string8;
            }
            if (Intrinsics.areEqual((Object)locale2.getLanguage(), (Object)"he") || Intrinsics.areEqual((Object)locale2.getLanguage(), (Object)"iw")) {
                if (this.mDayLabelCalendar.get(7) != 7) {
                    int len = localWeekDisplayName.length();
                    String string9 = localWeekDisplayName;
                    n3 = len - 2;
                    n5 = len - 1;
                    boolean bl = false;
                    String string10 = string9.substring(n3, n5);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    weekString = string10;
                } else {
                    String string11 = localWeekDisplayName;
                    Locale locale3 = locale2;
                    n3 = 0;
                    String string12 = string11.toUpperCase(locale3);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string12, (String)"(this as java.lang.String).toUpperCase(locale)");
                    string11 = string12;
                    int n6 = 0;
                    n3 = 1;
                    n5 = 0;
                    String string13 = string11;
                    if (string13 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string14 = string13.substring(n6, n3);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string14, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    weekString = string14;
                }
            }
            float f = x;
            float f2 = y;
            Paint paint = this.mMonthDayLabelPaint;
            if (paint == null) {
                paint = new Paint();
            }
            canvas.drawText(weekString, f, f2, paint);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected final void drawMonthNums(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        int y = (this.mRowHeight + MINI_DAY_NUMBER_TEXT_SIZE) / 2 - DAY_SEPARATOR_WIDTH + this.getMonthHeaderSize();
        float dayWidthHalf = (float)(this.mWidth - this.mEdgePadding * 2) / ((float)this.mNumDays * 2.0f);
        int j = this.findDayOffset();
        int n = 1;
        int n2 = this.mNumCells;
        if (n <= n2) {
            while (true) {
                void dayNumber;
                int x = (int)((float)(2 * j + 1) * dayWidthHalf + (float)this.mEdgePadding);
                int yRelativeToDay = (this.mRowHeight + MINI_DAY_NUMBER_TEXT_SIZE) / 2 - DAY_SEPARATOR_WIDTH;
                int startX = (int)((float)x - dayWidthHalf);
                int stopX = (int)((float)x + dayWidthHalf);
                int startY = y - yRelativeToDay;
                int stopY = startY + this.mRowHeight;
                this.drawMonthDay(canvas, this.year, this.month, (int)dayNumber, x, y, startX, stopX, startY, stopY);
                if (++j == this.mNumDays) {
                    j = 0;
                    y += this.mRowHeight;
                }
                if (dayNumber == n2) break;
                ++dayNumber;
            }
        }
    }

    public abstract void drawMonthDay(@NotNull Canvas var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10);

    protected final int findDayOffset() {
        return (this.mDayOfWeekStart < this.mWeekStart ? this.mDayOfWeekStart + this.mNumDays : this.mDayOfWeekStart) - this.mWeekStart;
    }

    public final int getDayFromLocation(float x, float y) {
        int day = this.getInternalDayFromLocation(x, y);
        return day < 1 || day > this.mNumCells ? -1 : day;
    }

    protected final int getInternalDayFromLocation(float x, float y) {
        int dayStart = this.mEdgePadding;
        if (x < (float)dayStart || x > (float)(this.mWidth - this.mEdgePadding)) {
            return -1;
        }
        int row = (int)(y - (float)this.getMonthHeaderSize()) / this.mRowHeight;
        int column = (int)((x - (float)dayStart) * (float)this.mNumDays / (float)(this.mWidth - dayStart - this.mEdgePadding));
        int day = column - this.findDayOffset() + 1;
        return day += row * this.mNumDays;
    }

    private final void onDayClick(int day) {
        if (this.isOutOfRange(this.year, this.month, day)) {
            return;
        }
        if (this.mOnDayClickListener != null) {
            OnDayClickListener onDayClickListener = this.mOnDayClickListener;
            if (onDayClickListener == null) {
                Intrinsics.throwNpe();
            }
            onDayClickListener.onDayClick(this, new MonthAdapter.CalendarDay(this.year, this.month, day));
        }
        this.mTouchHelper.sendEventForVirtualView(day, 1);
    }

    protected final boolean isOutOfRange(int year, int month, int day) {
        DateRangePickerController dateRangePickerController = this.mController;
        if (dateRangePickerController == null) {
            Intrinsics.throwNpe();
        }
        if (dateRangePickerController.getSelectableDays() != null) {
            return !this.isSelectable(year, month, day);
        }
        if (this.isBeforeMin(year, month, day)) {
            return true;
        }
        return this.isAfterMax(year, month, day);
    }

    private final boolean isSelectable(int year, int month, int day) {
        Calendar[] selectableDays;
        DateRangePickerController dateRangePickerController = this.mController;
        if (dateRangePickerController == null) {
            Intrinsics.throwNpe();
        }
        for (Calendar c : selectableDays = dateRangePickerController.getSelectableDays()) {
            if (year < c.get(1)) break;
            if (year > c.get(1)) continue;
            if (month < c.get(2)) break;
            if (month > c.get(2)) continue;
            if (day < c.get(5)) break;
            if (day > c.get(5)) continue;
            return true;
        }
        return false;
    }

    private final boolean isBeforeMin(int year, int month, int day) {
        if (this.mController == null) {
            return false;
        }
        DateRangePickerController dateRangePickerController = this.mController;
        if (dateRangePickerController == null) {
            Intrinsics.throwNpe();
        }
        Calendar calendar = dateRangePickerController.getMinSelectableDate();
        if (calendar == null) {
            return false;
        }
        Calendar minDate = calendar;
        if (year < minDate.get(1)) {
            return true;
        }
        if (year > minDate.get(1)) {
            return false;
        }
        if (month < minDate.get(2)) {
            return true;
        }
        if (month > minDate.get(2)) {
            return false;
        }
        return day < minDate.get(5);
    }

    private final boolean isAfterMax(int year, int month, int day) {
        if (this.mController == null) {
            return false;
        }
        DateRangePickerController dateRangePickerController = this.mController;
        if (dateRangePickerController == null) {
            Intrinsics.throwNpe();
        }
        Calendar calendar = dateRangePickerController.getMaxDate();
        if (calendar == null) {
            return false;
        }
        Calendar maxDate = calendar;
        if (year > maxDate.get(1)) {
            return true;
        }
        if (year < maxDate.get(1)) {
            return false;
        }
        if (month > maxDate.get(2)) {
            return true;
        }
        if (month < maxDate.get(2)) {
            return false;
        }
        return day > maxDate.get(5);
    }

    protected final boolean isHighlighted(int year, int month, int day) {
        Calendar[] highlightedDays;
        DateRangePickerController dateRangePickerController = this.mController;
        if (dateRangePickerController == null) {
            Intrinsics.throwNpe();
        }
        Calendar[] calendarArray = dateRangePickerController.getHighlightedDays();
        if (calendarArray == null) {
            return false;
        }
        for (Calendar c : highlightedDays = calendarArray) {
            if (year < c.get(1)) break;
            if (year > c.get(1)) continue;
            if (month < c.get(2)) break;
            if (month > c.get(2)) continue;
            if (day < c.get(5)) break;
            if (day > c.get(5)) continue;
            return true;
        }
        return false;
    }

    public final void clearAccessibilityFocus() {
        this.mTouchHelper.clearFocusedVirtualView();
    }

    public final boolean restoreAccessibilityFocus(@NotNull MonthAdapter.CalendarDay day) {
        Intrinsics.checkParameterIsNotNull((Object)day, (String)"day");
        if (day.getYear() != this.year || day.getMonth() != this.month || day.getDay() > this.mNumCells) {
            return false;
        }
        this.mTouchHelper.setFocusedVirtualView(day.getDay());
        return true;
    }

    @Nullable
    protected final DateRangePickerController getMController() {
        return this.mController;
    }

    protected final void setMController(@Nullable DateRangePickerController dateRangePickerController) {
        this.mController = dateRangePickerController;
    }

    /*
     * Unable to fully structure code
     */
    @JvmOverloads
    public MonthView(@NotNull Context context, @Nullable AttributeSet attr, @Nullable DateRangePickerController mController) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        super(context, attr);
        this.mController = mController;
        this.mFirstJulianDay = -1;
        this.mFirstMonth = -1;
        this.mLastMonth = -1;
        this.mRowHeight = MonthView.DEFAULT_HEIGHT;
        this.mSelectedDay = -1;
        this.mToday = MonthView.DEFAULT_SELECTED_DAY;
        this.mWeekStart = MonthView.DEFAULT_WEEK_START;
        this.mNumCells = this.mNumDays = MonthView.DEFAULT_NUM_DAYS;
        this.mSelectedLeft = -1;
        this.mSelectedRight = -1;
        this.mNumRows = MonthView.DEFAULT_NUM_ROWS;
        res = context.getResources();
        v0 = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)v0, (String)"Calendar.getInstance()");
        this.mDayLabelCalendar = v0;
        v1 = Calendar.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"Calendar.getInstance()");
        this.mCalendar = v1;
        v2 = res.getString(R.string.mdtp_day_of_week_label_typeface);
        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"res.getString(R.string.m\u2026y_of_week_label_typeface)");
        this.mDayOfWeekTypeface = v2;
        v3 = res.getString(R.string.mdtp_sans_serif);
        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"res.getString(R.string.mdtp_sans_serif)");
        this.mMonthTitleTypeface = v3;
        if (this.mController == null) ** GOTO lbl-1000
        v4 = this.mController;
        if (v4 == null) {
            Intrinsics.throwNpe();
        }
        if (v4.isThemeDark()) {
            v5 = true;
        } else lbl-1000:
        // 2 sources

        {
            v5 = darkTheme = false;
        }
        if (darkTheme) {
            this.mDayTextColor = res.getColor(R.color.mdtp_date_picker_text_normal_dark_theme);
            this.mMonthDayTextColor = res.getColor(R.color.mdtp_date_picker_month_day_dark_theme);
            this.mDisabledDayTextColor = res.getColor(R.color.mdtp_date_picker_text_disabled_dark_theme);
            this.mHighlightedDayTextColor = res.getColor(R.color.mdtp_date_picker_text_highlighted_dark_theme);
        } else {
            this.mDayTextColor = res.getColor(R.color.mdtp_date_picker_text_normal);
            this.mMonthDayTextColor = res.getColor(R.color.mdtp_date_picker_month_day);
            this.mDisabledDayTextColor = res.getColor(R.color.mdtp_date_picker_text_disabled);
            this.mHighlightedDayTextColor = res.getColor(R.color.mdtp_date_picker_text_highlighted);
        }
        this.mSelectedDayTextColor = res.getColor(R.color.mdtp_white);
        this.mTodayNumberColor = res.getColor(R.color.mdtp_accent_color);
        this.mMonthTitleColor = res.getColor(R.color.mdtp_white);
        this.mStringBuilder = new StringBuilder(50);
        this.mFormatter = new Formatter(this.mStringBuilder, Locale.getDefault());
        MonthView.MINI_DAY_NUMBER_TEXT_SIZE = res.getDimensionPixelSize(R.dimen.mdtp_day_number_size);
        MonthView.MONTH_LABEL_TEXT_SIZE = res.getDimensionPixelSize(R.dimen.mdtp_month_label_size);
        MonthView.MONTH_DAY_LABEL_TEXT_SIZE = res.getDimensionPixelSize(R.dimen.mdtp_month_day_label_text_size);
        MonthView.MONTH_HEADER_SIZE = res.getDimensionPixelOffset(R.dimen.mdtp_month_list_item_header_height);
        MonthView.DAY_SELECTED_CIRCLE_SIZE = res.getDimensionPixelSize(R.dimen.mdtp_day_number_select_circle_radius);
        this.mRowHeight = (res.getDimensionPixelOffset(R.dimen.mdtp_date_picker_view_animator_height) - this.getMonthHeaderSize()) / MonthView.MAX_NUM_ROWS;
        this.mTouchHelper = this.getMonthViewTouchHelper();
        ViewCompat.setAccessibilityDelegate((View)this, (AccessibilityDelegateCompat)((AccessibilityDelegateCompat)this.mTouchHelper));
        ViewCompat.setImportantForAccessibility((View)this, (int)1);
        this.mLockAccessibilityDelegate = true;
        this.initView();
    }

    public /* synthetic */ MonthView(Context context, AttributeSet attributeSet, DateRangePickerController dateRangePickerController, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            attributeSet = null;
        }
        if ((n & 4) != 0) {
            dateRangePickerController = null;
        }
        this(context, attributeSet, dateRangePickerController);
    }

    @JvmOverloads
    public MonthView(@NotNull Context context, @Nullable AttributeSet attr) {
        this(context, attr, null, 4, null);
    }

    @JvmOverloads
    public MonthView(@NotNull Context context) {
        this(context, null, null, 6, null);
    }

    static {
        Companion = new Companion(null);
        TAG = TAG;
        VIEW_PARAMS_HEIGHT = VIEW_PARAMS_HEIGHT;
        VIEW_PARAMS_MONTH = VIEW_PARAMS_MONTH;
        VIEW_PARAMS_YEAR = VIEW_PARAMS_YEAR;
        VIEW_PARAMS_SELECTED_DAY = VIEW_PARAMS_SELECTED_DAY;
        VIEW_PARAMS_WEEK_START = VIEW_PARAMS_WEEK_START;
        VIEW_PARAMS_NUM_DAYS = VIEW_PARAMS_NUM_DAYS;
        VIEW_PARAMS_FOCUS_MONTH = VIEW_PARAMS_FOCUS_MONTH;
        VIEW_PARAMS_SHOW_WK_NUM = VIEW_PARAMS_SHOW_WK_NUM;
        DEFAULT_HEIGHT = 32;
        MIN_HEIGHT = 10;
        DEFAULT_SELECTED_DAY = -1;
        DEFAULT_WEEK_START = 1;
        DEFAULT_NUM_DAYS = 7;
        DEFAULT_FOCUS_MONTH = -1;
        DEFAULT_NUM_ROWS = 6;
        MAX_NUM_ROWS = 6;
        SELECTED_CIRCLE_ALPHA = 255;
        DAY_SEPARATOR_WIDTH = 1;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0094\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\tH\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0014J\u0016\u0010\u0016\u001a\u00020\u000b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0018H\u0014J\"\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u000e2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0014J\u0018\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!H\u0014J\u0018\u0010\"\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$H\u0014J\u000e\u0010%\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u000eR\u0016\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/beeline09/daterangepicker/date/MonthView$MonthViewTouchHelper;", "Landroidx/customview/widget/ExploreByTouchHelper;", "host", "Landroid/view/View;", "(Lcom/beeline09/daterangepicker/date/MonthView;Landroid/view/View;)V", "mTempCalendar", "Ljava/util/Calendar;", "kotlin.jvm.PlatformType", "mTempRect", "Landroid/graphics/Rect;", "clearFocusedVirtualView", "", "getItemBounds", "day", "", "rect", "getItemDescription", "", "getVirtualViewAt", "x", "", "y", "getVisibleVirtualViews", "virtualViewIds", "", "onPerformActionForVirtualView", "", "virtualViewId", "action", "arguments", "Landroid/os/Bundle;", "onPopulateEventForVirtualView", "event", "Landroid/view/accessibility/AccessibilityEvent;", "onPopulateNodeForVirtualView", "node", "Landroidx/core/view/accessibility/AccessibilityNodeInfoCompat;", "setFocusedVirtualView", "daterangepicker_release"})
    protected class MonthViewTouchHelper
    extends ExploreByTouchHelper {
        private final Rect mTempRect;
        private final Calendar mTempCalendar;

        public final void setFocusedVirtualView(int virtualViewId) {
            this.getAccessibilityNodeProvider(MonthView.this).performAction(virtualViewId, 64, null);
        }

        public final void clearFocusedVirtualView() {
            int focusedVirtualView = this.getFocusedVirtualView();
            if (focusedVirtualView != Integer.MIN_VALUE) {
                this.getAccessibilityNodeProvider(MonthView.this).performAction(focusedVirtualView, 128, null);
            }
        }

        protected int getVirtualViewAt(float x, float y) {
            int day = MonthView.this.getDayFromLocation(x, y);
            return day >= 0 ? day : Integer.MIN_VALUE;
        }

        /*
         * WARNING - void declaration
         */
        protected void getVisibleVirtualViews(@NotNull List<Integer> virtualViewIds) {
            Intrinsics.checkParameterIsNotNull(virtualViewIds, (String)"virtualViewIds");
            int n = 1;
            int n2 = MonthView.this.getMNumCells();
            if (n <= n2) {
                while (true) {
                    void day;
                    virtualViewIds.add((int)day);
                    if (day == n2) break;
                    ++day;
                }
            }
        }

        protected void onPopulateEventForVirtualView(int virtualViewId, @NotNull AccessibilityEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            event.setContentDescription(this.getItemDescription(virtualViewId));
        }

        protected void onPopulateNodeForVirtualView(int virtualViewId, @NotNull AccessibilityNodeInfoCompat node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            this.getItemBounds(virtualViewId, this.mTempRect);
            node.setContentDescription(this.getItemDescription(virtualViewId));
            node.setBoundsInParent(this.mTempRect);
            node.addAction(16);
            if (virtualViewId == MonthView.this.getMSelectedDay()) {
                node.setSelected(true);
            }
        }

        protected boolean onPerformActionForVirtualView(int virtualViewId, int action, @Nullable Bundle arguments) {
            switch (action) {
                case 16: {
                    MonthView.this.onDayClick(virtualViewId);
                    return true;
                }
            }
            return false;
        }

        protected final void getItemBounds(int day, @NotNull Rect rect) {
            Intrinsics.checkParameterIsNotNull((Object)rect, (String)"rect");
            int offsetX = MonthView.this.getMEdgePadding();
            int offsetY = MonthView.this.getMonthHeaderSize();
            int cellHeight = MonthView.this.getMRowHeight();
            int cellWidth = (MonthView.this.getMWidth() - 2 * MonthView.this.getMEdgePadding()) / MonthView.this.getMNumDays();
            int index = day - 1 + MonthView.this.findDayOffset();
            int row = index / MonthView.this.getMNumDays();
            int column = index % MonthView.this.getMNumDays();
            int x = offsetX + column * cellWidth;
            int y = offsetY + row * cellHeight;
            rect.set(x, y, x + cellWidth, y + cellHeight);
        }

        private final CharSequence getItemDescription(int day) {
            CharSequence charSequence;
            this.mTempCalendar.set(MonthView.this.getYear(), MonthView.this.getMonth(), day);
            CharSequence charSequence2 = "dd MMMM yyyy";
            Calendar calendar = this.mTempCalendar;
            Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"mTempCalendar");
            CharSequence date = DateFormat.format((CharSequence)charSequence2, (long)calendar.getTimeInMillis());
            if (day == MonthView.this.getMSelectedDay()) {
                String string2 = MonthView.this.getContext().getString(R.string.mdtp_item_is_selected, new Object[]{date});
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"context.getString(R.stri\u2026p_item_is_selected, date)");
                charSequence = string2;
            } else {
                CharSequence charSequence3 = date;
                charSequence = charSequence3;
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence3, (String)"date");
            }
            return charSequence;
        }

        public MonthViewTouchHelper(View host) {
            Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
            super(host);
            this.mTempRect = new Rect();
            this.mTempCalendar = Calendar.getInstance();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00a8\u0006\b"}, d2={"Lcom/beeline09/daterangepicker/date/MonthView$OnDayClickListener;", "", "onDayClick", "", "view", "Lcom/beeline09/daterangepicker/date/MonthView;", "day", "Lcom/beeline09/daterangepicker/date/MonthAdapter$CalendarDay;", "daterangepicker_release"})
    public static interface OnDayClickListener {
        public void onDayClick(@Nullable MonthView var1, @Nullable MonthAdapter.CalendarDay var2);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b)\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u0007\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u0014\u0010\f\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0006R\u001a\u0010\u000e\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0006\"\u0004\b\u0010\u0010\bR\u0014\u0010\u0011\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0014\u0010\u0013\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0014\u0010\u0015\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0014\u0010\u0017\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0014\u0010\u0019\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0014\u0010\u001b\u001a\u00020\u0004X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006R\u001a\u0010\u001d\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0006\"\u0004\b\u001f\u0010\bR\u001a\u0010 \u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0006\"\u0004\b\"\u0010\bR\u001a\u0010#\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0006\"\u0004\b%\u0010\bR\u001a\u0010&\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0006\"\u0004\b(\u0010\bR\u001a\u0010)\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0006\"\u0004\b+\u0010\bR\u000e\u0010,\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010/\u001a\u00020.X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0014\u00102\u001a\u00020.X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00101R\u0014\u00104\u001a\u00020.X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00101R\u0014\u00106\u001a\u00020.X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00101R\u0014\u00108\u001a\u00020.X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u00101R\u0014\u0010:\u001a\u00020.X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u00101R\u0014\u0010<\u001a\u00020.X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u00101R\u0014\u0010>\u001a\u00020.X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u00101R\u001a\u0010@\u001a\u00020AX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010E\u00a8\u0006F"}, d2={"Lcom/beeline09/daterangepicker/date/MonthView$Companion;", "", "()V", "DAY_SELECTED_CIRCLE_SIZE", "", "getDAY_SELECTED_CIRCLE_SIZE", "()I", "setDAY_SELECTED_CIRCLE_SIZE", "(I)V", "DAY_SEPARATOR_WIDTH", "getDAY_SEPARATOR_WIDTH", "setDAY_SEPARATOR_WIDTH", "DEFAULT_FOCUS_MONTH", "getDEFAULT_FOCUS_MONTH", "DEFAULT_HEIGHT", "getDEFAULT_HEIGHT", "setDEFAULT_HEIGHT", "DEFAULT_NUM_DAYS", "getDEFAULT_NUM_DAYS", "DEFAULT_NUM_ROWS", "getDEFAULT_NUM_ROWS", "DEFAULT_SELECTED_DAY", "getDEFAULT_SELECTED_DAY", "DEFAULT_SHOW_WK_NUM", "getDEFAULT_SHOW_WK_NUM", "DEFAULT_WEEK_START", "getDEFAULT_WEEK_START", "MAX_NUM_ROWS", "getMAX_NUM_ROWS", "MINI_DAY_NUMBER_TEXT_SIZE", "getMINI_DAY_NUMBER_TEXT_SIZE", "setMINI_DAY_NUMBER_TEXT_SIZE", "MIN_HEIGHT", "getMIN_HEIGHT", "setMIN_HEIGHT", "MONTH_DAY_LABEL_TEXT_SIZE", "getMONTH_DAY_LABEL_TEXT_SIZE", "setMONTH_DAY_LABEL_TEXT_SIZE", "MONTH_HEADER_SIZE", "getMONTH_HEADER_SIZE", "setMONTH_HEADER_SIZE", "MONTH_LABEL_TEXT_SIZE", "getMONTH_LABEL_TEXT_SIZE", "setMONTH_LABEL_TEXT_SIZE", "SELECTED_CIRCLE_ALPHA", "TAG", "", "VIEW_PARAMS_FOCUS_MONTH", "getVIEW_PARAMS_FOCUS_MONTH", "()Ljava/lang/String;", "VIEW_PARAMS_HEIGHT", "getVIEW_PARAMS_HEIGHT", "VIEW_PARAMS_MONTH", "getVIEW_PARAMS_MONTH", "VIEW_PARAMS_NUM_DAYS", "getVIEW_PARAMS_NUM_DAYS", "VIEW_PARAMS_SELECTED_DAY", "getVIEW_PARAMS_SELECTED_DAY", "VIEW_PARAMS_SHOW_WK_NUM", "getVIEW_PARAMS_SHOW_WK_NUM", "VIEW_PARAMS_WEEK_START", "getVIEW_PARAMS_WEEK_START", "VIEW_PARAMS_YEAR", "getVIEW_PARAMS_YEAR", "mScale", "", "getMScale", "()F", "setMScale", "(F)V", "daterangepicker_release"})
    public static final class Companion {
        @NotNull
        public final String getVIEW_PARAMS_HEIGHT() {
            return VIEW_PARAMS_HEIGHT;
        }

        @NotNull
        public final String getVIEW_PARAMS_MONTH() {
            return VIEW_PARAMS_MONTH;
        }

        @NotNull
        public final String getVIEW_PARAMS_YEAR() {
            return VIEW_PARAMS_YEAR;
        }

        @NotNull
        public final String getVIEW_PARAMS_SELECTED_DAY() {
            return VIEW_PARAMS_SELECTED_DAY;
        }

        @NotNull
        public final String getVIEW_PARAMS_WEEK_START() {
            return VIEW_PARAMS_WEEK_START;
        }

        @NotNull
        public final String getVIEW_PARAMS_NUM_DAYS() {
            return VIEW_PARAMS_NUM_DAYS;
        }

        @NotNull
        public final String getVIEW_PARAMS_FOCUS_MONTH() {
            return VIEW_PARAMS_FOCUS_MONTH;
        }

        @NotNull
        public final String getVIEW_PARAMS_SHOW_WK_NUM() {
            return VIEW_PARAMS_SHOW_WK_NUM;
        }

        protected final int getDEFAULT_HEIGHT() {
            return DEFAULT_HEIGHT;
        }

        protected final void setDEFAULT_HEIGHT(int n) {
            DEFAULT_HEIGHT = n;
        }

        protected final int getMIN_HEIGHT() {
            return MIN_HEIGHT;
        }

        protected final void setMIN_HEIGHT(int n) {
            MIN_HEIGHT = n;
        }

        protected final int getDEFAULT_SELECTED_DAY() {
            return DEFAULT_SELECTED_DAY;
        }

        protected final int getDEFAULT_WEEK_START() {
            return DEFAULT_WEEK_START;
        }

        protected final int getDEFAULT_NUM_DAYS() {
            return DEFAULT_NUM_DAYS;
        }

        protected final int getDEFAULT_SHOW_WK_NUM() {
            return DEFAULT_SHOW_WK_NUM;
        }

        protected final int getDEFAULT_FOCUS_MONTH() {
            return DEFAULT_FOCUS_MONTH;
        }

        protected final int getDEFAULT_NUM_ROWS() {
            return DEFAULT_NUM_ROWS;
        }

        protected final int getMAX_NUM_ROWS() {
            return MAX_NUM_ROWS;
        }

        protected final int getDAY_SEPARATOR_WIDTH() {
            return DAY_SEPARATOR_WIDTH;
        }

        protected final void setDAY_SEPARATOR_WIDTH(int n) {
            DAY_SEPARATOR_WIDTH = n;
        }

        public final int getMINI_DAY_NUMBER_TEXT_SIZE() {
            return MINI_DAY_NUMBER_TEXT_SIZE;
        }

        public final void setMINI_DAY_NUMBER_TEXT_SIZE(int n) {
            MINI_DAY_NUMBER_TEXT_SIZE = n;
        }

        protected final int getMONTH_LABEL_TEXT_SIZE() {
            return MONTH_LABEL_TEXT_SIZE;
        }

        protected final void setMONTH_LABEL_TEXT_SIZE(int n) {
            MONTH_LABEL_TEXT_SIZE = n;
        }

        protected final int getMONTH_DAY_LABEL_TEXT_SIZE() {
            return MONTH_DAY_LABEL_TEXT_SIZE;
        }

        protected final void setMONTH_DAY_LABEL_TEXT_SIZE(int n) {
            MONTH_DAY_LABEL_TEXT_SIZE = n;
        }

        protected final int getMONTH_HEADER_SIZE() {
            return MONTH_HEADER_SIZE;
        }

        protected final void setMONTH_HEADER_SIZE(int n) {
            MONTH_HEADER_SIZE = n;
        }

        public final int getDAY_SELECTED_CIRCLE_SIZE() {
            return DAY_SELECTED_CIRCLE_SIZE;
        }

        public final void setDAY_SELECTED_CIRCLE_SIZE(int n) {
            DAY_SELECTED_CIRCLE_SIZE = n;
        }

        protected final float getMScale() {
            return mScale;
        }

        protected final void setMScale(float f) {
            mScale = f;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

