/*
 * Decompiled with CFR 0.152.
 */
package com.beeline09.daterangepicker;

import android.animation.Keyframe;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Color;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.appcompat.widget.AppCompatTextView;
import com.google.android.material.textview.MaterialTextView;
import java.util.Calendar;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/beeline09/daterangepicker/Utils;", "", "()V", "Companion", "daterangepicker_release"})
public final class Utils {
    private static final int PULSE_ANIMATOR_DURATION = 544;
    private static final int SELECTED_ALPHA = 255;
    private static final int SELECTED_ALPHA_THEME_DARK = 255;
    private static final int FULL_ALPHA = 255;
    public static final Companion Companion = new Companion(null);

    static {
        PULSE_ANIMATOR_DURATION = 544;
        SELECTED_ALPHA = 255;
        SELECTED_ALPHA_THEME_DARK = 255;
        FULL_ALPHA = 255;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\r\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004J\u0016\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014J\u0016\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001dJ \u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u0018J-\u0010$\u001a\u00020%2\b\u0010&\u001a\u0004\u0018\u00010'2\u0016\u0010(\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010)\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010*J\u001c\u0010+\u001a\u00020%2\b\u0010,\u001a\u0004\u0018\u00010!2\b\u0010-\u001a\u0004\u0018\u00010.H\u0007R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000f\u00a8\u0006/"}, d2={"Lcom/beeline09/daterangepicker/Utils$Companion;", "", "()V", "FULL_ALPHA", "", "getFULL_ALPHA", "()I", "PULSE_ANIMATOR_DURATION", "getPULSE_ANIMATOR_DURATION", "SELECTED_ALPHA", "getSELECTED_ALPHA", "SELECTED_ALPHA_THEME_DARK", "getSELECTED_ALPHA_THEME_DARK", "isJellybeanOrLater", "", "()Z", "darkenColor", "color", "daysBetween", "startDate", "Ljava/util/Calendar;", "endDate", "dpToPx", "dp", "", "resources", "Landroid/content/res/Resources;", "getAccentColorFromThemeIfAvailable", "context", "Landroid/content/Context;", "getPulseAnimator", "Landroid/animation/ObjectAnimator;", "labelToAnimate", "Landroid/view/View;", "decreaseRatio", "increaseRatio", "setMultiTextColorList", "", "colorStateList", "Landroid/content/res/ColorStateList;", "textViews", "", "(Landroid/content/res/ColorStateList;[Ljava/lang/Object;)V", "tryAccessibilityAnnounce", "view", "text", "", "daterangepicker_release"})
    public static final class Companion {
        public final int getPULSE_ANIMATOR_DURATION() {
            return PULSE_ANIMATOR_DURATION;
        }

        public final int getSELECTED_ALPHA() {
            return SELECTED_ALPHA;
        }

        public final int getSELECTED_ALPHA_THEME_DARK() {
            return SELECTED_ALPHA_THEME_DARK;
        }

        public final int getFULL_ALPHA() {
            return FULL_ALPHA;
        }

        public final boolean isJellybeanOrLater() {
            return Build.VERSION.SDK_INT >= 16;
        }

        @SuppressLint(value={"NewApi"})
        public final void tryAccessibilityAnnounce(@Nullable View view, @Nullable CharSequence text) {
            if (this.isJellybeanOrLater() && view != null && text != null) {
                view.announceForAccessibility(text);
            }
        }

        @NotNull
        public final ObjectAnimator getPulseAnimator(@Nullable View labelToAnimate, float decreaseRatio, float increaseRatio) {
            Keyframe k0 = Keyframe.ofFloat((float)0.0f, (float)1.0f);
            Keyframe k1 = Keyframe.ofFloat((float)0.275f, (float)decreaseRatio);
            Keyframe k2 = Keyframe.ofFloat((float)0.69f, (float)increaseRatio);
            Keyframe k3 = Keyframe.ofFloat((float)1.0f, (float)1.0f);
            PropertyValuesHolder scaleX = PropertyValuesHolder.ofKeyframe((String)"scaleX", (Keyframe[])new Keyframe[]{k0, k1, k2, k3});
            PropertyValuesHolder scaleY = PropertyValuesHolder.ofKeyframe((String)"scaleY", (Keyframe[])new Keyframe[]{k0, k1, k2, k3});
            ObjectAnimator objectAnimator = ObjectAnimator.ofPropertyValuesHolder((Object)labelToAnimate, (PropertyValuesHolder[])new PropertyValuesHolder[]{scaleX, scaleY});
            Intrinsics.checkExpressionValueIsNotNull((Object)objectAnimator, (String)"ObjectAnimator.ofPropert\u2026oAnimate, scaleX, scaleY)");
            ObjectAnimator pulseAnimator = objectAnimator;
            pulseAnimator.setDuration((long)this.getPULSE_ANIMATOR_DURATION());
            return pulseAnimator;
        }

        public final int dpToPx(float dp, @NotNull Resources resources) {
            Intrinsics.checkParameterIsNotNull((Object)resources, (String)"resources");
            float px = TypedValue.applyDimension((int)1, (float)dp, (DisplayMetrics)resources.getDisplayMetrics());
            return (int)px;
        }

        public final int darkenColor(int color2) {
            float[] hsv = new float[3];
            Color.colorToHSV((int)color2, (float[])hsv);
            hsv[2] = hsv[2] * 0.8f;
            return Color.HSVToColor((float[])hsv);
        }

        public final int getAccentColorFromThemeIfAvailable(@NotNull Context context) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            TypedValue typedValue = new TypedValue();
            if (Build.VERSION.SDK_INT >= 21) {
                context.getTheme().resolveAttribute(16843829, typedValue, true);
                return typedValue.data;
            }
            int colorAccentResId = context.getResources().getIdentifier("colorAccent", "attr", context.getPackageName());
            if (colorAccentResId == 0) {
                return -1;
            }
            return !context.getTheme().resolveAttribute(colorAccentResId, typedValue, true) ? -1 : typedValue.data;
        }

        public final int daysBetween(@NotNull Calendar startDate, @NotNull Calendar endDate) {
            Intrinsics.checkParameterIsNotNull((Object)startDate, (String)"startDate");
            Intrinsics.checkParameterIsNotNull((Object)endDate, (String)"endDate");
            int MILLIS_IN_DAY = 86400000;
            long endInstant = endDate.getTimeInMillis();
            return (int)((endInstant - startDate.getTimeInMillis()) / (long)MILLIS_IN_DAY);
        }

        public final void setMultiTextColorList(@Nullable ColorStateList colorStateList, Object ... textViews) {
            Intrinsics.checkParameterIsNotNull((Object)textViews, (String)"textViews");
            for (Object textView : textViews) {
                Object object = textView;
                if (object instanceof MaterialTextView) {
                    ((MaterialTextView)textView).setTextColor(colorStateList);
                    continue;
                }
                if (object instanceof TextView) {
                    ((TextView)textView).setTextColor(colorStateList);
                    continue;
                }
                if (object instanceof AppCompatTextView) {
                    ((AppCompatTextView)textView).setTextColor(colorStateList);
                    continue;
                }
                if (object instanceof EditText) {
                    ((EditText)textView).setTextColor(colorStateList);
                    continue;
                }
                if (!(object instanceof AppCompatEditText)) continue;
                ((AppCompatEditText)textView).setTextColor(colorStateList);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

