/*
 * Decompiled with CFR 0.152.
 */
package com.beeline09.daterangepicker.date;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.beeline09.daterangepicker.R;
import com.beeline09.daterangepicker.date.SmoothDateRangePickerController;
import com.beeline09.daterangepicker.date.SmoothDateRangePickerFragment;
import com.beeline09.daterangepicker.date.TextViewWithCircularIndicator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\t\b\u0007\u0018\u0000 (2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002()B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J,\u0010\u001a\u001a\u00020\u00152\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010 \u001a\u00020!H\u0016J\u000e\u0010\"\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\nJ\u0016\u0010#\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\n2\u0006\u0010$\u001a\u00020\nJ\u0006\u0010%\u001a\u00020\u0015J\u000e\u0010&\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\nR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0018\u00010\u000fR\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/beeline09/daterangepicker/date/YearPickerView;", "Landroid/widget/ListView;", "Landroid/widget/AdapterView$OnItemClickListener;", "Lcom/beeline09/daterangepicker/date/SmoothDateRangePickerFragment$OnDateChangedListener;", "context", "Landroid/content/Context;", "mController", "Lcom/beeline09/daterangepicker/date/SmoothDateRangePickerController;", "(Landroid/content/Context;Lcom/beeline09/daterangepicker/date/SmoothDateRangePickerController;)V", "firstPositionOffset", "", "getFirstPositionOffset", "()I", "mAccentColor", "mAdapter", "Lcom/beeline09/daterangepicker/date/YearPickerView$YearAdapter;", "mChildSize", "mSelectedView", "Lcom/beeline09/daterangepicker/date/TextViewWithCircularIndicator;", "mViewSize", "init", "", "onDateChanged", "onInitializeAccessibilityEvent", "event", "Landroid/view/accessibility/AccessibilityEvent;", "onItemClick", "parent", "Landroid/widget/AdapterView;", "view", "Landroid/view/View;", "position", "id", "", "postSetSelectionCentered", "postSetSelectionFromTop", "offset", "refreshYearAdapter", "setAccentColor", "accentColor", "Companion", "YearAdapter", "daterangepicker_release"})
@SuppressLint(value={"ViewConstructor"})
public final class YearPickerView
extends ListView
implements AdapterView.OnItemClickListener,
SmoothDateRangePickerFragment.OnDateChangedListener {
    private YearAdapter mAdapter;
    private final int mViewSize;
    private final int mChildSize;
    private TextViewWithCircularIndicator mSelectedView;
    private int mAccentColor;
    private final SmoothDateRangePickerController mController;
    private static final String TAG = "YearPickerView";
    public static final Companion Companion = new Companion(null);
    private HashMap _$_findViewCache;

    public final int getFirstPositionOffset() {
        View view = this.getChildAt(0);
        if (view == null) {
            return 0;
        }
        View firstChild = view;
        return firstChild.getTop();
    }

    /*
     * WARNING - void declaration
     */
    private final void init(Context context) {
        int n;
        ArrayList<String> years = new ArrayList<String>();
        int n2 = this.mController.getMinSelectableYear();
        if (n2 <= (n = this.mController.getMaxYear())) {
            while (true) {
                String string2;
                Locale locale;
                void year;
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                Intrinsics.checkExpressionValueIsNotNull((Object)Locale.getDefault(), (String)"Locale.getDefault()");
                String string3 = "%d";
                Object[] objectArray = new Object[]{(int)year};
                ArrayList<String> arrayList = years;
                boolean bl = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)String.format(locale, string3, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(locale, format, *args)");
                arrayList.add(string2);
                if (year == n) break;
                ++year;
            }
        }
        this.mAdapter = new YearAdapter(context, R.layout.sdrp_year_label_text_view, (List<String>)years);
        this.setAdapter((ListAdapter)this.mAdapter);
    }

    public final void setAccentColor(int accentColor) {
        this.mAccentColor = accentColor;
    }

    public void onItemClick(@NotNull AdapterView<?> parent, @NotNull View view, int position, long id2) {
        Intrinsics.checkParameterIsNotNull(parent, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        this.mController.tryVibrate();
        TextViewWithCircularIndicator clickedView = (TextViewWithCircularIndicator)view;
        if (clickedView != this.mSelectedView) {
            if (this.mSelectedView != null) {
                TextViewWithCircularIndicator textViewWithCircularIndicator = this.mSelectedView;
                if (textViewWithCircularIndicator == null) {
                    Intrinsics.throwNpe();
                }
                textViewWithCircularIndicator.drawIndicator(false);
                TextViewWithCircularIndicator textViewWithCircularIndicator2 = this.mSelectedView;
                if (textViewWithCircularIndicator2 == null) {
                    Intrinsics.throwNpe();
                }
                textViewWithCircularIndicator2.requestLayout();
            }
            clickedView.drawIndicator(true);
            clickedView.requestLayout();
            this.mSelectedView = clickedView;
        }
        this.mController.onYearSelected(YearPickerView.Companion.getYearFromTextView((TextView)clickedView));
        YearAdapter yearAdapter = this.mAdapter;
        if (yearAdapter == null) {
            Intrinsics.throwNpe();
        }
        yearAdapter.notifyDataSetChanged();
    }

    public final void postSetSelectionCentered(int position) {
        this.postSetSelectionFromTop(position, this.mViewSize / 2 - this.mChildSize / 2);
    }

    public final void postSetSelectionFromTop(int position, int offset) {
        this.post(new Runnable(this, position, offset){
            final /* synthetic */ YearPickerView this$0;
            final /* synthetic */ int $position;
            final /* synthetic */ int $offset;

            public final void run() {
                this.this$0.setSelectionFromTop(this.$position, this.$offset);
                this.this$0.requestLayout();
            }
            {
                this.this$0 = yearPickerView;
                this.$position = n;
                this.$offset = n2;
            }
        });
    }

    @Override
    public void onDateChanged() {
        YearAdapter yearAdapter = this.mAdapter;
        if (yearAdapter == null) {
            Intrinsics.throwNpe();
        }
        yearAdapter.notifyDataSetChanged();
        this.postSetSelectionCentered(this.mController.getSelectedDay().getYear() - this.mController.getMinSelectableYear());
    }

    public void onInitializeAccessibilityEvent(@NotNull AccessibilityEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        super.onInitializeAccessibilityEvent(event);
        if (event.getEventType() == 4096) {
            event.setFromIndex(0);
            event.setToIndex(0);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void refreshYearAdapter() {
        YearAdapter yearAdapter = this.mAdapter;
        if (yearAdapter == null) {
            Intrinsics.throwNpe();
        }
        yearAdapter.clear();
        int n = this.mController.getMinSelectableYear();
        int n2 = this.mController.getMaxYear();
        if (n <= n2) {
            while (true) {
                String string2;
                YearAdapter yearAdapter2;
                Locale locale;
                void year;
                if (this.mAdapter == null) {
                    Intrinsics.throwNpe();
                }
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                Intrinsics.checkExpressionValueIsNotNull((Object)Locale.getDefault(), (String)"Locale.getDefault()");
                String string3 = "%d";
                Object[] objectArray = new Object[]{(int)year};
                boolean bl = false;
                Intrinsics.checkExpressionValueIsNotNull((Object)String.format(locale, string3, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(locale, format, *args)");
                yearAdapter2.add(string2);
                if (year == n2) break;
                ++year;
            }
        }
        YearAdapter yearAdapter3 = this.mAdapter;
        if (yearAdapter3 == null) {
            Intrinsics.throwNpe();
        }
        yearAdapter3.notifyDataSetChanged();
    }

    public YearPickerView(@NotNull Context context, @NotNull SmoothDateRangePickerController mController) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)mController, (String)"mController");
        super(context);
        this.mController = mController;
        this.mController.registerOnDateChangedListener(this);
        ViewGroup.LayoutParams frame = new ViewGroup.LayoutParams(-1, -2);
        this.setLayoutParams(frame);
        Resources res = context.getResources();
        this.mViewSize = res.getDimensionPixelOffset(R.dimen.mdtp_date_picker_view_animator_height);
        this.mChildSize = res.getDimensionPixelOffset(R.dimen.mdtp_year_label_height);
        this.setVerticalFadingEdgeEnabled(true);
        this.setFadingEdgeLength(this.mChildSize / 3);
        this.init(context);
        this.setOnItemClickListener(this);
        this.setSelector((Drawable)new StateListDrawable());
        this.setDividerHeight(0);
        this.onDateChanged();
    }

    static {
        TAG = TAG;
    }

    public static final /* synthetic */ void access$setMAccentColor$p(YearPickerView $this, int n) {
        $this.mAccentColor = n;
    }

    public static final /* synthetic */ TextViewWithCircularIndicator access$getMSelectedView$p(YearPickerView $this) {
        return $this.mSelectedView;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\b\u00a2\u0006\u0002\u0010\tJ\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/beeline09/daterangepicker/date/YearPickerView$YearAdapter;", "Landroid/widget/ArrayAdapter;", "", "context", "Landroid/content/Context;", "resource", "", "objects", "", "(Lcom/beeline09/daterangepicker/date/YearPickerView;Landroid/content/Context;ILjava/util/List;)V", "getView", "Landroid/view/View;", "position", "convertView", "parent", "Landroid/view/ViewGroup;", "daterangepicker_release"})
    private final class YearAdapter
    extends ArrayAdapter<String> {
        @NotNull
        public View getView(int position, @Nullable View convertView, @NotNull ViewGroup parent) {
            Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
            View view = super.getView(position, convertView, parent);
            if (view == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.beeline09.daterangepicker.date.TextViewWithCircularIndicator");
            }
            TextViewWithCircularIndicator v = (TextViewWithCircularIndicator)view;
            v.setAccentColor(YearPickerView.this.mAccentColor, YearPickerView.this.mController.isThemeDark());
            v.requestLayout();
            int year = Companion.getYearFromTextView((TextView)v);
            boolean selected = YearPickerView.this.mController.getSelectedDay().getYear() == year;
            v.drawIndicator(selected);
            if (selected) {
                YearPickerView.this.mSelectedView = v;
            }
            return (View)v;
        }

        public YearAdapter(Context context, @NotNull int resource, List<String> objects) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull(objects, (String)"objects");
            super(context, resource, objects);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/beeline09/daterangepicker/date/YearPickerView$Companion;", "", "()V", "TAG", "", "getYearFromTextView", "", "view", "Landroid/widget/TextView;", "daterangepicker_release"})
    public static final class Companion {
        private final int getYearFromTextView(TextView view) {
            return Integer.parseInt(((Object)view.getText()).toString());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

