/*
 * Decompiled with CFR 0.152.
 */
package com.zdf.activitylauncher;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.Intent;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import com.zdf.activitylauncher.RouterFragment;
import com.zdf.activitylauncher.RouterFragmentV4;

public class ActivityLauncher {
    private static final String TAG = "ActivityLauncher";
    private Context mContext;
    private RouterFragmentV4 mRouterFragmentV4;
    private RouterFragment mRouterFragment;

    public static ActivityLauncher init(android.support.v4.app.Fragment fragment) {
        return ActivityLauncher.init(fragment.getActivity());
    }

    public static ActivityLauncher init(FragmentActivity activity) {
        return new ActivityLauncher(activity);
    }

    public static ActivityLauncher init(Activity activity) {
        return new ActivityLauncher(activity);
    }

    private ActivityLauncher(FragmentActivity activity) {
        this.mContext = activity;
        this.mRouterFragmentV4 = this.getRouterFragmentV4(activity);
    }

    private ActivityLauncher(Activity activity) {
        this.mContext = activity;
        this.mRouterFragment = this.getRouterFragment(activity);
    }

    private RouterFragmentV4 getRouterFragmentV4(FragmentActivity activity) {
        RouterFragmentV4 routerFragment = this.findRouterFragmentV4(activity);
        if (routerFragment == null) {
            routerFragment = RouterFragmentV4.newInstance();
            FragmentManager fragmentManager = activity.getSupportFragmentManager();
            fragmentManager.beginTransaction().add((android.support.v4.app.Fragment)routerFragment, TAG).commitAllowingStateLoss();
            fragmentManager.executePendingTransactions();
        }
        return routerFragment;
    }

    private RouterFragmentV4 findRouterFragmentV4(FragmentActivity activity) {
        return (RouterFragmentV4)activity.getSupportFragmentManager().findFragmentByTag(TAG);
    }

    private RouterFragment getRouterFragment(Activity activity) {
        RouterFragment routerFragment = this.findRouterFragment(activity);
        if (routerFragment == null) {
            routerFragment = RouterFragment.newInstance();
            android.app.FragmentManager fragmentManager = activity.getFragmentManager();
            fragmentManager.beginTransaction().add((Fragment)routerFragment, TAG).commitAllowingStateLoss();
            fragmentManager.executePendingTransactions();
        }
        return routerFragment;
    }

    private RouterFragment findRouterFragment(Activity activity) {
        return (RouterFragment)activity.getFragmentManager().findFragmentByTag(TAG);
    }

    public void startActivityForResult(Class<?> clazz, Callback callback) {
        Intent intent = new Intent(this.mContext, clazz);
        this.startActivityForResult(intent, callback);
    }

    public void startActivityForResult(Intent intent, Callback callback) {
        if (this.mRouterFragmentV4 != null) {
            this.mRouterFragmentV4.startActivityForResult(intent, callback);
        } else if (this.mRouterFragment != null) {
            this.mRouterFragment.startActivityForResult(intent, callback);
        } else {
            throw new RuntimeException("please do init first!");
        }
    }

    public static interface Callback {
        public void onActivityResult(int var1, Intent var2);
    }
}

