/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javasocksproxyserver;

import java.io.IOException;
import java.net.ConnectException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Utils {
    private static final Logger LOGGER = LoggerFactory.getLogger(Utils.class);

    @Nullable
    public static InetAddress calcInetAddress(byte[] addr) {
        InetAddress IA;
        StringBuilder sIA = new StringBuilder();
        if (addr.length < 4) {
            LOGGER.error("calcInetAddress() - Invalid length of IP v4 - " + addr.length + " bytes");
            return null;
        }
        for (int i = 0; i < 4; ++i) {
            sIA.append(Utils.byte2int(addr[i]));
            if (i >= 3) continue;
            sIA.append(".");
        }
        try {
            IA = InetAddress.getByName(sIA.toString());
        }
        catch (UnknownHostException e) {
            return null;
        }
        return IA;
    }

    public static int byte2int(byte b) {
        return b < 0 ? 256 + b : b;
    }

    public static int calcPort(byte Hi, byte Lo) {
        return Utils.byte2int(Hi) << 8 | Utils.byte2int(Lo);
    }

    @NotNull
    public static String iP2Str(InetAddress IP) {
        return IP == null ? "NA/NA" : String.format("%s/%s", IP.getHostName(), IP.getHostAddress());
    }

    @NotNull
    public static String getSocketInfo(Socket sock) {
        return sock == null ? "<NA/NA:0>" : String.format("<%s:%d>", Utils.iP2Str(sock.getInetAddress()), sock.getPort());
    }

    @NotNull
    public static String getSocketInfo(DatagramPacket DGP) {
        return DGP == null ? "<NA/NA:0>" : String.format("<%s:%d>", Utils.iP2Str(DGP.getAddress()), DGP.getPort());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getFreePort() {
        try (ServerSocket serverSocket = new ServerSocket(0);){
            int n = serverSocket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isLocalPortAvailableToConnect(int port) {
        try (Socket ignored = new Socket("localhost", port);){
            boolean bl = true;
            return bl;
        }
        catch (ConnectException e) {
            return false;
        }
        catch (IOException e) {
            throw new IllegalStateException("Error while trying to check open port", e);
        }
    }
}

