/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.javasocksproxyserver;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.annotation.Nullable;
import org.bbottema.javasocksproxyserver.ProxyHandler;
import org.bbottema.javasocksproxyserver.Socks4Impl;
import org.bbottema.javasocksproxyserver.Utils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Socks5Impl
extends Socks4Impl {
    private static final int[] ADDR_Size = new int[]{-1, 4, -1, -1, 16};
    private static final Logger LOGGER = LoggerFactory.getLogger(Socks5Impl.class);
    private static final byte[] SRE_REFUSE = new byte[]{5, -1};
    private static final byte[] SRE_ACCEPT = new byte[]{5, 0};
    private static final int MAX_ADDR_LEN = 255;
    private byte ADDRESS_TYPE;
    private DatagramSocket DGSocket = null;
    private DatagramPacket DGPack = null;
    private InetAddress UDP_IA = null;
    private int UDP_port = 0;

    Socks5Impl(ProxyHandler Parent) {
        super(Parent);
        this.DST_Addr = new byte[255];
    }

    @Override
    public byte getSuccessCode() {
        return 0;
    }

    @Override
    public byte getFailCode() {
        return 4;
    }

    @Nullable
    public InetAddress calcInetAddress(byte AType, byte[] addr) {
        InetAddress IA;
        switch (AType) {
            case 1: {
                IA = Utils.calcInetAddress(addr);
                break;
            }
            case 3: {
                if (addr[0] <= 0) {
                    LOGGER.error("SOCKS 5 - calcInetAddress() : BAD IP in command - size : " + addr[0]);
                    return null;
                }
                StringBuilder sIA = new StringBuilder();
                for (int i = 1; i <= addr[0]; ++i) {
                    sIA.append((char)addr[i]);
                }
                try {
                    IA = InetAddress.getByName(sIA.toString());
                    break;
                }
                catch (UnknownHostException e) {
                    return null;
                }
            }
            default: {
                return null;
            }
        }
        return IA;
    }

    @Override
    public boolean isInvalidAddress() {
        this.m_ServerIP = this.calcInetAddress(this.ADDRESS_TYPE, this.DST_Addr);
        this.m_nServerPort = Utils.calcPort(this.DST_Port[0], this.DST_Port[1]);
        this.m_ClientIP = this.m_Parent.m_ClientSocket.getInetAddress();
        this.m_nClientPort = this.m_Parent.m_ClientSocket.getPort();
        return this.m_ServerIP == null || this.m_nServerPort < 0;
    }

    @Override
    public void authenticate(byte SOCKS_Ver) throws Exception {
        super.authenticate(SOCKS_Ver);
        if (this.SOCKS_Version == 5) {
            if (!this.checkAuthentication()) {
                this.refuseAuthentication("SOCKS 5 - Not Supported Authentication!");
                throw new Exception("SOCKS 5 - Not Supported Authentication.");
            }
        } else {
            this.refuseAuthentication("Incorrect SOCKS version : " + this.SOCKS_Version);
            throw new Exception("Not Supported SOCKS Version -'" + this.SOCKS_Version + "'");
        }
        this.acceptAuthentication();
    }

    public void refuseAuthentication(String msg) {
        LOGGER.debug("SOCKS 5 - Refuse Authentication: '" + msg + "'");
        this.m_Parent.sendToClient(SRE_REFUSE);
    }

    public void acceptAuthentication() {
        LOGGER.debug("SOCKS 5 - Accepts Auth. method 'NO_AUTH'");
        byte[] tSRE_Accept = SRE_ACCEPT;
        tSRE_Accept[0] = this.SOCKS_Version;
        this.m_Parent.sendToClient(tSRE_Accept);
    }

    public boolean checkAuthentication() {
        int Methods_Num = this.getByte();
        StringBuilder Methods = new StringBuilder();
        for (int i = 0; i < Methods_Num; ++i) {
            Methods.append(",-").append(this.getByte()).append('-');
        }
        return Methods.indexOf("-0-") != -1 || Methods.indexOf("-00-") != -1;
    }

    @Override
    public void getClientCommand() throws Exception {
        this.SOCKS_Version = this.getByte();
        this.socksCommand = this.getByte();
        this.getByte();
        this.ADDRESS_TYPE = this.getByte();
        int Addr_Len = ADDR_Size[this.ADDRESS_TYPE];
        this.DST_Addr[0] = this.getByte();
        if (this.ADDRESS_TYPE == 3) {
            Addr_Len = this.DST_Addr[0] + 1;
        }
        for (int i = 1; i < Addr_Len; ++i) {
            this.DST_Addr[i] = this.getByte();
        }
        this.DST_Port[0] = this.getByte();
        this.DST_Port[1] = this.getByte();
        if (this.SOCKS_Version != 5) {
            LOGGER.debug("SOCKS 5 - Incorrect SOCKS Version of Command: " + this.SOCKS_Version);
            this.refuseCommand((byte)-1);
            throw new Exception("Incorrect SOCKS Version of Command: " + this.SOCKS_Version);
        }
        if (this.socksCommand < 1 || this.socksCommand > 3) {
            LOGGER.error("SOCKS 5 - GetClientCommand() - Unsupported Command : \"" + this.commName(this.socksCommand) + "\"");
            this.refuseCommand((byte)7);
            throw new Exception("SOCKS 5 - Unsupported Command: \"" + this.socksCommand + "\"");
        }
        if (this.ADDRESS_TYPE == 4) {
            LOGGER.error("SOCKS 5 - GetClientCommand() - Unsupported Address Type - IP v6");
            this.refuseCommand((byte)8);
            throw new Exception("Unsupported Address Type - IP v6");
        }
        if (this.ADDRESS_TYPE >= 4 || this.ADDRESS_TYPE <= 0) {
            LOGGER.error("SOCKS 5 - GetClientCommand() - Unsupported Address Type: " + this.ADDRESS_TYPE);
            this.refuseCommand((byte)8);
            throw new Exception("SOCKS 5 - Unsupported Address Type: " + this.ADDRESS_TYPE);
        }
        if (this.isInvalidAddress()) {
            this.refuseCommand((byte)4);
            throw new Exception("SOCKS 5 - Unknown Host/IP address '" + this.m_ServerIP.toString() + "'");
        }
        LOGGER.debug("SOCKS 5 - Accepted SOCKS5 Command: \"" + this.commName(this.socksCommand) + "\"");
    }

    @Override
    public void replyCommand(byte replyCode) {
        int pt;
        LOGGER.debug("SOCKS 5 - Reply to Client \"" + this.replyName(replyCode) + "\"");
        byte[] REPLY = new byte[10];
        byte[] IP = new byte[4];
        if (this.m_Parent.m_ServerSocket != null) {
            pt = this.m_Parent.m_ServerSocket.getLocalPort();
        } else {
            IP[0] = 0;
            IP[1] = 0;
            IP[2] = 0;
            IP[3] = 0;
            pt = 0;
        }
        this.formGenericReply(replyCode, pt, REPLY, IP);
        this.m_Parent.sendToClient(REPLY);
    }

    @Override
    public void bindReply(byte replyCode, InetAddress IA, int PT) {
        byte[] IP = new byte[]{0, 0, 0, 0};
        LOGGER.debug("BIND Reply to Client \"" + this.replyName(replyCode) + "\"");
        byte[] REPLY = new byte[10];
        if (IA != null) {
            IP = IA.getAddress();
        }
        this.formGenericReply((byte)(replyCode - 90), PT, REPLY, IP);
        if (this.m_Parent.isActive()) {
            this.m_Parent.sendToClient(REPLY);
        } else {
            LOGGER.debug("BIND - Closed Client Connection");
        }
    }

    public void udpReply(byte replyCode, InetAddress IA, int pt) {
        LOGGER.debug("Reply to Client \"" + this.replyName(replyCode) + "\"");
        if (this.m_Parent.m_ClientSocket == null) {
            LOGGER.debug("Error in UDP_Reply() - Client socket is NULL");
        }
        byte[] IP = IA.getAddress();
        byte[] REPLY = new byte[10];
        this.formGenericReply(replyCode, pt, REPLY, IP);
        this.m_Parent.sendToClient(REPLY);
    }

    private void formGenericReply(byte replyCode, int pt, byte[] REPLY, byte[] IP) {
        REPLY[0] = 5;
        REPLY[1] = replyCode;
        REPLY[2] = 0;
        REPLY[3] = 1;
        REPLY[4] = IP[0];
        REPLY[5] = IP[1];
        REPLY[6] = IP[2];
        REPLY[7] = IP[3];
        REPLY[8] = (byte)((pt & 0xFF00) >> 8);
        REPLY[9] = (byte)(pt & 0xFF);
    }

    @Override
    public void udp() throws IOException {
        try {
            this.DGSocket = new DatagramSocket();
            this.initUdpInOut();
        }
        catch (IOException e) {
            this.refuseCommand((byte)5);
            throw new IOException("Connection Refused - FAILED TO INITIALIZE UDP Association.");
        }
        InetAddress MyIP = this.m_Parent.m_ClientSocket.getLocalAddress();
        int MyPort = this.DGSocket.getLocalPort();
        this.udpReply((byte)0, MyIP, MyPort);
        LOGGER.debug("UDP Listen at: <" + MyIP.toString() + ":" + MyPort + ">");
        while (this.m_Parent.checkClientData() >= 0) {
            this.processUdp();
            Thread.yield();
        }
        LOGGER.debug("UDP - Closed TCP Master of UDP Association");
    }

    private void initUdpInOut() throws IOException {
        this.DGSocket.setSoTimeout(10);
        this.m_Parent.m_Buffer = new byte[4096];
        this.DGPack = new DatagramPacket(this.m_Parent.m_Buffer, 4096);
    }

    @NotNull
    private byte[] addDgpHead(byte[] buffer) {
        byte[] IABuf = this.DGPack.getAddress().getAddress();
        int DGport = this.DGPack.getPort();
        int HeaderLen = 6 + IABuf.length;
        int DataLen = this.DGPack.getLength();
        int NewPackLen = HeaderLen + DataLen;
        byte[] UB = new byte[NewPackLen];
        UB[0] = 0;
        UB[1] = 0;
        UB[2] = 0;
        UB[3] = 1;
        System.arraycopy(IABuf, 0, UB, 4, IABuf.length);
        UB[4 + IABuf.length] = (byte)(DGport >> 8 & 0xFF);
        UB[5 + IABuf.length] = (byte)(DGport & 0xFF);
        System.arraycopy(buffer, 0, UB, 6 + IABuf.length, DataLen);
        System.arraycopy(UB, 0, buffer, 0, NewPackLen);
        return UB;
    }

    @Nullable
    private byte[] clearDgpHead(byte[] buffer) {
        int IAlen;
        int p = 4;
        byte AType = buffer[3];
        switch (AType) {
            case 1: {
                IAlen = 4;
                break;
            }
            case 3: {
                IAlen = buffer[p] + 1;
                break;
            }
            default: {
                LOGGER.debug("Error in ClearDGPhead() - Invalid Destination IP Addres type " + AType);
                return null;
            }
        }
        byte[] IABuf = new byte[IAlen];
        System.arraycopy(buffer, p, IABuf, 0, IAlen);
        p += IAlen;
        this.UDP_IA = this.calcInetAddress(AType, IABuf);
        this.UDP_port = Utils.calcPort(buffer[p++], buffer[p++]);
        if (this.UDP_IA == null) {
            LOGGER.debug("Error in ClearDGPHead() - Invalid UDP dest IP address: NULL");
            return null;
        }
        int DataLen = this.DGPack.getLength();
        byte[] UB = new byte[DataLen -= p];
        System.arraycopy(buffer, p, UB, 0, DataLen);
        System.arraycopy(UB, 0, buffer, 0, DataLen);
        return UB;
    }

    protected void udpSend(DatagramPacket DGP) {
        if (DGP != null) {
            String LogString = DGP.getAddress() + ":" + DGP.getPort() + "> : " + DGP.getLength() + " bytes";
            try {
                this.DGSocket.send(DGP);
            }
            catch (IOException e) {
                LOGGER.debug("Error in ProcessUDPClient() - Failed to Send DGP to " + LogString);
            }
        }
    }

    public void processUdp() {
        try {
            this.DGSocket.receive(this.DGPack);
        }
        catch (InterruptedIOException e) {
            return;
        }
        catch (IOException e) {
            LOGGER.debug("Error in ProcessUDP() - " + e.toString());
            return;
        }
        if (this.m_ClientIP.equals(this.DGPack.getAddress())) {
            this.processUdpClient();
        } else {
            this.processUdpRemote();
        }
        try {
            this.initUdpInOut();
        }
        catch (IOException e) {
            LOGGER.debug("IOError in Init_UDP_IO() - " + e.toString());
            this.m_Parent.close();
        }
    }

    private void processUdpClient() {
        this.m_nClientPort = this.DGPack.getPort();
        byte[] Buf = this.clearDgpHead(this.DGPack.getData());
        if (Buf == null) {
            return;
        }
        if (Buf.length <= 0) {
            return;
        }
        if (this.UDP_IA == null) {
            LOGGER.debug("Error in ProcessUDPClient() - Invalid Destination IP - NULL");
            return;
        }
        if (this.UDP_port == 0) {
            LOGGER.debug("Error in ProcessUDPClient() - Invalid Destination Port - 0");
            return;
        }
        if (this.m_ServerIP != this.UDP_IA || this.m_nServerPort != this.UDP_port) {
            this.m_ServerIP = this.UDP_IA;
            this.m_nServerPort = this.UDP_port;
        }
        LOGGER.debug("Datagram : " + Buf.length + " bytes : " + Utils.getSocketInfo(this.DGPack) + " >> <" + Utils.iP2Str(this.m_ServerIP) + ":" + this.m_nServerPort + ">");
        DatagramPacket DGPSend = new DatagramPacket(Buf, Buf.length, this.UDP_IA, this.UDP_port);
        this.udpSend(DGPSend);
    }

    public void processUdpRemote() {
        LOGGER.debug(String.format("Datagram : %d bytes : <%s:%d> << %s", this.DGPack.getLength(), Utils.iP2Str(this.m_ClientIP), this.m_nClientPort, Utils.getSocketInfo(this.DGPack)));
        InetAddress DGP_IP = this.DGPack.getAddress();
        int DGP_Port = this.DGPack.getPort();
        byte[] Buf = this.addDgpHead(this.m_Parent.m_Buffer);
        DatagramPacket DGPSend = new DatagramPacket(Buf, Buf.length, this.m_ClientIP, this.m_nClientPort);
        this.udpSend(DGPSend);
        if (DGP_IP != this.UDP_IA || DGP_Port != this.UDP_port) {
            this.m_ServerIP = DGP_IP;
            this.m_nServerPort = DGP_Port;
        }
    }
}

