/*
 * Decompiled with CFR 0.152.
 */
package org.bbottema.clusteredobjectpool.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.Future;
import org.bbottema.clusteredobjectpool.core.ResourcePool;
import org.bbottema.clusteredobjectpool.util.CompositeFuturesAsFutureTask;
import org.bbottema.genericobjectpool.PoolableObject;
import org.bbottema.genericobjectpool.util.Timeout;
import org.jetbrains.annotations.Nullable;

class ResourcePools<PoolKey, T> {
    private final Collection<ResourcePool<PoolKey, T>> clusterCollection;
    private final Collection<ResourcePool<PoolKey, T>> poolsShuttingDown = new ArrayList<ResourcePool<PoolKey, T>>();

    Future<Void> shutdownPool(@Nullable PoolKey key) {
        ArrayList<Future<Void>> poolsShuttingDownFuture = new ArrayList<Future<Void>>();
        Iterator<ResourcePool<PoolKey, T>> iterator = this.clusterCollection.iterator();
        while (iterator.hasNext()) {
            ResourcePool<PoolKey, T> poolInCluster = iterator.next();
            if (key != null && !poolInCluster.getPoolKey().equals(key)) continue;
            poolsShuttingDownFuture.add(poolInCluster.clearPool());
            this.poolsShuttingDown.add(poolInCluster);
            iterator.remove();
        }
        return CompositeFuturesAsFutureTask.ofFutures(poolsShuttingDownFuture);
    }

    boolean containsPool(PoolKey poolKey) {
        return this.findResourcePool(poolKey) != null;
    }

    void add(ResourcePool<PoolKey, T> resourcePool) {
        this.clusterCollection.add(resourcePool);
    }

    @Nullable
    PoolableObject<T> claimResource(PoolKey poolKey, Timeout claimTimeout) throws InterruptedException {
        ResourcePool<PoolKey, T> resourcePool = this.findResourcePool(poolKey);
        if (resourcePool == null) {
            throw new IllegalArgumentException("Couldn't find resource pool with key: " + poolKey);
        }
        return resourcePool.claim(claimTimeout);
    }

    @Nullable
    private ResourcePool<PoolKey, T> findResourcePool(PoolKey poolKey) {
        for (ResourcePool<PoolKey, T> resourcePool : this.clusterCollection) {
            if (!resourcePool.getPoolKey().equals(poolKey)) continue;
            return resourcePool;
        }
        return null;
    }

    int currentlyAllocated() {
        int total = 0;
        for (ResourcePool<PoolKey, T> resourcePool : this.clusterCollection) {
            total += resourcePool.getPoolMetrics().getCurrentlyAllocated();
        }
        for (ResourcePool<PoolKey, T> resourcePool : this.poolsShuttingDown) {
            total += resourcePool.getPoolMetrics().getCurrentlyAllocated();
        }
        return total;
    }

    public ResourcePools(Collection<ResourcePool<PoolKey, T>> clusterCollection) {
        this.clusterCollection = clusterCollection;
    }

    public String toString() {
        return "ResourcePools(clusterCollection=" + this.getClusterCollection() + ", poolsShuttingDown=" + this.poolsShuttingDown + ")";
    }

    Collection<ResourcePool<PoolKey, T>> getClusterCollection() {
        return this.clusterCollection;
    }
}

